/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.enforcer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class SpringCleansingRule
implements EnforcerRule {
    private static final String JAVA = "java";
    private static final String OPTIONAL_SPACER = "(\\s)*";
    private static final String REGEX_DOT = "\\.";
    private static final String OPTIONAL_STATIC = "(static )?";
    private static final String ORG = "org";
    private static final String SPRINGFRAMEWORK = "springframework";
    private static final String SPACER_DOT_SPACER = "(\\s)*\\.(\\s)*";
    private static final String regexImport = "import (static )?(\\s)*org(\\s)*\\.(\\s)*springframework[^;]+;";
    private static final Pattern patternImport = Pattern.compile("import (static )?(\\s)*org(\\s)*\\.(\\s)*springframework[^;]+;");
    private static final String regexCodeLine = "(\\s)*org(\\s)*\\.(\\s)*springframework(.|\\s)+;";
    private static final Pattern patternCodeLine = Pattern.compile("(\\s)*org(\\s)*\\.(\\s)*springframework(.|\\s)+;");
    private static final String STARTED_SCANNING_ORG_SPRINGFRAMEWORK = "Scanning file for org.springframework in file '%s'";
    private static final String FINISHED_SCANNING_ORG_SPRINGFRAMEWORK = "Finished scanning for org.springframework in file '%s'";
    private static final String FOUND_USAGE_OF_ORG_SPRINGFRAMEWORK_IN_IMPORT_AT_LINE = "Found usage of org.springframework in import at line ";
    private static final String FOUND_USAGE_OF_ORG_SPRINGFRAMEWORK_IN_CODE_FRAGMENT_AT_LINE = "Found usage of org.springframework in code fragment at line ";
    private static final String CONTEXT = "context";
    private static final String ANNOTATION = "annotation";
    private static final String CONFIGURATION = "Configuration";
    private static final String SPRING_CONFIGURATION_CLASS = "(\\s)*org(\\s)*\\.(\\s)*springframework(\\s)*\\.(\\s)*context(\\s)*\\.(\\s)*annotation(\\s)*\\.(\\s)*Configuration";
    private static final Pattern patternConfigurationClass = Pattern.compile("(\\s)*org(\\s)*\\.(\\s)*springframework(\\s)*\\.(\\s)*context(\\s)*\\.(\\s)*annotation(\\s)*\\.(\\s)*Configuration");
    private static final String FOUND_UNWANTED_OCCURRENCE_OF_ORG_SPRINGFRAMEWORK = "Found unwanted occurrence of org.springframework at line %d in source '%s'";
    private static final String IN_SOURCE = " in source '";
    private static final String NEW_LINE = "\n";
    private boolean shouldFail = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            List compileSourceRoots = project.getCompileSourceRoots();
            for (Object compileSourceRoot : compileSourceRoots) {
                String path = (String)compileSourceRoot;
                this.applyForJavaSourcesInRoot(path, log);
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public String getCacheId() {
        return "" + this.shouldFail;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule arg0) {
        return false;
    }

    private boolean isSpringConfigurationAnnotatedClass(String contents) {
        Matcher matcher = patternConfigurationClass.matcher(contents);
        return matcher.find();
    }

    private void applyForJavaSourcesInRoot(String path, Log log) throws EnforcerRuleException {
        Iterator fileIterator = FileUtils.iterateFiles((File)new File(path), (String[])new String[]{JAVA}, (boolean)true);
        while (fileIterator.hasNext()) {
            File source = (File)fileIterator.next();
            if (!Files.isRegularFile(source.toPath(), LinkOption.NOFOLLOW_LINKS)) continue;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)String.format(STARTED_SCANNING_ORG_SPRINGFRAMEWORK, source.getAbsolutePath()));
            }
            try {
                String contents = FileUtils.readFileToString((File)source, (String)StandardCharsets.UTF_8.displayName());
                if (this.isSpringConfigurationAnnotatedClass(contents)) {
                    log.info((CharSequence)String.format("Skipping verification for Spring configuration class in file '%s'", source.getAbsolutePath()));
                    continue;
                }
                this.findMatchesUsingPattern(source, log, contents, patternImport, FOUND_USAGE_OF_ORG_SPRINGFRAMEWORK_IN_IMPORT_AT_LINE);
                this.findMatchesUsingPattern(source, log, contents, patternCodeLine, FOUND_USAGE_OF_ORG_SPRINGFRAMEWORK_IN_CODE_FRAGMENT_AT_LINE);
            }
            catch (IOException ignore) {
                log.error((CharSequence)String.format("Could not process file '%s'", source));
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((CharSequence)String.format(FINISHED_SCANNING_ORG_SPRINGFRAMEWORK, source.getAbsolutePath()));
        }
    }

    private void findMatchesUsingPattern(File javaFile, Log log, String contents, Pattern pattern, String message) throws EnforcerRuleException {
        Matcher matcherImportForFile = pattern.matcher(contents);
        if (matcherImportForFile.find()) {
            int lineNumber = this.findLineNumber(contents.substring(0, matcherImportForFile.start()));
            log.info((CharSequence)String.format(FOUND_UNWANTED_OCCURRENCE_OF_ORG_SPRINGFRAMEWORK, lineNumber, javaFile.getAbsolutePath()));
            if (this.shouldFail) {
                throw new EnforcerRuleException(message + String.valueOf(lineNumber) + IN_SOURCE + javaFile.getAbsolutePath() + "'");
            }
        }
    }

    private int findLineNumber(String contents) {
        return StringUtils.countMatches((CharSequence)contents, (CharSequence)NEW_LINE) + 1;
    }
}

