/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.commons.services.impl;

import io.cloudslang.lang.commons.services.api.SlangSourceService;
import io.cloudslang.lang.entities.bindings.values.Value;
import io.cloudslang.lang.entities.bindings.values.ValueFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SlangSourceServiceImpl
implements SlangSourceService {
    @Override
    public Map<String, Value> convertInputFromMap(Map<String, ? extends Serializable> rawMap, String artifact) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        for (Map.Entry<String, ? extends Serializable> property : rawMap.entrySet()) {
            if (property.getValue() instanceof Map) {
                Map valueMap = (Map)((Object)property.getValue());
                this.validateKeys(valueMap, artifact);
                result.put(property.getKey(), ValueFactory.create((Serializable)((Serializable)valueMap.get("value")), (boolean)this.isSensitiveValue(valueMap)));
                continue;
            }
            result.put(property.getKey(), ValueFactory.create((Serializable)property.getValue(), (boolean)false));
        }
        return result;
    }

    private void validateKeys(Map<String, ? extends Serializable> valueMap, String artifact) {
        List<String> knownModifierKeys = Arrays.asList("sensitive", "value");
        for (String modifierKey : valueMap.keySet()) {
            if (knownModifierKeys.contains(modifierKey)) continue;
            throw new RuntimeException("Artifact {" + artifact + "} has unrecognized tag {" + modifierKey + "}. Please take a look at the supported features per versions link");
        }
    }

    private Boolean isSensitiveValue(Map<String, ? extends Serializable> valueMap) {
        Boolean isSensitive = false;
        if (valueMap.get("sensitive") instanceof Boolean) {
            isSensitive = (Boolean)valueMap.get("sensitive");
        }
        return isSensitive;
    }
}

