/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.rules.spring;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.properties.HasName;
import io.cloudflight.cleancode.archunit.rules.spring.SpringClassUtilsKt;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.repository.Repository;
import org.springframework.transaction.annotation.Propagation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0005J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\bJ\u001b\u0010\u000f\u001a\u0004\u0018\u00010\b*\u00020\u00102\u0006\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\f\u0010\u0014\u001a\u00020\b*\u00020\u0005H\u0002J\f\u0010\u0014\u001a\u00020\b*\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\b*\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u0017\u00a8\u0006\u001a"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/TransactionalHelper;", "", "()V", "ifArchUnitVerifierPluginContainsOwnerGetAllSubClassesOfOwner", "", "Lcom/tngtech/archunit/core/domain/JavaClass;", "owner", "isTransactional", "", "accessTarget", "Lcom/tngtech/archunit/core/domain/AccessTarget;", "codeUnit", "Lcom/tngtech/archunit/core/domain/JavaCodeUnit;", "checkOwner", "checkSubClasses", "checkOtherImplementationsIfTransactional", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "(Lcom/tngtech/archunit/core/domain/JavaMethod;Z)Ljava/lang/Boolean;", "getOverriddenMethodFromSubclass", "subClass", "isAnnotatedOrMetaAnnotatedWithTransactional", "isOwnerAnnotatedOrMetaAnnotatedWithTransactional", "isTransactionalFunctionOrInRepositoryClass", "Lcom/tngtech/archunit/core/domain/JavaAccess;", "JakartaTransactionalAnnotation", "TransactionalAnnotation", "archunit-cleancode-verifier"})
@SourceDebugExtension(value={"SMAP\nTransactionalUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionalUtils.kt\nio/cloudflight/cleancode/archunit/rules/spring/TransactionalHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1#2:195\n1747#3,3:196\n*S KotlinDebug\n*F\n+ 1 TransactionalUtils.kt\nio/cloudflight/cleancode/archunit/rules/spring/TransactionalHelper\n*L\n165#1:196,3\n*E\n"})
public final class TransactionalHelper {
    @NotNull
    public static final TransactionalHelper INSTANCE = new TransactionalHelper();

    private TransactionalHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTransactional(@NotNull AccessTarget accessTarget) {
        Intrinsics.checkNotNullParameter((Object)accessTarget, (String)"accessTarget");
        if (!accessTarget.resolveMember().isPresent()) return false;
        if (!(accessTarget instanceof AccessTarget.MethodCallTarget)) return false;
        Object t = ((AccessTarget.MethodCallTarget)accessTarget).resolveMember().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        if (!this.isTransactional((JavaCodeUnit)t, true, true)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isTransactional(@NotNull JavaCodeUnit codeUnit, boolean checkOwner, boolean checkSubClasses) {
        JavaCodeUnit javaCodeUnit;
        Intrinsics.checkNotNullParameter((Object)codeUnit, (String)"codeUnit");
        if (this.isAnnotatedOrMetaAnnotatedWithTransactional(codeUnit)) {
            return true;
        }
        if (checkOwner && this.isOwnerAnnotatedOrMetaAnnotatedWithTransactional(codeUnit)) {
            return true;
        }
        JavaCodeUnit it = javaCodeUnit = codeUnit;
        boolean bl = false;
        if (!checkSubClasses) return false;
        if (!(it instanceof JavaMethod)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        JavaCodeUnit javaCodeUnit2 = javaCodeUnit;
        JavaCodeUnit javaCodeUnit3 = javaCodeUnit2;
        if (javaCodeUnit3 == null) return false;
        JavaCodeUnit it2 = javaCodeUnit3;
        boolean bl3 = false;
        javaCodeUnit = (JavaMethod)it2;
        Boolean bl4 = this.checkOtherImplementationsIfTransactional((JavaMethod)javaCodeUnit, checkOwner);
        if (bl4 == null) return false;
        boolean bl5 = bl4;
        return bl5;
    }

    public static /* synthetic */ boolean isTransactional$default(TransactionalHelper transactionalHelper, JavaCodeUnit javaCodeUnit, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return transactionalHelper.isTransactional(javaCodeUnit, bl, bl2);
    }

    public final boolean isTransactional(@NotNull JavaClass codeUnit) {
        Intrinsics.checkNotNullParameter((Object)codeUnit, (String)"codeUnit");
        return this.isAnnotatedOrMetaAnnotatedWithTransactional(codeUnit);
    }

    private final boolean isAnnotatedOrMetaAnnotatedWithTransactional(JavaCodeUnit $this$isAnnotatedOrMetaAnnotatedWithTransactional) {
        return $this$isAnnotatedOrMetaAnnotatedWithTransactional.isAnnotatedWith((DescribedPredicate)new TransactionalAnnotation()) || $this$isAnnotatedOrMetaAnnotatedWithTransactional.isMetaAnnotatedWith((DescribedPredicate)new TransactionalAnnotation());
    }

    private final boolean isOwnerAnnotatedOrMetaAnnotatedWithTransactional(JavaCodeUnit $this$isOwnerAnnotatedOrMetaAnnotatedWithTransactional) {
        return $this$isOwnerAnnotatedOrMetaAnnotatedWithTransactional.getOwner().isAnnotatedWith((DescribedPredicate)new TransactionalAnnotation()) || $this$isOwnerAnnotatedOrMetaAnnotatedWithTransactional.getOwner().isMetaAnnotatedWith((DescribedPredicate)new TransactionalAnnotation());
    }

    private final boolean isAnnotatedOrMetaAnnotatedWithTransactional(JavaClass $this$isAnnotatedOrMetaAnnotatedWithTransactional) {
        return $this$isAnnotatedOrMetaAnnotatedWithTransactional.isAnnotatedWith((DescribedPredicate)new TransactionalAnnotation()) || $this$isAnnotatedOrMetaAnnotatedWithTransactional.isMetaAnnotatedWith((DescribedPredicate)new TransactionalAnnotation());
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean checkOtherImplementationsIfTransactional(JavaMethod $this$checkOtherImplementationsIfTransactional, boolean checkOwner) {
        Boolean bl;
        JavaClass javaClass = $this$checkOtherImplementationsIfTransactional.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)javaClass, (String)"getOwner(...)");
        Set<JavaClass> set = this.ifArchUnitVerifierPluginContainsOwnerGetAllSubClassesOfOwner(javaClass);
        if (set != null) {
            boolean bl2;
            block7: {
                void $this$any$iv;
                Iterable iterable = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl3;
                        JavaClass subClass = (JavaClass)element$iv;
                        boolean bl4 = false;
                        JavaMethod javaMethod = INSTANCE.getOverriddenMethodFromSubclass((JavaCodeUnit)$this$checkOtherImplementationsIfTransactional, subClass);
                        if (javaMethod != null) {
                            JavaMethod it = javaMethod;
                            boolean bl5 = false;
                            bl3 = TransactionalHelper.isTransactional$default(INSTANCE, (JavaCodeUnit)it, checkOwner, false, 4, null);
                        } else {
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = null;
        }
        return bl;
    }

    private final JavaMethod getOverriddenMethodFromSubclass(JavaCodeUnit $this$getOverriddenMethodFromSubclass, JavaClass subClass) {
        Object v1;
        block1: {
            Set set = subClass.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getMethods(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                JavaMethod it = (JavaMethod)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$getOverriddenMethodFromSubclass.getName()) && Intrinsics.areEqual((Object)HasName.Utils.namesOf((Iterable)it.getRawParameterTypes()), (Object)HasName.Utils.namesOf((Iterable)$this$getOverriddenMethodFromSubclass.getRawParameterTypes())))) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final Set<JavaClass> ifArchUnitVerifierPluginContainsOwnerGetAllSubClassesOfOwner(JavaClass owner) {
        return owner.getAllSubclasses();
    }

    public final boolean isTransactionalFunctionOrInRepositoryClass(@NotNull JavaAccess<?> $this$isTransactionalFunctionOrInRepositoryClass) {
        Intrinsics.checkNotNullParameter($this$isTransactionalFunctionOrInRepositoryClass, (String)"<this>");
        AccessTarget accessTarget = $this$isTransactionalFunctionOrInRepositoryClass.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)accessTarget, (String)"getTarget(...)");
        return this.isTransactional(accessTarget) || $this$isTransactionalFunctionOrInRepositoryClass.getTarget().getOwner().isAssignableTo(Repository.class) || $this$isTransactionalFunctionOrInRepositoryClass.getTarget().getOwner().isAssignableTo("org.springframework.data.repository.CrudRepositoryExtensionsKt");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/TransactionalHelper$JakartaTransactionalAnnotation;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaAnnotation;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    public static final class JakartaTransactionalAnnotation
    extends DescribedPredicate<JavaAnnotation<?>> {
        public JakartaTransactionalAnnotation() {
            super("", new Object[0]);
        }

        public boolean test(@NotNull JavaAnnotation<?> input) {
            Intrinsics.checkNotNullParameter(input, (String)"input");
            return SpringClassUtilsKt.toAnnotation(input, Transactional.class) != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/TransactionalHelper$TransactionalAnnotation;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaAnnotation;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    @SourceDebugExtension(value={"SMAP\nTransactionalUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionalUtils.kt\nio/cloudflight/cleancode/archunit/rules/spring/TransactionalHelper$TransactionalAnnotation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
    public static final class TransactionalAnnotation
    extends DescribedPredicate<JavaAnnotation<?>> {
        public TransactionalAnnotation() {
            super("", new Object[0]);
        }

        public boolean test(@NotNull JavaAnnotation<?> input) {
            boolean bl;
            Intrinsics.checkNotNullParameter(input, (String)"input");
            org.springframework.transaction.annotation.Transactional transactional = SpringClassUtilsKt.toAnnotation(input, org.springframework.transaction.annotation.Transactional.class);
            if (transactional != null) {
                org.springframework.transaction.annotation.Transactional it = transactional;
                boolean bl2 = false;
                bl = it.propagation() != Propagation.NEVER;
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

