/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.rules.spring;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.junit.ArchTests;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import io.cloudflight.cleancode.archunit.ArchRuleWithId;
import io.cloudflight.cleancode.archunit.rules.spring.JakartaTransactionalRules;
import io.cloudflight.cleancode.archunit.rules.spring.SpringCacheableRules;
import io.cloudflight.cleancode.archunit.rules.spring.SpringClassUtilsKt;
import io.cloudflight.cleancode.archunit.rules.spring.SpringTransactionalControllerRules;
import io.cloudflight.cleancode.archunit.rules.spring.SpringTransactionalRepositoryRules;
import io.cloudflight.cleancode.archunit.rules.spring.SpringTransactionalRules;
import io.cloudflight.cleancode.archunit.rules.spring.SpringWebRules;
import io.cloudflight.cleancode.archunit.utils.ClassUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0016\u0010\u000f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0016\u0010\u0011\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0016\u0010\u0013\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0018"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringRuleSet;", "", "()V", "do_not_make_components_final", "Lcom/tngtech/archunit/lang/ArchRule;", "getDo_not_make_components_final", "()Lcom/tngtech/archunit/lang/ArchRule;", "jakartaTransactional", "Lcom/tngtech/archunit/junit/ArchTests;", "getJakartaTransactional", "()Lcom/tngtech/archunit/junit/ArchTests;", "springCacheableRules", "getSpringCacheableRules", "springTransactional", "getSpringTransactional", "springTransactionalController", "getSpringTransactionalController", "springTransactionalRepositoryRules", "getSpringTransactionalRepositoryRules", "springWeb", "getSpringWeb", "AreComponents", "ComponentAnnotation", "NotBeFinal", "archunit-cleancode-verifier"})
public final class SpringRuleSet {
    @ArchTest
    @NotNull
    private final ArchRule do_not_make_components_final;
    @ArchTest
    @NotNull
    private final ArchTests jakartaTransactional;
    @ArchTest
    @NotNull
    private final ArchTests springTransactional;
    @ArchTest
    @NotNull
    private final ArchTests springTransactionalController;
    @ArchTest
    @NotNull
    private final ArchTests springTransactionalRepositoryRules;
    @ArchTest
    @NotNull
    private final ArchTests springWeb;
    @ArchTest
    @NotNull
    private final ArchTests springCacheableRules;

    public SpringRuleSet() {
        ClassesShouldConjunction classesShouldConjunction = ArchRuleDefinition.classes().that((DescribedPredicate)new AreComponents()).should((ArchCondition)new NotBeFinal());
        Intrinsics.checkNotNullExpressionValue((Object)classesShouldConjunction, (String)"should(...)");
        this.do_not_make_components_final = ArchRuleWithId.Companion.archRuleWithId("spring.context-no-final-components", (ArchRule)classesShouldConjunction);
        String[] stringArray = new String[]{"jakarta.transaction.Transactional"};
        this.jakartaTransactional = ClassUtilsKt.ruleSetOf(JakartaTransactionalRules.class, stringArray);
        stringArray = new String[]{"org.springframework.transaction.annotation.Transactional"};
        this.springTransactional = ClassUtilsKt.ruleSetOf(SpringTransactionalRules.class, stringArray);
        stringArray = new String[]{"org.springframework.transaction.annotation.Transactional", "org.springframework.web.bind.annotation.RestController"};
        this.springTransactionalController = ClassUtilsKt.ruleSetOf(SpringTransactionalControllerRules.class, stringArray);
        stringArray = new String[]{"org.springframework.transaction.annotation.Transactional", "org.springframework.data.jpa.repository.JpaRepository"};
        this.springTransactionalRepositoryRules = ClassUtilsKt.ruleSetOf(SpringTransactionalRepositoryRules.class, stringArray);
        stringArray = new String[]{"org.springframework.web.bind.annotation.RequestMapping"};
        this.springWeb = ClassUtilsKt.ruleSetOf(SpringWebRules.class, stringArray);
        stringArray = new String[]{"org.springframework.cache.annotation.CachePut"};
        this.springCacheableRules = ClassUtilsKt.ruleSetOf(SpringCacheableRules.class, stringArray);
    }

    @NotNull
    public final ArchRule getDo_not_make_components_final() {
        return this.do_not_make_components_final;
    }

    @NotNull
    public final ArchTests getJakartaTransactional() {
        return this.jakartaTransactional;
    }

    @NotNull
    public final ArchTests getSpringTransactional() {
        return this.springTransactional;
    }

    @NotNull
    public final ArchTests getSpringTransactionalController() {
        return this.springTransactionalController;
    }

    @NotNull
    public final ArchTests getSpringTransactionalRepositoryRules() {
        return this.springTransactionalRepositoryRules;
    }

    @NotNull
    public final ArchTests getSpringWeb() {
        return this.springWeb;
    }

    @NotNull
    public final ArchTests getSpringCacheableRules() {
        return this.springCacheableRules;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringRuleSet$AreComponents;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaClass;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    private static final class AreComponents
    extends DescribedPredicate<JavaClass> {
        public AreComponents() {
            super("are @Component", new Object[0]);
        }

        public boolean test(@NotNull JavaClass input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return input.isAnnotatedWith((DescribedPredicate)new ComponentAnnotation());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringRuleSet$ComponentAnnotation;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaAnnotation;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    private static final class ComponentAnnotation
    extends DescribedPredicate<JavaAnnotation<?>> {
        public ComponentAnnotation() {
            super("", new Object[0]);
        }

        public boolean test(@NotNull JavaAnnotation<?> input) {
            Intrinsics.checkNotNullParameter(input, (String)"input");
            return SpringClassUtilsKt.toAnnotation(input, Component.class) != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringRuleSet$NotBeFinal;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaClass;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "archunit-cleancode-verifier"})
    private static final class NotBeFinal
    extends ArchCondition<JavaClass> {
        public NotBeFinal() {
            super("must not be final", new Object[0]);
        }

        public void check(@NotNull JavaClass item, @NotNull ConditionEvents events) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            if (item.getModifiers().contains(JavaModifier.FINAL)) {
                events.add(SimpleConditionEvent.violated((Object)item, (String)("ADR-0015: " + item + " must not be final")));
            }
        }
    }
}

