/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit.rules.spring;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.ClassesShouldConjunction;
import io.cloudflight.cleancode.archunit.ArchRuleWithId;
import io.cloudflight.cleancode.archunit.rules.spring.SpringClassUtilsKt;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringCacheableRules;", "", "()V", "cacheable_methods_should_not_be_called_from_functions_in_same_class", "Lcom/tngtech/archunit/lang/ArchRule;", "getCacheable_methods_should_not_be_called_from_functions_in_same_class", "()Lcom/tngtech/archunit/lang/ArchRule;", "CacheAnnotation", "NotBeCalledFromAnotherFunctionInSameClass", "archunit-cleancode-verifier"})
public final class SpringCacheableRules {
    @ArchTest
    @NotNull
    private final ArchRule cacheable_methods_should_not_be_called_from_functions_in_same_class;

    public SpringCacheableRules() {
        ClassesShouldConjunction classesShouldConjunction = ArchRuleDefinition.classes().should((ArchCondition)new NotBeCalledFromAnotherFunctionInSameClass());
        Intrinsics.checkNotNullExpressionValue((Object)classesShouldConjunction, (String)"should(...)");
        this.cacheable_methods_should_not_be_called_from_functions_in_same_class = ArchRuleWithId.Companion.archRuleWithId("spring.context-cacheable-annotated-functions-should-not-be-called-from-function-in-same-class", (ArchRule)classesShouldConjunction);
    }

    @NotNull
    public final ArchRule getCacheable_methods_should_not_be_called_from_functions_in_same_class() {
        return this.cacheable_methods_should_not_be_called_from_functions_in_same_class;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringCacheableRules$CacheAnnotation;", "Lcom/tngtech/archunit/base/DescribedPredicate;", "Lcom/tngtech/archunit/core/domain/JavaAnnotation;", "()V", "test", "", "input", "archunit-cleancode-verifier"})
    public static final class CacheAnnotation
    extends DescribedPredicate<JavaAnnotation<?>> {
        public CacheAnnotation() {
            super("", new Object[0]);
        }

        public boolean test(@NotNull JavaAnnotation<?> input) {
            Annotation annotation;
            Intrinsics.checkNotNullParameter(input, (String)"input");
            Cacheable cacheable = SpringClassUtilsKt.toAnnotation(input, Cacheable.class);
            if (cacheable != null) {
                annotation = (Annotation)cacheable;
            } else {
                CachePut cachePut = SpringClassUtilsKt.toAnnotation(input, CachePut.class);
                annotation = cachePut != null ? (Annotation)cachePut : SpringClassUtilsKt.toAnnotation(input, CacheEvict.class);
            }
            return annotation != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lio/cloudflight/cleancode/archunit/rules/spring/SpringCacheableRules$NotBeCalledFromAnotherFunctionInSameClass;", "Lcom/tngtech/archunit/lang/ArchCondition;", "Lcom/tngtech/archunit/core/domain/JavaClass;", "()V", "check", "", "item", "events", "Lcom/tngtech/archunit/lang/ConditionEvents;", "getFunctionCallingCacheableFunctionInSameClass", "Lcom/tngtech/archunit/lang/ConditionEvent;", "Lcom/tngtech/archunit/core/domain/JavaMethod;", "archunit-cleancode-verifier"})
    @SourceDebugExtension(value={"SMAP\nSpringCacheableRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringCacheableRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringCacheableRules$NotBeCalledFromAnotherFunctionInSameClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1603#2,9:60\n1855#2:69\n1856#2:71\n1612#2:72\n1855#2,2:73\n1#3:70\n1#3:75\n*S KotlinDebug\n*F\n+ 1 SpringCacheableRules.kt\nio/cloudflight/cleancode/archunit/rules/spring/SpringCacheableRules$NotBeCalledFromAnotherFunctionInSameClass\n*L\n36#1:60,9\n36#1:69\n36#1:71\n36#1:72\n37#1:73,2\n36#1:70\n*E\n"})
    private static final class NotBeCalledFromAnotherFunctionInSameClass
    extends ArchCondition<JavaClass> {
        public NotBeCalledFromAnotherFunctionInSameClass() {
            super("not be called from another function inside same class", new Object[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void check(@NotNull JavaClass item, @NotNull ConditionEvents events) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            Set set = item.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getMethods(...)");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ConditionEvent it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JavaMethod it = (JavaMethod)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (this.getFunctionCallingCacheableFunctionInSameClass(it, item) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                ConditionEvent it = (ConditionEvent)element$iv;
                boolean bl = false;
                events.add(it);
            }
        }

        private final ConditionEvent getFunctionCallingCacheableFunctionInSameClass(JavaMethod $this$getFunctionCallingCacheableFunctionInSameClass, JavaClass item) {
            ConditionEvent conditionEvent;
            Object v1;
            block3: {
                Set set = $this$getFunctionCallingCacheableFunctionInSameClass.getMethodCallsFromSelf();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getMethodCallsFromSelf(...)");
                Iterable iterable = set;
                for (Object t : iterable) {
                    JavaMethodCall it = (JavaMethodCall)t;
                    boolean bl = false;
                    if (!(((AccessTarget.MethodCallTarget)it.getTarget()).isAnnotatedWith((DescribedPredicate)new CacheAnnotation()) && Intrinsics.areEqual((Object)((AccessTarget.MethodCallTarget)it.getTarget()).getOwner(), (Object)item))) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            JavaMethodCall javaMethodCall = v1;
            if (javaMethodCall != null) {
                JavaMethodCall it = javaMethodCall;
                boolean bl = false;
                conditionEvent = SimpleConditionEvent.violated((Object)item, (String)($this$getFunctionCallingCacheableFunctionInSameClass.getName() + " is calling a Cacheable function (" + ((AccessTarget.MethodCallTarget)it.getTarget()).getFullName() + ") inside same Class"));
            } else {
                conditionEvent = null;
            }
            return conditionEvent;
        }
    }
}

