/*
 * Decompiled with CFR 0.152.
 */
package io.cloudflight.cleancode.archunit;

import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.library.freeze.ViolationStore;
import io.cloudflight.cleancode.archunit.ArchRuleWithId;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0014H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/cloudflight/cleancode/archunit/IdBasedViolationStore;", "Lcom/tngtech/archunit/library/freeze/ViolationStore;", "()V", "KNOWN_CLEAN_CODE_RULES_FILE", "", "REMOVED_RULES", "", "knownRules", "", "knownRulesFile", "Ljava/nio/file/Path;", "storeFolder", "storeUpdateAllowed", "", "contains", "rule", "Lcom/tngtech/archunit/lang/ArchRule;", "getViolations", "", "getViolationsFile", "Lio/cloudflight/cleancode/archunit/ArchRuleWithId;", "ruleId", "initialize", "", "properties", "Ljava/util/Properties;", "save", "violations", "archunit-cleancode-verifier"})
@SourceDebugExtension(value={"SMAP\nIdBasedViolationStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdBasedViolationStore.kt\nio/cloudflight/cleancode/archunit/IdBasedViolationStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1855#2,2:134\n*S KotlinDebug\n*F\n+ 1 IdBasedViolationStore.kt\nio/cloudflight/cleancode/archunit/IdBasedViolationStore\n*L\n61#1:134,2\n*E\n"})
public final class IdBasedViolationStore
implements ViolationStore {
    @NotNull
    public static final IdBasedViolationStore INSTANCE = new IdBasedViolationStore();
    private static Set<String> knownRules;
    private static boolean storeUpdateAllowed;
    private static Path storeFolder;
    private static Path knownRulesFile;
    @NotNull
    public static final String KNOWN_CLEAN_CODE_RULES_FILE = "knownCleanCodeRules.txt";
    @NotNull
    private static final Set<String> REMOVED_RULES;

    private IdBasedViolationStore() {
    }

    public void initialize(@NotNull Properties properties) {
        Path path;
        Object object;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        String string = properties.getProperty("default.allowStoreUpdate", "true");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        storeUpdateAllowed = StringsKt.toBooleanStrict((String)string);
        LinkOption[] it = object = Paths.get(properties.getProperty("default.path", "archunit_store"), new String[0]);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)it, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"also(...)");
        storeFolder = object;
        Path path2 = storeFolder;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"storeFolder");
            path2 = null;
        }
        Path path3 = path2.resolve(KNOWN_CLEAN_CODE_RULES_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        knownRulesFile = path3;
        Path path4 = knownRulesFile;
        if (path4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"knownRulesFile");
            path4 = null;
        }
        if (Files.exists(path = path4, Arrays.copyOf(object = new LinkOption[0], ((LinkOption[])object).length))) {
            Path path5 = knownRulesFile;
            if (path5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"knownRulesFile");
                path5 = null;
            }
            object = path5;
            List<String> list = Files.readAllLines((Path)object, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            List fileContent = CollectionsKt.toMutableList((Collection)list);
            boolean removedRules = false;
            Iterable $this$forEach$iv = REMOVED_RULES;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String removedRule = (String)element$iv;
                boolean bl2 = false;
                if (!fileContent.contains(removedRule)) continue;
                fileContent.remove(removedRule);
                Files.deleteIfExists(INSTANCE.getViolationsFile(removedRule));
                removedRules = true;
            }
            if (removedRules) {
                Path path6 = knownRulesFile;
                if (path6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"knownRulesFile");
                    path6 = null;
                }
                Path path7 = path6;
                Charset charset = Charsets.UTF_8;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(path7, (Iterable<? extends CharSequence>)fileContent, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
            }
            knownRules = CollectionsKt.toMutableSet((Iterable)fileContent);
        } else {
            Path path8 = knownRulesFile;
            if (path8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"knownRulesFile");
                path8 = null;
            }
            path = path8;
            object = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path, (FileAttribute[])Arrays.copyOf(object, ((LinkOption[])object).length)), (String)"createFile(...)");
            knownRules = new LinkedHashSet();
        }
    }

    public boolean contains(@NotNull ArchRule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        if (rule instanceof ArchRuleWithId) {
            Set<String> set = knownRules;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"knownRules");
                set = null;
            }
            return set.contains(((ArchRuleWithId)rule).getId());
        }
        throw new IllegalArgumentException("Expected ArchRuleWithId");
    }

    public void save(@NotNull ArchRule rule, @NotNull List<String> violations) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter(violations, (String)"violations");
        if (!storeUpdateAllowed) {
            throw new IllegalArgumentException("Updating frozen violations is disabled");
        }
        if (rule instanceof ArchRuleWithId) {
            OpenOption[] openOptionArray;
            Charset charset;
            Iterable<Path> iterable;
            Set<String> set = knownRules;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"knownRules");
                set = null;
            }
            if (!set.contains(((ArchRuleWithId)rule).getId())) {
                Set<String> set2 = knownRules;
                if (set2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"knownRules");
                    set2 = null;
                }
                set2.add(((ArchRuleWithId)rule).getId());
                Path path = knownRulesFile;
                if (path == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"knownRulesFile");
                    path = null;
                }
                Path path2 = path;
                iterable = CollectionsKt.listOf((Object)((ArchRuleWithId)rule).getId());
                charset = Charsets.UTF_8;
                openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)iterable, charset, openOptionArray), (String)"write(...)");
            }
            Path violationsFile = this.getViolationsFile((ArchRuleWithId)rule);
            if (!((Collection)violations).isEmpty()) {
                iterable = violationsFile;
                charset = Charsets.UTF_8;
                openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(iterable, (Iterable<? extends CharSequence>)violations, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
            } else {
                Files.deleteIfExists(violationsFile);
            }
        } else {
            throw new IllegalArgumentException("Expected ArchRuleWithId");
        }
    }

    @NotNull
    public List<String> getViolations(@NotNull ArchRule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        if (rule instanceof ArchRuleWithId) {
            Path violationsFile = this.getViolationsFile((ArchRuleWithId)rule);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(violationsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path = violationsFile;
                List<String> list = Files.readAllLines(path, Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                return list;
            }
            return CollectionsKt.emptyList();
        }
        throw new IllegalArgumentException("Expected ArchRuleWithId");
    }

    private final Path getViolationsFile(ArchRuleWithId rule) {
        return this.getViolationsFile(rule.getId());
    }

    private final Path getViolationsFile(String ruleId) {
        Path path = storeFolder;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"storeFolder");
            path = null;
        }
        Path path2 = path.resolve(ruleId);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    static {
        REMOVED_RULES = SetsKt.setOf((Object)"spring.tx-transactional-methods-should-not-be-cacheable");
    }
}

