/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql;

import java.util.Objects;

public enum Type {
    INTEGER(Integer.class),
    STRING(String.class),
    BOOLEAN(Boolean.class),
    ANY(Object.class);

    private final Class<?> clazz;

    private Type(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> valueClass() {
        return this.clazz;
    }

    public static Type fromValue(Object value) {
        Objects.requireNonNull(value);
        return Type.fromClass(value.getClass());
    }

    public static Type fromClass(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        if (Integer.class.equals(clazz)) {
            return INTEGER;
        }
        if (String.class.equals(clazz)) {
            return STRING;
        }
        if (Boolean.class.equals(clazz)) {
            return BOOLEAN;
        }
        return ANY;
    }
}

