/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.functions;

import io.cloudevents.CloudEvent;
import io.cloudevents.sql.EvaluationContext;
import io.cloudevents.sql.EvaluationRuntime;
import io.cloudevents.sql.impl.ExceptionFactory;
import io.cloudevents.sql.impl.functions.BaseThreeArgumentFunction;

public class SubstringWithLengthFunction
extends BaseThreeArgumentFunction<String, Integer, Integer> {
    public SubstringWithLengthFunction() {
        super("SUBSTRING", String.class, Integer.class, Integer.class);
    }

    @Override
    Object invoke(EvaluationContext ctx, EvaluationRuntime evaluationRuntime, CloudEvent event, String x, Integer pos, Integer len) {
        try {
            return SubstringWithLengthFunction.substring(x, pos, len);
        }
        catch (Exception e) {
            ctx.appendException(ExceptionFactory.functionExecutionError(this.name(), e));
            return "";
        }
    }

    static String substring(String x, Integer pos, Integer len) throws IllegalArgumentException {
        if (pos == 0) {
            return "";
        }
        if (pos < -x.length() || pos > x.length()) {
            throw new IllegalArgumentException("The pos argument is out of bounds: " + pos);
        }
        int beginning = pos < 0 ? x.length() + pos : pos - 1;
        int end = len == null || beginning + len > x.length() ? x.length() : beginning + len;
        return x.substring(beginning, end);
    }
}

