/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.messaging;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.impl.StringUtils;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import java.util.Map;
import java.util.function.BiConsumer;

class MessageBinaryMessageReader
extends BaseGenericBinaryMessageReaderImpl<String, Object> {
    private final Map<String, Object> headers;

    public MessageBinaryMessageReader(SpecVersion version, Map<String, Object> headers, byte[] payload) {
        super(version, (CloudEventData)(payload == null ? null : BytesCloudEventData.wrap((byte[])payload)));
        this.headers = headers;
    }

    public MessageBinaryMessageReader(SpecVersion version, Map<String, Object> headers) {
        this(version, headers, null);
    }

    protected boolean isContentTypeHeader(String key) {
        return "contentType".equalsIgnoreCase(key);
    }

    protected boolean isCloudEventsHeader(String key) {
        return key != null && key.length() > "ce-".length() && StringUtils.startsWithIgnoreCase((String)key, (String)"ce-");
    }

    protected String toCloudEventsKey(String key) {
        return key.substring("ce-".length()).toLowerCase();
    }

    protected void forEachHeader(BiConsumer<String, Object> fn) {
        this.headers.forEach((k, v) -> fn.accept((String)k, v));
    }

    protected String toCloudEventsValue(Object value) {
        return value.toString();
    }
}

