/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.rocketmq;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.rocketmq.RocketmqConstants;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageBuilder;

final class RocketmqMessageWriter
implements MessageWriter<CloudEventWriter<Message>, Message>,
CloudEventWriter<Message> {
    private final Map<String, String> messageProperties = new HashMap<String, String>();
    private final MessageBuilder messageBuilder;

    RocketmqMessageWriter(String topic) {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        this.messageBuilder = provider.newMessageBuilder();
        this.messageBuilder.setTopic(topic);
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        if (name.equals("datacontenttype")) {
            this.messageProperties.put("CE_contenttype", value);
            return this;
        }
        String propertyName = RocketmqConstants.ATTRIBUTES_TO_PROPERTY_NAMES.get(name);
        if (propertyName == null) {
            propertyName = name;
        }
        this.messageProperties.put(propertyName, value);
        return this;
    }

    public CloudEventWriter<Message> create(SpecVersion version) throws CloudEventRWException {
        this.messageProperties.put(RocketmqConstants.MESSAGE_PROPERTY_SPEC_VERSION, version.toString());
        return this;
    }

    public Message setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.messageProperties.put("CE_contenttype", format.serializedContentType());
        this.messageBuilder.setBody(value);
        this.messageProperties.forEach((arg_0, arg_1) -> ((MessageBuilder)this.messageBuilder).addProperty(arg_0, arg_1));
        return this.messageBuilder.build();
    }

    public Message end(CloudEventData data) throws CloudEventRWException {
        this.messageBuilder.setBody(data.toBytes());
        this.messageProperties.forEach((arg_0, arg_1) -> ((MessageBuilder)this.messageBuilder).addProperty(arg_0, arg_1));
        return this.messageBuilder.build();
    }

    public Message end() throws CloudEventRWException {
        this.messageBuilder.setBody(RocketmqConstants.EMPTY_BODY);
        this.messageProperties.forEach((arg_0, arg_1) -> ((MessageBuilder)this.messageBuilder).addProperty(arg_0, arg_1));
        return this.messageBuilder.build();
    }
}

