/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka;

import io.cloudevents.Attributes;
import io.cloudevents.CloudEvent;
import io.cloudevents.format.Wire;
import io.cloudevents.format.builder.EventStep;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;

public class CloudEventsKafkaHeaders {
    public static <T, A extends Attributes> Iterable<Header> buildHeaders(CloudEvent<A, T> event, EventStep<A, T, byte[], byte[]> builder) {
        return CloudEventsKafkaHeaders.getHeaders(event, builder);
    }

    private static <T, A extends Attributes> Iterable<Header> getHeaders(CloudEvent<A, T> event, EventStep<A, T, byte[], byte[]> marshaller) {
        Wire marshal = marshaller.withEvent(() -> event).marshal();
        Map headers = marshal.getHeaders();
        return CloudEventsKafkaHeaders.marshal(headers);
    }

    static Set<Header> marshal(Map<String, byte[]> headers) {
        return headers.entrySet().stream().map(header -> new AbstractMap.SimpleEntry(header.getKey(), header.getValue())).map(header -> new RecordHeader((String)header.getKey(), (byte[])header.getValue())).collect(Collectors.toSet());
    }
}

