/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.impl.CloudEventUtils;
import io.cloudevents.jackson.JsonCloudEventData;
import io.cloudevents.jackson.JsonFormat;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class CloudEventSerializer
extends StdSerializer<CloudEvent> {
    private final boolean forceDataBase64Serialization;
    private final boolean forceStringSerialization;

    protected CloudEventSerializer(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        super(CloudEvent.class);
        this.forceDataBase64Serialization = forceDataBase64Serialization;
        this.forceStringSerialization = forceStringSerialization;
    }

    public void serialize(CloudEvent value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("specversion", value.getSpecVersion().toString());
        try {
            CloudEventReader visitable = CloudEventUtils.toVisitable((CloudEvent)value);
            FieldsSerializer serializer = new FieldsSerializer(gen, provider);
            visitable.readAttributes((CloudEventAttributesWriter)serializer);
            visitable.readExtensions((CloudEventExtensionsWriter)serializer);
        }
        catch (RuntimeException e) {
            throw (IOException)e.getCause();
        }
        if (value.getData() != null) {
            CloudEventData data = value.getData();
            if (data instanceof JsonCloudEventData) {
                gen.writeObjectField("data", (Object)((JsonCloudEventData)data).getNode());
            } else {
                byte[] dataBytes = data.toBytes();
                String contentType = value.getDataContentType();
                if (this.shouldSerializeBase64(contentType)) {
                    switch (value.getSpecVersion()) {
                        case V03: {
                            gen.writeStringField("datacontentencoding", "base64");
                            gen.writeFieldName("data");
                            gen.writeBinary(dataBytes);
                            break;
                        }
                        case V1: {
                            gen.writeFieldName("data_base64");
                            gen.writeBinary(dataBytes);
                        }
                    }
                } else if (JsonFormat.dataIsJsonContentType(contentType)) {
                    char[] dataAsString = new String(dataBytes, StandardCharsets.UTF_8).toCharArray();
                    gen.writeFieldName("data");
                    gen.writeRawValue(dataAsString, 0, dataAsString.length);
                } else {
                    gen.writeFieldName("data");
                    gen.writeUTF8String(dataBytes, 0, dataBytes.length);
                }
            }
        }
        gen.writeEndObject();
    }

    private boolean shouldSerializeBase64(String contentType) {
        if (JsonFormat.dataIsJsonContentType(contentType)) {
            return this.forceDataBase64Serialization;
        }
        return !this.forceStringSerialization;
    }

    private static class FieldsSerializer
    implements CloudEventAttributesWriter,
    CloudEventExtensionsWriter {
        private final JsonGenerator gen;
        private final SerializerProvider provider;

        public FieldsSerializer(JsonGenerator gen, SerializerProvider provider) {
            this.gen = gen;
            this.provider = provider;
        }

        public FieldsSerializer withAttribute(String name, String value) throws CloudEventRWException {
            try {
                this.gen.writeStringField(name, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FieldsSerializer withExtension(String name, String value) throws CloudEventRWException {
            try {
                this.gen.writeStringField(name, value);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FieldsSerializer withExtension(String name, Number value) throws CloudEventRWException {
            try {
                this.gen.writeFieldName(name);
                this.provider.findValueSerializer(value.getClass()).serialize((Object)value, this.gen, this.provider);
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FieldsSerializer withExtension(String name, Boolean value) throws CloudEventRWException {
            try {
                this.gen.writeBooleanField(name, value.booleanValue());
                return this;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

