/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.vertx.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.http.vertx.impl.CloudEventsHeaders;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;

public class VertxWebClientRequestMessageWriterImpl
implements MessageWriter<CloudEventWriter<Future<HttpResponse<Buffer>>>, Future<HttpResponse<Buffer>>>,
CloudEventWriter<Future<HttpResponse<Buffer>>> {
    private final HttpRequest<Buffer> request;

    public VertxWebClientRequestMessageWriterImpl(HttpRequest<Buffer> request) {
        this.request = request;
    }

    public CloudEventWriter<Future<HttpResponse<Buffer>>> create(SpecVersion version) {
        this.request.headers().add(CloudEventsHeaders.SPEC_VERSION, (CharSequence)version.toString());
        return this;
    }

    public void setAttribute(String name, String value) throws CloudEventRWException {
        this.request.headers().add(CloudEventsHeaders.ATTRIBUTES_TO_HEADERS.get(name), (CharSequence)value);
    }

    public void setExtension(String name, String value) throws CloudEventRWException {
        this.request.headers().add("ce-" + name, value);
    }

    public Future<HttpResponse<Buffer>> end(byte[] value) throws CloudEventRWException {
        return this.request.sendBuffer(Buffer.buffer((byte[])value));
    }

    public Future<HttpResponse<Buffer>> end() {
        return this.request.send();
    }

    public Future<HttpResponse<Buffer>> setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.request.headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)format.serializedContentType());
        return this.request.sendBuffer(Buffer.buffer((byte[])value));
    }
}

