/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.vertx;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.core.message.impl.MessageUtils;
import io.cloudevents.core.message.impl.UnknownEncodingMessageReader;
import io.cloudevents.http.vertx.impl.BinaryVertxMessageReaderImpl;
import io.cloudevents.http.vertx.impl.CloudEventsHeaders;
import io.cloudevents.http.vertx.impl.VertxHttpClientRequestMessageWriterImpl;
import io.cloudevents.http.vertx.impl.VertxHttpServerResponseMessageWriterImpl;
import io.cloudevents.rw.CloudEventWriter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class VertxMessageFactory {
    private VertxMessageFactory() {
    }

    public static MessageReader createReader(MultiMap headers, Buffer body) throws IllegalArgumentException {
        return MessageUtils.parseStructuredOrBinaryMessage(() -> headers.get(HttpHeaders.CONTENT_TYPE), format -> new GenericStructuredMessageReader(format, body.getBytes()), () -> headers.get(CloudEventsHeaders.SPEC_VERSION), sv -> new BinaryVertxMessageReaderImpl((SpecVersion)sv, headers, body), UnknownEncodingMessageReader::new);
    }

    public static Future<MessageReader> createReader(HttpServerRequest request) {
        return VertxMessageFactory.createReader(request.headers(), arg_0 -> ((HttpServerRequest)request).exceptionHandler(arg_0), arg_0 -> ((HttpServerRequest)request).bodyHandler(arg_0));
    }

    public static void createReader(HttpServerRequest request, Handler<AsyncResult<MessageReader>> handler) {
        VertxMessageFactory.createReader(request).onComplete(handler);
    }

    public static Future<MessageReader> createReader(HttpClientResponse response) {
        return VertxMessageFactory.createReader(response.headers(), arg_0 -> ((HttpClientResponse)response).exceptionHandler(arg_0), arg_0 -> ((HttpClientResponse)response).bodyHandler(arg_0));
    }

    public static void createReader(HttpClientResponse response, Handler<AsyncResult<MessageReader>> handler) {
        VertxMessageFactory.createReader(response).onComplete(handler);
    }

    private static Future<MessageReader> createReader(MultiMap headers, Consumer<Handler<Throwable>> fail, Consumer<Handler<Buffer>> success) {
        Promise prom = Promise.promise();
        fail.accept((Handler<Throwable>)((Handler)arg_0 -> ((Promise)prom).tryFail(arg_0)));
        success.accept((Handler<Buffer>)((Handler)b -> {
            try {
                prom.complete((Object)VertxMessageFactory.createReader(headers, b));
            }
            catch (IllegalArgumentException e) {
                prom.fail((Throwable)e);
            }
        }));
        return prom.future();
    }

    public static MessageWriter<CloudEventWriter<HttpServerResponse>, HttpServerResponse> createWriter(HttpServerResponse res) {
        return new VertxHttpServerResponseMessageWriterImpl(res);
    }

    public static MessageWriter<CloudEventWriter<HttpClientRequest>, HttpClientRequest> createWriter(HttpClientRequest req) {
        return new VertxHttpClientRequestMessageWriterImpl(req);
    }
}

