/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.impl;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.http.impl.CloudEventsHeaders;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class HttpMessageWriter
implements CloudEventWriter<Void>,
MessageWriter<HttpMessageWriter, Void> {
    private final BiConsumer<String, String> putHeader;
    private final Consumer<byte[]> putBody;

    public HttpMessageWriter(BiConsumer<String, String> putHeader, Consumer<byte[]> putBody) {
        this.putHeader = putHeader;
        this.putBody = putBody;
    }

    public Void setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.putHeader.accept("Content-Type", format.serializedContentType());
        this.putBody.accept(value);
        return null;
    }

    public Void end(CloudEventData value) throws CloudEventRWException {
        this.putBody.accept(value.toBytes());
        return null;
    }

    public Void end() {
        this.putBody.accept(null);
        return null;
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        String headerName = CloudEventsHeaders.ATTRIBUTES_TO_HEADERS.get(name);
        if (headerName == null) {
            headerName = "ce-" + name;
        }
        this.putHeader.accept(headerName, value);
        return this;
    }

    public HttpMessageWriter create(SpecVersion version) {
        this.putHeader.accept(CloudEventsHeaders.SPEC_VERSION, version.toString());
        return this;
    }
}

