/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.StructuredMessageWriter;
import io.cloudevents.core.message.impl.BaseStructuredMessageReader;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.lang.Nullable;
import io.cloudevents.rw.CloudEventRWException;

public class GenericStructuredMessageReader
extends BaseStructuredMessageReader {
    private final EventFormat format;
    private final byte[] payload;

    public GenericStructuredMessageReader(EventFormat format, byte[] payload) {
        this.format = format;
        this.payload = payload;
    }

    @Override
    public <T> T read(StructuredMessageWriter<T> visitor) throws CloudEventRWException, IllegalStateException {
        return visitor.setEvent(this.format, this.payload);
    }

    public static GenericStructuredMessageReader fromContentType(String contentType, byte[] payload) {
        EventFormat format = EventFormatProvider.getInstance().resolveFormat(contentType);
        if (format == null) {
            return null;
        }
        return new GenericStructuredMessageReader(format, payload);
    }

    @Nullable
    public static GenericStructuredMessageReader from(CloudEvent event, String contentType) {
        EventFormat format = EventFormatProvider.getInstance().resolveFormat(contentType);
        if (format == null) {
            return null;
        }
        return GenericStructuredMessageReader.from(event, format);
    }

    public static GenericStructuredMessageReader from(CloudEvent event, EventFormat format) {
        return new GenericStructuredMessageReader(format, format.serialize(event));
    }
}

