/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message.impl;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.message.impl.BaseBinaryMessageReader;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.rw.CloudEventWriterFactory;
import java.util.Objects;
import java.util.function.BiConsumer;

public abstract class BaseGenericBinaryMessageReaderImpl<HK, HV>
extends BaseBinaryMessageReader {
    private final SpecVersion version;
    private final CloudEventData body;

    protected BaseGenericBinaryMessageReaderImpl(SpecVersion version, CloudEventData body) {
        Objects.requireNonNull(version);
        this.version = version;
        this.body = body;
    }

    public <T extends CloudEventWriter<V>, V> V read(CloudEventWriterFactory<T, V> writerFactory, CloudEventDataMapper<? extends CloudEventData> mapper) throws CloudEventRWException, IllegalStateException {
        CloudEventWriter visitor = writerFactory.create(this.version);
        this.forEachHeader((key, value) -> {
            if (this.isContentTypeHeader(key)) {
                visitor.withAttribute("datacontenttype", this.toCloudEventsValue(value));
            } else if (this.isCloudEventsHeader(key)) {
                String name = this.toCloudEventsKey(key);
                if (name.equals("specversion")) {
                    return;
                }
                if (this.version.getAllAttributes().contains(name)) {
                    visitor.withAttribute(name, this.toCloudEventsValue(value));
                } else {
                    visitor.withExtension(name, this.toCloudEventsValue(value));
                }
            }
        });
        if (this.body != null) {
            return (V)visitor.end(mapper.map(this.body));
        }
        return (V)visitor.end();
    }

    protected abstract boolean isContentTypeHeader(HK var1);

    protected abstract boolean isCloudEventsHeader(HK var1);

    protected abstract String toCloudEventsKey(HK var1);

    protected abstract void forEachHeader(BiConsumer<HK, HV> var1);

    protected abstract String toCloudEventsValue(HV var1);
}

