/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v1;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.impl.BaseCloudEvent;
import io.cloudevents.core.v1.ContextAttributes;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public final class CloudEventV1
extends BaseCloudEvent {
    private final String id;
    private final URI source;
    private final String type;
    private final String datacontenttype;
    private final URI dataschema;
    private final String subject;
    private final OffsetDateTime time;

    public CloudEventV1(String id, URI source, String type, String datacontenttype, URI dataschema, String subject, OffsetDateTime time, CloudEventData data, Map<String, Object> extensions) {
        super(data, extensions);
        this.id = id;
        this.source = source;
        this.type = type;
        this.datacontenttype = datacontenttype;
        this.dataschema = dataschema;
        this.subject = subject;
        this.time = time;
    }

    public SpecVersion getSpecVersion() {
        return SpecVersion.V1;
    }

    public String getId() {
        return this.id;
    }

    public URI getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public String getDataContentType() {
        return this.datacontenttype;
    }

    public URI getDataSchema() {
        return this.dataschema;
    }

    public String getSubject() {
        return this.subject;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public Object getAttribute(String attributeName) {
        switch (attributeName) {
            case "specversion": {
                return this.getSpecVersion();
            }
            case "id": {
                return this.id;
            }
            case "source": {
                return this.source;
            }
            case "type": {
                return this.type;
            }
            case "datacontenttype": {
                return this.datacontenttype;
            }
            case "dataschema": {
                return this.dataschema;
            }
            case "subject": {
                return this.subject;
            }
            case "time": {
                return this.time;
            }
        }
        throw new IllegalArgumentException("Spec version v1 doesn't have attribute named " + attributeName);
    }

    public void readAttributes(CloudEventAttributesWriter writer) throws CloudEventRWException {
        writer.withAttribute(ContextAttributes.ID.name().toLowerCase(), this.id);
        writer.withAttribute(ContextAttributes.SOURCE.name().toLowerCase(), this.source);
        writer.withAttribute(ContextAttributes.TYPE.name().toLowerCase(), this.type);
        if (this.datacontenttype != null) {
            writer.withAttribute(ContextAttributes.DATACONTENTTYPE.name().toLowerCase(), this.datacontenttype);
        }
        if (this.dataschema != null) {
            writer.withAttribute(ContextAttributes.DATASCHEMA.name().toLowerCase(), this.dataschema);
        }
        if (this.subject != null) {
            writer.withAttribute(ContextAttributes.SUBJECT.name().toLowerCase(), this.subject);
        }
        if (this.time != null) {
            writer.withAttribute(ContextAttributes.TIME.name().toLowerCase(), this.time);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEventV1 that = (CloudEventV1)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.datacontenttype, that.getDataContentType()) && Objects.equals(this.dataschema, that.getDataSchema()) && Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getTime(), that.getTime()) && Objects.equals(this.getData(), that.getData()) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getSource(), this.getType(), this.datacontenttype, this.dataschema, this.getSubject(), this.getTime(), this.getData(), this.extensions);
    }

    public String toString() {
        return "CloudEvent{id='" + this.id + '\'' + ", source=" + this.source + ", type='" + this.type + '\'' + ", datacontenttype='" + this.datacontenttype + '\'' + ", dataschema=" + this.dataschema + ", subject='" + this.subject + '\'' + ", time=" + this.time + ", data=" + this.getData() + ", extensions=" + this.extensions + '}';
    }
}

