/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.StructuredMessageWriter;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.lang.Nullable;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import javax.annotation.ParametersAreNonnullByDefault;

@FunctionalInterface
@ParametersAreNonnullByDefault
public interface StructuredMessageReader {
    public <T> T read(StructuredMessageWriter<T> var1) throws CloudEventRWException, IllegalStateException;

    default public CloudEvent toEvent() throws CloudEventRWException, IllegalStateException {
        return this.read(EventFormat::deserialize);
    }

    default public CloudEvent toEvent(@Nullable CloudEventDataMapper mapper) throws CloudEventRWException, IllegalStateException {
        return this.read((format, value) -> format.deserialize(value, mapper));
    }

    public static StructuredMessageReader from(CloudEvent event, String contentType) {
        return GenericStructuredMessageReader.from(event, contentType);
    }

    public static StructuredMessageReader from(CloudEvent event, EventFormat format) {
        return GenericStructuredMessageReader.from(event, format);
    }
}

