/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.Extension;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class BaseCloudEventBuilder<SELF extends BaseCloudEventBuilder<SELF, T>, T extends CloudEvent>
implements CloudEventBuilder {
    private final SELF self = this;
    protected CloudEventData data;
    protected Map<String, Object> extensions;

    public BaseCloudEventBuilder() {
        this.extensions = new HashMap<String, Object>();
    }

    public BaseCloudEventBuilder(CloudEvent event) {
        this.setAttributes(event);
        this.data = event.getData();
        this.extensions = new HashMap<String, Object>();
        for (String k : event.getExtensionNames()) {
            this.extensions.put(k, event.getExtension(k));
        }
    }

    protected abstract void setAttributes(CloudEvent var1);

    public SELF withData(byte[] data) {
        this.data = new BytesCloudEventData(data);
        return this.self;
    }

    public SELF withData(String dataContentType, byte[] data) {
        this.withDataContentType(dataContentType);
        this.withData(data);
        return this.self;
    }

    public SELF withData(String dataContentType, URI dataSchema, byte[] data) {
        this.withDataContentType(dataContentType);
        this.withDataSchema(dataSchema);
        this.withData(data);
        return this.self;
    }

    public SELF withData(CloudEventData data) {
        this.data = data;
        return this.self;
    }

    public SELF withData(String dataContentType, CloudEventData data) {
        this.withDataContentType(dataContentType);
        this.withData(data);
        return this.self;
    }

    public SELF withData(String dataContentType, URI dataSchema, CloudEventData data) {
        this.withDataContentType(dataContentType);
        this.withDataSchema(dataSchema);
        this.withData(data);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, String value) {
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, Number value) {
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withExtension(@Nonnull String key, Boolean value) {
        this.extensions.put(key, value);
        return this.self;
    }

    public SELF withoutExtension(@Nonnull String key) {
        this.extensions.remove(key);
        return this.self;
    }

    public SELF withoutExtension(@Nonnull Extension extension) {
        extension.getKeys().forEach(string -> this.withoutExtension((String)string));
        return this.self;
    }

    public SELF withExtension(@Nonnull Extension extension) {
        for (String key : extension.getKeys()) {
            Object value = extension.getValue(key);
            if (value == null) continue;
            this.extensions.put(key, value);
        }
        return this.self;
    }

    public CloudEvent end(CloudEventData value) throws CloudEventRWException {
        this.data = value;
        return this.build();
    }

    public CloudEvent end() {
        try {
            return this.build();
        }
        catch (Exception e) {
            throw CloudEventRWException.newOther((Throwable)e);
        }
    }

    protected static IllegalStateException createMissingAttributeException(String attributeName) {
        return new IllegalStateException("Attribute '" + attributeName + "' cannot be null");
    }
}

