/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.cloudevents.CloudEvent;
import io.cloudevents.impl.DefaultCloudEventImpl;
import io.cloudevents.json.ZonedDateTimeDeserializer;
import io.cloudevents.json.ZonedDateTimeSerializer;
import java.io.InputStream;
import java.time.ZonedDateTime;

public final class Json {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static String encode(Object obj) throws IllegalStateException {
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static CloudEvent fromInputStream(InputStream inputStream) {
        try {
            return (CloudEvent)MAPPER.readValue(inputStream, DefaultCloudEventImpl.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static DefaultCloudEventImpl decodeCloudEvent(String str) throws IllegalStateException {
        return Json.decodeValue(str, DefaultCloudEventImpl.class);
    }

    protected static <T> T decodeValue(String str, Class<T> clazz) throws IllegalStateException {
        try {
            return (T)MAPPER.readValue(str, clazz);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, TypeReference<T> type) throws IllegalStateException {
        try {
            return (T)MAPPER.readValue(str, type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode: " + e.getMessage(), e);
        }
    }

    private Json() {
    }

    static {
        MAPPER.registerModule((Module)new Jdk8Module());
        SimpleModule module = new SimpleModule();
        module.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer());
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        MAPPER.registerModule((Module)module);
    }
}

