/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.impl;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.cloudevents.CloudEvent;
import io.cloudevents.Extension;
import io.cloudevents.json.ZonedDateTimeDeserializer;
import java.io.Serializable;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(value={"eventTypeVersion", "extensions"})
public class DefaultCloudEventImpl<T>
implements CloudEvent<T>,
Serializable {
    private static final long serialVersionUID = 2L;
    private String specversion;
    private String type = null;
    private URI source = null;
    private String id = null;
    private ZonedDateTime time = null;
    private URI schemaURL = null;
    private String contentType = null;
    private T data = null;
    private List<Extension> extensions = null;

    public DefaultCloudEventImpl(String type, String specversion, URI source, String id, ZonedDateTime time, URI schemaURL, String contentType, T data, List<Extension> extensions) {
        this.specversion = specversion;
        this.type = type;
        this.source = source;
        this.id = id;
        this.time = time;
        this.schemaURL = schemaURL;
        this.contentType = contentType;
        this.data = data;
        this.extensions = extensions;
    }

    DefaultCloudEventImpl() {
    }

    @Override
    public String getSpecVersion() {
        return this.specversion;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<ZonedDateTime> getTime() {
        return Optional.ofNullable(this.time);
    }

    @Override
    public Optional<URI> getSchemaURL() {
        return Optional.ofNullable(this.schemaURL);
    }

    @Override
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    @Override
    public Optional<T> getData() {
        return Optional.ofNullable(this.data);
    }

    @Override
    public Optional<List<Extension>> getExtensions() {
        return Optional.ofNullable(this.extensions);
    }

    @JsonAlias(value={"specversion", "specVersion", "cloudEventsVersion"})
    void setSpecversion(String specversion) {
        this.specversion = specversion;
    }

    @JsonAlias(value={"type", "eventType"})
    void setType(String type) {
        this.type = type;
    }

    void setSource(URI source) {
        this.source = source;
    }

    @JsonAlias(value={"id", "eventID"})
    void setId(String id) {
        this.id = id;
    }

    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    @JsonAlias(value={"time", "eventTime"})
    void setTime(ZonedDateTime time) {
        this.time = time;
    }

    void setSchemaURL(URI schemaURL) {
        this.schemaURL = schemaURL;
    }

    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "DefaultCloudEventImpl{specversion='" + this.specversion + '\'' + ", type='" + this.type + '\'' + ", source=" + this.source + ", id='" + this.id + '\'' + ", time=" + this.time + ", schemaURL=" + this.schemaURL + ", contentType='" + this.contentType + '\'' + ", data=" + this.data + '}';
    }
}

