/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.implementation.GenericParameterizedType;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class Union {
    private static final ClientLogger LOGGER = new ClientLogger(Union.class);
    private final List<Type> types;
    private Object value;
    private Type currentType;

    private Union(Type ... types) {
        if (types == null || types.length == 0) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("types cannot be null or empty"));
        }
        ArrayList<Type> typeCopy = new ArrayList<Type>(types.length);
        for (int i = 0; i < types.length; ++i) {
            Type currentType = types[i];
            if (currentType == null) {
                throw LOGGER.logThrowableAsError(new IllegalArgumentException("types cannot contain null values: null value in index " + i));
            }
            if (!(currentType instanceof Class) && !(currentType instanceof ParameterizedType)) {
                throw LOGGER.logThrowableAsError(new IllegalArgumentException(String.format("types must be of type Class or ParameterizedType: type name is %s in index %d.", currentType.getTypeName(), i)));
            }
            typeCopy.add(types[i]);
        }
        this.types = Collections.unmodifiableList(typeCopy);
    }

    public static Union ofTypes(Type ... types) {
        return new Union(types);
    }

    public Union setValue(Object value) {
        if (value == null) {
            this.value = null;
            return this;
        }
        for (Type type : this.types) {
            if (!this.isInstanceOfType(value, type) && !this.isPrimitiveTypeMatch(value, type)) continue;
            this.value = value;
            this.currentType = type;
            return this;
        }
        throw LOGGER.logThrowableAsError(new IllegalArgumentException("Invalid type: " + value.getClass().getName()));
    }

    public Type getCurrentType() {
        return this.currentType;
    }

    public List<Type> getSupportedTypes() {
        return this.types;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public <T> T getValue(Class<T> clazz) {
        if (clazz == this.currentType) {
            return (T)this.value;
        }
        if (clazz.isInstance(this.value)) {
            return clazz.cast(this.value);
        }
        if (this.isPrimitiveTypeMatch(this.value, clazz)) {
            return (T)this.value;
        }
        throw LOGGER.logThrowableAsError(new IllegalArgumentException("Value is not of type: " + clazz.getName()));
    }

    public <T> T getValue(Class<T> clazz, Class<?> ... genericTypes) {
        return this.getValue(new GenericParameterizedType(clazz, genericTypes));
    }

    public <T> T getValue(Type type) {
        if (type == this.currentType) {
            return (T)this.value;
        }
        if (this.isInstanceOfType(this.value, type)) {
            return (T)this.value;
        }
        throw LOGGER.logThrowableAsError(new IllegalArgumentException("Value is not of type: " + type.getTypeName()));
    }

    public <T> boolean tryConsume(Consumer<T> consumer, Class<T> clazz) {
        if (clazz == this.currentType) {
            consumer.accept(this.value);
            return true;
        }
        if (this.isInstanceOfType(this.value, clazz)) {
            consumer.accept(clazz.cast(this.value));
            return true;
        }
        if (this.isPrimitiveTypeMatch(this.value, clazz)) {
            consumer.accept(this.value);
            return true;
        }
        return false;
    }

    public <T> boolean tryConsume(Consumer<T> consumer, Class<T> clazz, Class<?> ... genericTypes) {
        return this.tryConsume(consumer, new GenericParameterizedType(clazz, genericTypes));
    }

    public <T> boolean tryConsume(Consumer<T> consumer, ParameterizedType type) {
        if (type == this.currentType) {
            consumer.accept(this.value);
            return true;
        }
        if (this.isInstanceOfType(this.value, type)) {
            consumer.accept(this.value);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.value == null ? "Union{types=" + this.types + ", value=null}" : "Union{types=" + this.types + ", type=" + (this.currentType == null ? null : this.currentType.getTypeName()) + ", value=" + this.value + "}";
    }

    private boolean isInstanceOfType(Object value, Type type) {
        if (value == null) {
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            if (pType.getRawType() instanceof Class && ((Class)pType.getRawType()).isInstance(value)) {
                Type[] actualTypeArguments = pType.getActualTypeArguments();
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    return collection.stream().allMatch(element -> element != null && Arrays.stream(actualTypeArguments).anyMatch(arg -> this.isInstanceOfType(element, (Type)arg)));
                }
            }
        } else if (type instanceof Class) {
            return ((Class)type).isInstance(value);
        }
        return false;
    }

    private boolean isPrimitiveTypeMatch(Object value, Type type) {
        Class clazz;
        return type instanceof Class && (clazz = (Class)type).isPrimitive() && (clazz == Integer.TYPE && value instanceof Integer || clazz == Long.TYPE && value instanceof Long || clazz == Float.TYPE && value instanceof Float || clazz == Double.TYPE && value instanceof Double || clazz == Boolean.TYPE && value instanceof Boolean || clazz == Byte.TYPE && value instanceof Byte || clazz == Character.TYPE && value instanceof Character || clazz == Short.TYPE && value instanceof Short);
    }
}

