/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.utils.ImplUtils;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.configuration.Configuration;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;

public final class SharedExecutorService
implements ScheduledExecutorService {
    private static final ClientLogger LOGGER;
    private static final AtomicLong CLIENTCORE_SDK_THREAD_COUNTER;
    private static final String CLIENTCORE_SDK_THREAD_NAME = "clientcore-sdk-global-thread-";
    private static final int THREAD_POOL_SIZE;
    private static final int THREAD_POOL_KEEP_ALIVE_MILLIS;
    private static final boolean THREAD_POOL_VIRTUAL;
    private static final SharedExecutorService INSTANCE;
    private static final boolean VIRTUAL_THREAD_SUPPORTED;
    private static final ReflectiveInvoker GET_VIRTUAL_THREAD_BUILDER;
    private static final ReflectiveInvoker SET_VIRTUAL_THREAD_BUILDER_THREAD_NAME;
    private static final ReflectiveInvoker CREATE_VIRTUAL_THREAD_FACTORY;
    volatile ScheduledExecutorService executor;
    private static final AtomicReferenceFieldUpdater<SharedExecutorService, ScheduledExecutorService> EXECUTOR_UPDATER;

    private static <T> T getConfig(String systemProperty, String envVar, Function<String, T> converter, T defaultValue) {
        String foundValue = Configuration.getGlobalConfiguration().get(systemProperty, envVar);
        if (foundValue == null) {
            LOGGER.atVerbose().addKeyValue("systemProperty", systemProperty).addKeyValue("envVar", envVar).addKeyValue("defaultValue", defaultValue).log("Configuration value not found, using default.");
            return defaultValue;
        }
        try {
            return converter.apply(foundValue);
        }
        catch (RuntimeException e) {
            LOGGER.atVerbose().addKeyValue("systemProperty", systemProperty).addKeyValue("envVar", envVar).addKeyValue("value", foundValue).addKeyValue("defaultValue", defaultValue).log("Failed to convert found configuration value, using default.");
            return defaultValue;
        }
    }

    private SharedExecutorService() {
    }

    public static SharedExecutorService getInstance() {
        return INSTANCE;
    }

    public ScheduledExecutorService getExecutorService() {
        return EXECUTOR_UPDATER.get(this);
    }

    public void setExecutorService(ScheduledExecutorService executorService) {
        Objects.requireNonNull(executorService, "'executorService' cannot be null.");
        if (executorService.isShutdown() || executorService.isTerminated()) {
            throw LOGGER.logThrowableAsError(new IllegalStateException("The passed executor service is shutdown or terminated."));
        }
        ExecutorService existing = EXECUTOR_UPDATER.getAndSet(this, executorService);
        if (existing instanceof InternalExecutorService) {
            existing.shutdown();
        }
    }

    public void reset() {
        ScheduledExecutorService existing = EXECUTOR_UPDATER.getAndSet(this, null);
        if (existing instanceof InternalExecutorService) {
            existing.shutdown();
        }
    }

    @Override
    public void shutdown() {
        throw LOGGER.logThrowableAsError(new UnsupportedOperationException("This executor service is shared and cannot be shut down."));
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw LOGGER.logThrowableAsError(new UnsupportedOperationException("This executor service is shared and cannot be shut down."));
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        throw LOGGER.logThrowableAsError(new UnsupportedOperationException("This executor service is shared and cannot be terminated."));
    }

    @Override
    public void execute(Runnable command) {
        this.ensureNotShutdown().execute(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.ensureNotShutdown().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.ensureNotShutdown().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.ensureNotShutdown().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.ensureNotShutdown().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.ensureNotShutdown().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.ensureNotShutdown().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.ensureNotShutdown().invokeAny(tasks, timeout, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.ensureNotShutdown().schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.ensureNotShutdown().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.ensureNotShutdown().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.ensureNotShutdown().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private ScheduledExecutorService ensureNotShutdown() {
        return EXECUTOR_UPDATER.updateAndGet(INSTANCE, ex -> ex == null || ex.isShutdown() || ex.isTerminated() ? SharedExecutorService.createSharedExecutor() : ex);
    }

    private static ScheduledExecutorService createSharedExecutor() {
        ThreadFactory threadFactory;
        if (VIRTUAL_THREAD_SUPPORTED && THREAD_POOL_VIRTUAL) {
            try {
                LOGGER.atVerbose().log("Attempting to create a virtual thread factory.");
                threadFactory = SharedExecutorService.createVirtualThreadFactory();
                LOGGER.atVerbose().log("Successfully created a virtual thread factory.");
            }
            catch (Exception e) {
                LOGGER.atInfo().setThrowable(e).log("Failed to create a virtual thread factory, falling back to non-virtual threads.");
                threadFactory = SharedExecutorService.createNonVirtualThreadFactory();
            }
        } else {
            threadFactory = SharedExecutorService.createNonVirtualThreadFactory();
        }
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(THREAD_POOL_SIZE, threadFactory);
        executorService.setKeepAliveTime(THREAD_POOL_KEEP_ALIVE_MILLIS, TimeUnit.MILLISECONDS);
        Thread shutdownThread = ImplUtils.createExecutorServiceShutdownThread(executorService, Duration.ofSeconds(5L));
        ImplUtils.addShutdownHookSafely(shutdownThread);
        return new InternalExecutorService(executorService, shutdownThread);
    }

    private static ThreadFactory createVirtualThreadFactory() throws Exception {
        Object virtualThreadBuilder = GET_VIRTUAL_THREAD_BUILDER.invokeStatic(new Object[0]);
        SET_VIRTUAL_THREAD_BUILDER_THREAD_NAME.invokeWithArguments(virtualThreadBuilder, CLIENTCORE_SDK_THREAD_NAME, CLIENTCORE_SDK_THREAD_COUNTER.get());
        ThreadFactory virtual = (ThreadFactory)CREATE_VIRTUAL_THREAD_FACTORY.invokeWithArguments(virtualThreadBuilder, new Object[0]);
        return r -> {
            CLIENTCORE_SDK_THREAD_COUNTER.incrementAndGet();
            return virtual.newThread(r);
        };
    }

    private static ThreadFactory createNonVirtualThreadFactory() {
        return r -> {
            Thread thread = new Thread(r, CLIENTCORE_SDK_THREAD_NAME + CLIENTCORE_SDK_THREAD_COUNTER.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        };
    }

    static {
        boolean virtualThreadSupported;
        ReflectiveInvoker createVirtualThreadFactory;
        ReflectiveInvoker setVirtualThreadBuilderThreadName;
        ReflectiveInvoker getVirtualThreadBuilder;
        LOGGER = new ClientLogger(SharedExecutorService.class);
        CLIENTCORE_SDK_THREAD_COUNTER = new AtomicLong();
        THREAD_POOL_SIZE = SharedExecutorService.getConfig("clientcore.sdk.shared.threadpool.maxpoolsize", "CLIENTCORE_SDK_SHARED_THREADPOOL_MAXPOOLSIZE", Integer::parseInt, 10 * Runtime.getRuntime().availableProcessors());
        THREAD_POOL_KEEP_ALIVE_MILLIS = SharedExecutorService.getConfig("clientcore.sdk.shared.threadpool.keepalivemillis", "CLIENTCORE_SDK_SHARED_THREADPOOL_KEEPALIVEMILLIS", Integer::parseInt, 60000);
        THREAD_POOL_VIRTUAL = SharedExecutorService.getConfig("clientcore.sdk.shared.threadpool.usevirtualthreads", "CLIENTCORE_SDK_SHARED_THREADPOOL_USEVIRTUALTHREADS", Boolean::parseBoolean, true);
        INSTANCE = new SharedExecutorService();
        try {
            getVirtualThreadBuilder = ReflectionUtils.getMethodInvoker(null, Class.forName("java.lang.Thread").getDeclaredMethod("ofVirtual", new Class[0]));
            setVirtualThreadBuilderThreadName = ReflectionUtils.getMethodInvoker(null, Class.forName("java.lang.Thread$Builder").getDeclaredMethod("name", String.class));
            createVirtualThreadFactory = ReflectionUtils.getMethodInvoker(null, Class.forName("java.lang.Thread$Builder").getDeclaredMethod("factory", new Class[0]));
            virtualThreadSupported = true;
            LOGGER.atVerbose().log("Virtual threads are supported in the current runtime.");
        }
        catch (Exception | LinkageError e) {
            LOGGER.atVerbose().addKeyValue("runtime", System.getProperty("java.version")).setThrowable(e).log("Virtual threads are not supported in the current runtime.");
            virtualThreadSupported = false;
            getVirtualThreadBuilder = null;
            setVirtualThreadBuilderThreadName = null;
            createVirtualThreadFactory = null;
        }
        VIRTUAL_THREAD_SUPPORTED = virtualThreadSupported;
        GET_VIRTUAL_THREAD_BUILDER = getVirtualThreadBuilder;
        SET_VIRTUAL_THREAD_BUILDER_THREAD_NAME = setVirtualThreadBuilderThreadName;
        CREATE_VIRTUAL_THREAD_FACTORY = createVirtualThreadFactory;
        EXECUTOR_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SharedExecutorService.class, ScheduledExecutorService.class, "executor");
    }

    static final class InternalExecutorService
    implements ScheduledExecutorService {
        private final ScheduledExecutorService wrapped;
        private final Thread shutdownThread;

        private InternalExecutorService(ScheduledExecutorService wrapped, Thread shutdownThread) {
            this.wrapped = wrapped;
            this.shutdownThread = shutdownThread;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.wrapped.invokeAny(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.wrapped.invokeAny(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.wrapped.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.wrapped.invokeAll(tasks);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.wrapped.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.wrapped.submit(task, result);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.wrapped.submit(task);
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.wrapped.awaitTermination(timeout, unit);
        }

        @Override
        public boolean isTerminated() {
            return this.wrapped.isTerminated();
        }

        @Override
        public boolean isShutdown() {
            return this.wrapped.isShutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.wrapped.shutdownNow();
        }

        @Override
        public void shutdown() {
            this.wrapped.shutdown();
            ImplUtils.removeShutdownHookSafely(this.shutdownThread);
        }

        @Override
        public void execute(Runnable command) {
            this.wrapped.execute(command);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.wrapped.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.wrapped.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.wrapped.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.wrapped.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }
}

