/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.SerializationFormat;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CoreUtils {
    private static final ClientLogger LOGGER = new ClientLogger(CoreUtils.class);
    private static final char[] LOWERCASE_HEX_CHARACTERS = "0123456789abcdef".toCharArray();
    private static final Pattern ISO8601_COLONLESS_OFFSET = Pattern.compile("([+-][0-9]{2})([0-9]{2})(?=\\[|$)");

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static byte[] arrayCopy(byte[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static int[] arrayCopy(int[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static <T> T[] arrayCopy(T[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static UUID randomUuid() {
        return CoreUtils.randomUuid(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong());
    }

    static UUID randomUuid(long msb, long lsb) {
        msb &= 0xFFFFFFFFFFFF0FFFL;
        lsb &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(msb |= 0x4000L, lsb |= Long.MIN_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getProperties(String propertiesFileName) {
        try (InputStream inputStream = CoreUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException ex) {
            LOGGER.atWarning().setThrowable(ex).log("Failed to get properties from " + propertiesFileName);
        }
        return Collections.emptyMap();
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        char[] hexString = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            hexString[i * 2] = LOWERCASE_HEX_CHARACTERS[b >>> 4];
            hexString[i * 2 + 1] = LOWERCASE_HEX_CHARACTERS[b & 0xF];
        }
        return new String(hexString);
    }

    public static long extractSizeFromContentRange(String contentRange) {
        Objects.requireNonNull(contentRange, "Cannot extract length from null 'contentRange'.");
        int index = contentRange.indexOf(47);
        if (index == -1) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("The Content-Range header wasn't properly formatted and didn't contain a '/size' segment. The 'contentRange' was: " + contentRange));
        }
        String sizeString = contentRange.substring(index + 1).trim();
        if ("*".equals(sizeString)) {
            return -1L;
        }
        return Long.parseLong(sizeString);
    }

    public static OffsetDateTime parseBestOffsetDateTime(String dateString) {
        TemporalAccessor temporal;
        if (dateString == null) {
            return null;
        }
        Matcher matcher = ISO8601_COLONLESS_OFFSET.matcher(dateString);
        if (matcher.find()) {
            dateString = dateString.substring(0, matcher.start()) + matcher.group(1) + ":" + matcher.group(2) + dateString.substring(matcher.start() + 5);
        }
        if ((temporal = DateTimeFormatter.ISO_DATE_TIME.parseBest(dateString, OffsetDateTime::from, LocalDateTime::from)).query(TemporalQueries.offset()) == null) {
            return LocalDateTime.from(temporal).atOffset(ZoneOffset.UTC);
        }
        return OffsetDateTime.from(temporal);
    }

    public static ParameterizedType createParameterizedType(final Type rawType, final Type ... typeArguments) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeArguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static String stringJoin(String delimiter, List<String> values) {
        Objects.requireNonNull(delimiter, "'delimiter' cannot be null.");
        Objects.requireNonNull(values, "'values' cannot be null.");
        int count = values.size();
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return values.get(0);
            }
            case 2: {
                return values.get(0) + delimiter + values.get(1);
            }
            case 3: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2);
            }
            case 4: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3);
            }
            case 5: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4);
            }
            case 6: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5);
            }
            case 7: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6);
            }
            case 8: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7);
            }
            case 9: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7) + delimiter + values.get(8);
            }
            case 10: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7) + delimiter + values.get(8) + delimiter + values.get(9);
            }
        }
        return String.join((CharSequence)delimiter, values);
    }

    public static SerializationFormat serializationFormatFromContentType(HttpHeaders headers) {
        if (headers == null) {
            return SerializationFormat.JSON;
        }
        String contentType = headers.getValue(HttpHeaderName.CONTENT_TYPE);
        if (CoreUtils.isNullOrEmpty(contentType)) {
            return SerializationFormat.JSON;
        }
        int contentTypeEnd = contentType.indexOf(59);
        SerializationFormat encoding = CoreUtils.checkForKnownEncoding(contentType = contentTypeEnd == -1 ? contentType : contentType.substring(0, contentTypeEnd));
        if (encoding != null) {
            return encoding;
        }
        int contentTypeTypeSplit = contentType.indexOf(47);
        if (contentTypeTypeSplit == -1) {
            return SerializationFormat.JSON;
        }
        String subtype = contentType.substring(contentTypeTypeSplit + 1);
        int lastIndex = subtype.lastIndexOf(43);
        if (lastIndex == -1) {
            return SerializationFormat.JSON;
        }
        String mimeTypeSuffix = subtype.substring(lastIndex + 1);
        if ("xml".equalsIgnoreCase(mimeTypeSuffix)) {
            return SerializationFormat.XML;
        }
        if ("json".equalsIgnoreCase(mimeTypeSuffix)) {
            return SerializationFormat.JSON;
        }
        return SerializationFormat.JSON;
    }

    public static String appendQueryParams(String host, Map<String, Object> queryParams) {
        if (queryParams == null || queryParams.isEmpty()) {
            return host;
        }
        StringBuilder urlBuilder = new StringBuilder(host);
        boolean hasExistingQuery = host.contains("?");
        for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof List) {
                List valueList = (List)value;
                for (Object item : valueList) {
                    urlBuilder.append(hasExistingQuery ? "&" : "?").append(key).append("=").append(item.toString());
                    hasExistingQuery = true;
                }
                continue;
            }
            urlBuilder.append(hasExistingQuery ? "&" : "?").append(key).append("=").append(value.toString());
            hasExistingQuery = true;
        }
        return urlBuilder.toString();
    }

    private static SerializationFormat checkForKnownEncoding(String contentType) {
        int length = contentType.length();
        if (length != 8 && length != 9 && length != 10 && length != 15 && length != 16) {
            return null;
        }
        if ("text/".regionMatches(true, 0, contentType, 0, 5)) {
            if (length == 8) {
                if ("xml".regionMatches(true, 0, contentType, 5, 3)) {
                    return SerializationFormat.XML;
                }
                if ("csv".regionMatches(true, 0, contentType, 5, 3)) {
                    return SerializationFormat.TEXT;
                }
                if ("css".regionMatches(true, 0, contentType, 5, 3)) {
                    return SerializationFormat.TEXT;
                }
            } else {
                if (length == 9 && "html".regionMatches(true, 0, contentType, 5, 4)) {
                    return SerializationFormat.TEXT;
                }
                if (length == 10 && "plain".regionMatches(true, 0, contentType, 5, 5)) {
                    return SerializationFormat.TEXT;
                }
                if (length == 15 && "javascript".regionMatches(true, 0, contentType, 5, 10)) {
                    return SerializationFormat.TEXT;
                }
            }
        } else if ("application/".regionMatches(true, 0, contentType, 0, 12)) {
            if (length == 16 && "json".regionMatches(true, 0, contentType, 12, 4)) {
                return SerializationFormat.JSON;
            }
            if (length == 15 && "xml".regionMatches(true, 0, contentType, 12, 3)) {
                return SerializationFormat.XML;
            }
        }
        return null;
    }

    public static Object decodeNetworkResponse(BinaryData data, ObjectSerializer serializer, ParameterizedType returnType) {
        if (data == null) {
            return null;
        }
        try {
            if (List.class.isAssignableFrom((Class)returnType.getRawType())) {
                return serializer.deserializeFromBytes(data.toBytes(), returnType);
            }
            Type token = returnType.getRawType();
            if (Response.class.isAssignableFrom((Class)token)) {
                token = returnType.getActualTypeArguments()[0];
            }
            return serializer.deserializeFromBytes(data.toBytes(), token);
        }
        catch (IOException e) {
            CoreException coreException = CoreException.from(e);
            throw LOGGER.logThrowableAsError(CoreException.from(coreException));
        }
    }

    private CoreUtils() {
    }
}

