/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.implementation.jackson.core.json;

import io.clientcore.core.serialization.json.implementation.jackson.core.Base64Variant;
import io.clientcore.core.serialization.json.implementation.jackson.core.Base64Variants;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonParseException;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonParser;
import io.clientcore.core.serialization.json.implementation.jackson.core.JsonToken;
import io.clientcore.core.serialization.json.implementation.jackson.core.base.ParserMinimalBase;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.CharTypes;
import io.clientcore.core.serialization.json.implementation.jackson.core.io.IOContext;
import io.clientcore.core.serialization.json.implementation.jackson.core.sym.CharsToNameCanonicalizer;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.ByteArrayBuilder;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.Reader;

public class ReaderBasedJsonParser
extends ParserMinimalBase {
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected long _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;

    public ReaderBasedJsonParser(IOContext ctxt, int features, Reader r, CharsToNameCanonicalizer st) {
        super(ctxt, features);
        this._reader = r;
        this._inputBuffer = ctxt.allocTokenBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._symbols = st;
        this._hashSeed = st.hashSeed();
        this._bufferRecyclable = true;
    }

    protected char getNextChar(String eofMsg, JsonToken forToken) throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(eofMsg, forToken);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected void _closeInput() {
        if (this._reader != null) {
            this._reader = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        char[] buf;
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(buf);
        }
    }

    protected void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected boolean _loadMore() throws IOException {
        if (this._reader != null) {
            int count = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count > 0) {
                int bufSize = this._inputEnd;
                this._currInputProcessed += (long)bufSize;
                this._currInputRowStart -= bufSize;
                this._nameStartOffset -= (long)bufSize;
                this._inputPtr = 0;
                this._inputEnd = count;
                return true;
            }
            this._closeInput();
            if (count == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    @Override
    public final String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public final String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getText();
    }

    @Override
    public byte[] getBinaryValue() throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && this._binaryValue != null) {
            return this._binaryValue;
        }
        if (this._currToken != JsonToken.VALUE_STRING) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64();
            }
            catch (IllegalArgumentException iae) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + Base64Variants.getDefaultVariant() + "): " + iae.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), builder, Base64Variants.getDefaultVariant());
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public final JsonToken nextToken() throws IOException {
        JsonToken t;
        boolean inObject;
        int i;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((i = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (i == 93 || i == 125) {
            this._closeScope(i);
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            i = this._skipComma(i);
        }
        if (inObject = this._parsingContext.inObject()) {
            this._updateNameLocation();
            String name = i == 34 ? this._parseName() : this._handleOddName(i);
            this._parsingContext.setCurrentName(name);
            this._currToken = JsonToken.FIELD_NAME;
            i = this._skipColon();
        }
        this._updateLocation();
        switch (i) {
            case 34: {
                this._tokenIncomplete = true;
                t = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!inObject) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                t = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!inObject) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                t = JsonToken.START_OBJECT;
                break;
            }
            case 125: {
                this._reportUnexpectedChar(i, "expected a value");
            }
            case 116: {
                this._matchTrue();
                t = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchFalse();
                t = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                t = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                t = this._parseNegNumber();
                break;
            }
            case 46: {
                t = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                t = this._parsePosNumber(i);
                break;
            }
            default: {
                t = this._handleOddValue(i);
            }
        }
        if (inObject) {
            this._nextToken = t;
            return this._currToken;
        }
        this._currToken = t;
        return t;
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod() throws IOException {
        return this._handleOddValue(46);
    }

    protected final JsonToken _parsePosNumber(int ch) throws IOException {
        int ptr = this._inputPtr;
        int startPtr = ptr - 1;
        int inputLen = this._inputEnd;
        if (ch == 48) {
            return this._parseNumber2(false, startPtr);
        }
        int intLen = 1;
        while (true) {
            if (ptr >= inputLen) {
                this._inputPtr = startPtr;
                return this._parseNumber2(false, startPtr);
            }
            if ((ch = this._inputBuffer[ptr++]) < 48 || ch > 57) break;
            ++intLen;
        }
        if (ch == 46 || ch == 101 || ch == 69) {
            this._inputPtr = ptr;
            return this._parseFloat(ch, startPtr, ptr, false, intLen);
        }
        this._inputPtr = --ptr;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(ch);
        }
        int len = ptr - startPtr;
        this._textBuffer.resetWithShared(this._inputBuffer, startPtr, len);
        return this.resetInt(false, intLen);
    }

    private JsonToken _parseFloat(int ch, int startPtr, int ptr, boolean neg, int intLen) throws IOException {
        int inputLen = this._inputEnd;
        int fractLen = 0;
        if (ch == 46) {
            while (true) {
                if (ptr >= inputLen) {
                    return this._parseNumber2(neg, startPtr);
                }
                if ((ch = this._inputBuffer[ptr++]) < 48 || ch > 57) break;
                ++fractLen;
            }
            if (fractLen == 0) {
                this.reportUnexpectedNumberChar(ch, "Decimal point not followed by a digit");
            }
        }
        int expLen = 0;
        if (ch == 101 || ch == 69) {
            if (ptr >= inputLen) {
                this._inputPtr = startPtr;
                return this._parseNumber2(neg, startPtr);
            }
            if ((ch = this._inputBuffer[ptr++]) == 45 || ch == 43) {
                if (ptr >= inputLen) {
                    this._inputPtr = startPtr;
                    return this._parseNumber2(neg, startPtr);
                }
                ch = this._inputBuffer[ptr++];
            }
            while (ch <= 57 && ch >= 48) {
                ++expLen;
                if (ptr >= inputLen) {
                    this._inputPtr = startPtr;
                    return this._parseNumber2(neg, startPtr);
                }
                ch = this._inputBuffer[ptr++];
            }
            if (expLen == 0) {
                this.reportUnexpectedNumberChar(ch, "Exponent indicator not followed by a digit");
            }
        }
        this._inputPtr = --ptr;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(ch);
        }
        int len = ptr - startPtr;
        this._textBuffer.resetWithShared(this._inputBuffer, startPtr, len);
        return this.resetFloat(neg, intLen, fractLen, expLen);
    }

    protected final JsonToken _parseNegNumber() throws IOException {
        char ch;
        int ptr = this._inputPtr;
        int startPtr = ptr - 1;
        int inputLen = this._inputEnd;
        if (ptr >= inputLen) {
            return this._parseNumber2(true, startPtr);
        }
        if ((ch = this._inputBuffer[ptr++]) > '9' || ch < '0') {
            this._inputPtr = ptr;
            return this._handleInvalidNumberStart(ch, true);
        }
        if (ch == '0') {
            return this._parseNumber2(true, startPtr);
        }
        int intLen = 1;
        while (true) {
            if (ptr >= inputLen) {
                return this._parseNumber2(true, startPtr);
            }
            if ((ch = this._inputBuffer[ptr++]) < '0' || ch > '9') break;
            ++intLen;
        }
        if (ch == '.' || ch == 'e' || ch == 'E') {
            this._inputPtr = ptr;
            return this._parseFloat(ch, startPtr, ptr, true, intLen);
        }
        this._inputPtr = --ptr;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(ch);
        }
        int len = ptr - startPtr;
        this._textBuffer.resetWithShared(this._inputBuffer, startPtr, len);
        return this.resetInt(true, intLen);
    }

    private JsonToken _parseNumber2(boolean neg, int startPtr) throws IOException {
        char c;
        this._inputPtr = neg ? startPtr + 1 : startPtr;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        if (neg) {
            outBuf[outPtr++] = 45;
        }
        int intLen = 0;
        char c2 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("No digit following minus sign", JsonToken.VALUE_NUMBER_INT);
        if (c == '0') {
            c = this._verifyNoLeadingZeroes();
        }
        boolean eof = false;
        while (c >= '0' && c <= '9') {
            ++intLen;
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = c;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                c = '\u0000';
                eof = true;
                break;
            }
            c = this._inputBuffer[this._inputPtr++];
        }
        if (intLen == 0) {
            return this._handleInvalidNumberStart(c, neg);
        }
        int fractLen = 0;
        if (c == '.') {
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = c;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    eof = true;
                    break;
                }
                if ((c = this._inputBuffer[this._inputPtr++]) < '0' || c > '9') break;
                ++fractLen;
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outBuf[outPtr++] = c;
            }
            if (fractLen == 0) {
                this.reportUnexpectedNumberChar(c, "Decimal point not followed by a digit");
            }
        }
        int expLen = 0;
        if (c == 'e' || c == 'E') {
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = c;
            char c3 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent", null);
            if (c == '-' || c == '+') {
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outBuf[outPtr++] = c;
                char c4 = c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent", null);
            }
            while (c <= '9' && c >= '0') {
                ++expLen;
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outBuf[outPtr++] = c;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    eof = true;
                    break;
                }
                c = this._inputBuffer[this._inputPtr++];
            }
            if (expLen == 0) {
                this.reportUnexpectedNumberChar(c, "Exponent indicator not followed by a digit");
            }
        }
        if (!eof) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(c);
            }
        }
        this._textBuffer.setCurrentLength(outPtr);
        return this.reset(neg, intLen, fractLen, expLen);
    }

    private char _verifyNoLeadingZeroes() throws IOException {
        char ch;
        if (this._inputPtr < this._inputEnd && ((ch = this._inputBuffer[this._inputPtr]) < '0' || ch > '9')) {
            return '0';
        }
        return this._verifyNLZ2();
    }

    private char _verifyNLZ2() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return '0';
        }
        char ch = this._inputBuffer[this._inputPtr];
        if (ch < '0' || ch > '9') {
            return '0';
        }
        this.reportInvalidNumber();
        return ch;
    }

    protected JsonToken _handleInvalidNumberStart(int ch, boolean negative) throws IOException {
        if (ch == 73) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if ((ch = this._inputBuffer[this._inputPtr++]) == 110) {
                String match = negative ? "-Infinity" : "+Infinity";
                this._matchToken(match, 3);
                if (JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
                    return this.resetAsNaN(match, negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + match + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(ch, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    private void _verifyRootSpace(int ch) throws IOException {
        ++this._inputPtr;
        switch (ch) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                this._skipCR();
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportUnexpectedChar(ch, "Expected space separating root-level values");
    }

    protected final String _parseName() throws IOException {
        int ptr;
        int hash = this._hashSeed;
        int[] codes = _icLatin1;
        for (ptr = this._inputPtr; ptr < this._inputEnd; ++ptr) {
            char ch = this._inputBuffer[ptr];
            if (ch < codes.length && codes[ch] != 0) {
                if (ch != '\"') break;
                int start = this._inputPtr;
                this._inputPtr = ptr + 1;
                return this._symbols.findSymbol(this._inputBuffer, start, ptr - start, hash);
            }
            hash = hash * 33 + ch;
        }
        int start = this._inputPtr;
        this._inputPtr = ptr;
        return this._parseName2(start, hash);
    }

    private String _parseName2(int startPtr, int hash) throws IOException {
        this._textBuffer.resetWithShared(this._inputBuffer, startPtr, this._inputPtr - startPtr);
        char[] outBuf = this._textBuffer.getCurrentSegment();
        int outPtr = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char i;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            if ((i = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (i == '\\') {
                    c = this._decodeEscaped();
                } else if (i <= '\"') {
                    if (i == '\"') break;
                    if (i < ' ') {
                        this._throwUnquotedSpace(i, "name");
                    }
                }
            }
            hash = hash * 33 + c;
            outBuf[outPtr++] = c;
            if (outPtr < outBuf.length) continue;
            outBuf = this._textBuffer.finishCurrentSegment();
            outPtr = 0;
        }
        this._textBuffer.setCurrentLength(outPtr);
        TextBuffer tb = this._textBuffer;
        char[] buf = tb.getTextBuffer();
        int start = tb.getTextOffset();
        int len = tb.size();
        return this._symbols.findSymbol(buf, start, len, hash);
    }

    protected String _handleOddName(int i) throws IOException {
        this._reportUnexpectedChar(i, "was expecting double-quote to start field name");
        return null;
    }

    protected JsonToken _handleOddValue(int i) throws IOException {
        switch (i) {
            case 39: {
                break;
            }
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                break;
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if (JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    this._reportInvalidEOFInValue();
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++], false);
            }
        }
        if (Character.isJavaIdentifierStart(i)) {
            this._reportInvalidToken("" + (char)i);
        }
        this._reportUnexpectedChar(i, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    @Override
    protected final void _finishString() throws IOException {
        int ptr = this._inputPtr;
        int inputLen = this._inputEnd;
        if (ptr < inputLen) {
            int[] codes = _icLatin1;
            int maxCode = codes.length;
            do {
                char ch;
                if ((ch = this._inputBuffer[ptr]) >= maxCode || codes[ch] == 0) continue;
                if (ch != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, ptr - this._inputPtr);
                this._inputPtr = ptr + 1;
                return;
            } while (++ptr < inputLen);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, ptr - this._inputPtr);
        this._inputPtr = ptr;
        this._finishString2();
    }

    protected void _finishString2() throws IOException {
        char[] outBuf = this._textBuffer.getCurrentSegment();
        int outPtr = this._textBuffer.getCurrentSegmentSize();
        int[] codes = _icLatin1;
        int maxCode = codes.length;
        while (true) {
            char c;
            char i;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            if ((i = (c = this._inputBuffer[this._inputPtr++])) < maxCode && codes[i] != 0) {
                if (i == '\"') break;
                if (i == '\\') {
                    c = this._decodeEscaped();
                } else if (i < ' ') {
                    this._throwUnquotedSpace(i, "string value");
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    protected final void _skipString() throws IOException {
        this._tokenIncomplete = false;
        int inPtr = this._inputPtr;
        int inLen = this._inputEnd;
        char[] inBuf = this._inputBuffer;
        while (true) {
            char i;
            if (inPtr >= inLen) {
                this._inputPtr = inPtr;
                if (!this._loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
                }
                inPtr = this._inputPtr;
                inLen = this._inputEnd;
            }
            if ((i = inBuf[inPtr++]) > '\\') continue;
            if (i == '\\') {
                this._inputPtr = inPtr;
                this._decodeEscaped();
                inPtr = this._inputPtr;
                inLen = this._inputEnd;
                continue;
            }
            if (i > '\"') continue;
            if (i == '\"') break;
            if (i >= ' ') continue;
            this._inputPtr = inPtr;
            this._throwUnquotedSpace(i, "string value");
        }
        this._inputPtr = inPtr;
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int _skipColon() throws IOException {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this._skipColon2(false);
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c == ':') {
            char i;
            if ((i = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (i == '/' || i == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return i;
            }
            if ((i == ' ' || i == '\t') && (i = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (i == '/' || i == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return i;
            }
            return this._skipColon2(true);
        }
        if (c == ' ' || c == '\t') {
            c = this._inputBuffer[++this._inputPtr];
        }
        if (c == ':') {
            char i;
            if ((i = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (i == '/' || i == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return i;
            }
            if ((i == ' ' || i == '\t') && (i = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (i == '/' || i == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return i;
            }
            return this._skipColon2(true);
        }
        return this._skipColon2(false);
    }

    private int _skipColon2(boolean gotColon) throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char i;
            if ((i = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (i == '/') {
                    this._skipComment();
                    continue;
                }
                if (gotColon) {
                    return i;
                }
                if (i != ':') {
                    this._reportUnexpectedChar(i, "was expecting a colon to separate field name and value");
                }
                gotColon = true;
                continue;
            }
            if (i >= ' ') continue;
            if (i == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (i == '\r') {
                this._skipCR();
                continue;
            }
            if (i == '\t') continue;
            this._throwInvalidSpace(i);
        }
        this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
        return -1;
    }

    private int _skipComma(int i) throws IOException {
        if (i != 44) {
            this._reportUnexpectedChar(i, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        while (this._inputPtr < this._inputEnd) {
            if ((i = this._inputBuffer[this._inputPtr++]) > 32) {
                if (i == 47 || i == 35) {
                    --this._inputPtr;
                    return this._skipAfterComma2();
                }
                return i;
            }
            if (i >= 32) continue;
            if (i == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (i == 13) {
                this._skipCR();
                continue;
            }
            if (i == 9) continue;
            this._throwInvalidSpace(i);
        }
        return this._skipAfterComma2();
    }

    private int _skipAfterComma2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char i;
            if ((i = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (i == '/') {
                    this._skipComment();
                    continue;
                }
                return i;
            }
            if (i >= ' ') continue;
            if (i == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (i == '\r') {
                this._skipCR();
                continue;
            }
            if (i == '\t') continue;
            this._throwInvalidSpace(i);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
    }

    private int _skipWSOrEnd() throws IOException {
        char i;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextChar();
        }
        if ((i = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (i == '/' || i == '#') {
                --this._inputPtr;
                return this._skipWSOrEnd2();
            }
            return i;
        }
        if (i != ' ') {
            if (i == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (i == '\r') {
                this._skipCR();
            } else if (i != '\t') {
                this._throwInvalidSpace(i);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((i = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (i == '/' || i == '#') {
                    --this._inputPtr;
                    return this._skipWSOrEnd2();
                }
                return i;
            }
            if (i == ' ') continue;
            if (i == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (i == '\r') {
                this._skipCR();
                continue;
            }
            if (i == '\t') continue;
            this._throwInvalidSpace(i);
        }
        return this._skipWSOrEnd2();
    }

    private int _skipWSOrEnd2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char i;
            if ((i = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (i == '/') {
                    this._skipComment();
                    continue;
                }
                return i;
            }
            if (i == ' ') continue;
            if (i == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (i == '\r') {
                this._skipCR();
                continue;
            }
            if (i == '\t') continue;
            this._throwInvalidSpace(i);
        }
        return this._eofAsNextChar();
    }

    private void _skipComment() throws IOException {
        char c;
        if (!JsonParser.Feature.ALLOW_COMMENTS.enabledIn(this._features)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '/') {
            this._skipLine();
        } else if (c == '*') {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(c, "was expecting either '*' or '/' for a comment");
        }
    }

    private void _skipCComment() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char i;
            if ((i = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (i == '*') {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (i >= ' ') continue;
            if (i == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (i == '\r') {
                this._skipCR();
                continue;
            }
            if (i == '\t') continue;
            this._throwInvalidSpace(i);
        }
        this._reportInvalidEOF(" in a comment", null);
    }

    private void _skipLine() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            char i;
            if ((i = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (i == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                break;
            }
            if (i == '\r') {
                this._skipCR();
                break;
            }
            if (i == '\t') continue;
            this._throwInvalidSpace(i);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        char c = this._inputBuffer[this._inputPtr++];
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c;
            }
            case 'u': {
                break;
            }
            default: {
                throw this._constructError("Unrecognized character escape " + ReaderBasedJsonParser._getCharDesc(c));
            }
        }
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            char ch;
            int digit;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
            }
            if ((digit = CharTypes.charToHex(ch = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(ch, "expected a hex-digit for character escape sequence");
            }
            value = value << 4 | digit;
        }
        return (char)value;
    }

    private void _matchTrue() throws IOException {
        char c;
        char[] b;
        int ptr = this._inputPtr;
        if (ptr + 3 < this._inputEnd && (b = this._inputBuffer)[ptr] == 'r' && b[++ptr] == 'u' && b[++ptr] == 'e' && ((c = b[++ptr]) < '0' || c == ']' || c == '}')) {
            this._inputPtr = ptr;
            return;
        }
        this._matchToken("true", 1);
    }

    private void _matchFalse() throws IOException {
        char c;
        char[] b;
        int ptr = this._inputPtr;
        if (ptr + 4 < this._inputEnd && (b = this._inputBuffer)[ptr] == 'a' && b[++ptr] == 'l' && b[++ptr] == 's' && b[++ptr] == 'e' && ((c = b[++ptr]) < '0' || c == ']' || c == '}')) {
            this._inputPtr = ptr;
            return;
        }
        this._matchToken("false", 1);
    }

    private void _matchNull() throws IOException {
        char c;
        char[] b;
        int ptr = this._inputPtr;
        if (ptr + 3 < this._inputEnd && (b = this._inputBuffer)[ptr] == 'u' && b[++ptr] == 'l' && b[++ptr] == 'l' && ((c = b[++ptr]) < '0' || c == ']' || c == '}')) {
            this._inputPtr = ptr;
            return;
        }
        this._matchToken("null", 1);
    }

    protected final void _matchToken(String matchStr, int i) throws IOException {
        int len = matchStr.length();
        if (this._inputPtr + len >= this._inputEnd) {
            this._matchToken2(matchStr, i);
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != matchStr.charAt(i)) {
                this._reportInvalidToken(matchStr.substring(0, i));
            }
            ++this._inputPtr;
        } while (++i < len);
        char ch = this._inputBuffer[this._inputPtr];
        if (ch >= '0' && ch != ']' && ch != '}') {
            this._checkMatchEnd(matchStr, i, ch);
        }
    }

    private void _matchToken2(String matchStr, int i) throws IOException {
        int len = matchStr.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this._loadMore() || this._inputBuffer[this._inputPtr] != matchStr.charAt(i)) {
                this._reportInvalidToken(matchStr.substring(0, i));
            }
            ++this._inputPtr;
        } while (++i < len);
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return;
        }
        char ch = this._inputBuffer[this._inputPtr];
        if (ch >= '0' && ch != ']' && ch != '}') {
            this._checkMatchEnd(matchStr, i, ch);
        }
    }

    private void _checkMatchEnd(String matchStr, int i, int c) throws IOException {
        char ch = (char)c;
        if (Character.isJavaIdentifierPart(ch)) {
            this._reportInvalidToken(matchStr.substring(0, i));
        }
    }

    protected byte[] _decodeBase64() throws IOException {
        Base64Variant b64variant = Base64Variants.getDefaultVariant();
        ByteArrayBuilder builder = this._getByteArrayBuilder();
        while (true) {
            char ch;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int bits = b64variant.decodeBase64Char(ch);
            if (bits < 0) {
                if (ch == '\"') {
                    return builder.toByteArray();
                }
                bits = this._decodeBase64Escape(b64variant, ch, 0);
                if (bits < 0) continue;
            }
            int decodedData = bits;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((bits = b64variant.decodeBase64Char(ch = this._inputBuffer[this._inputPtr++])) < 0) {
                bits = this._decodeBase64Escape(b64variant, ch, 1);
            }
            decodedData = decodedData << 6 | bits;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((bits = b64variant.decodeBase64Char(ch = this._inputBuffer[this._inputPtr++])) < 0) {
                if (bits != -2) {
                    if (ch == '\"') {
                        builder.append(decodedData >>= 4);
                        if (b64variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding();
                        }
                        return builder.toByteArray();
                    }
                    bits = this._decodeBase64Escape(b64variant, ch, 2);
                }
                if (bits == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!b64variant.usesPaddingChar(ch = this._inputBuffer[this._inputPtr++]) && this._decodeBase64Escape(b64variant, ch, 3) != -2) {
                        throw this.reportInvalidBase64Char(b64variant, ch, 3, "expected padding character '" + b64variant.getPaddingChar() + "'");
                    }
                    builder.append(decodedData >>= 4);
                    continue;
                }
            }
            decodedData = decodedData << 6 | bits;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((bits = b64variant.decodeBase64Char(ch = this._inputBuffer[this._inputPtr++])) < 0) {
                if (bits != -2) {
                    if (ch == '\"') {
                        builder.appendTwoBytes(decodedData >>= 2);
                        if (b64variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding();
                        }
                        return builder.toByteArray();
                    }
                    bits = this._decodeBase64Escape(b64variant, ch, 3);
                }
                if (bits == -2) {
                    builder.appendTwoBytes(decodedData >>= 2);
                    continue;
                }
            }
            decodedData = decodedData << 6 | bits;
            builder.appendThreeBytes(decodedData);
        }
    }

    private void _updateLocation() {
        int ptr = this._inputPtr;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = ptr - this._currInputRowStart;
    }

    private void _updateNameLocation() {
        int ptr = this._inputPtr;
        this._nameStartOffset = ptr;
        this._nameStartRow = this._currInputRow;
        this._nameStartCol = ptr - this._currInputRowStart;
    }

    protected void _reportInvalidToken(String matchedPart) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder(matchedPart);
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && Character.isJavaIdentifierPart(c = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            sb.append(c);
            if (sb.length() < 256) continue;
            sb.append("...");
            break;
        }
        throw this._constructError(String.format("Unrecognized token '%s': was expecting %s", sb, this._validJsonValueList()));
    }

    private void _closeScope(int i) throws JsonParseException {
        if (i == 93) {
            this._updateLocation();
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(i, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (i == 125) {
            this._updateLocation();
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(i, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }
}

