/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.binarydata;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class SerializableBinaryData
extends BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(SerializableBinaryData.class);
    private final Object content;
    private final ObjectSerializer serializer;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<SerializableBinaryData, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SerializableBinaryData.class, byte[].class, "bytes");

    public SerializableBinaryData(Object content, ObjectSerializer serializer) {
        this.content = content;
        this.serializer = Objects.requireNonNull(serializer, "'serializer' cannot be null.");
    }

    @Override
    public Long getLength() {
        return this.content == null ? null : Long.valueOf(this.toBytes().length);
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(Type type, ObjectSerializer serializer) {
        try {
            return serializer.deserializeFromBytes(this.toBytes(), type);
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public InputStream toStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        try {
            if (this.content == null) {
                jsonWriter.writeNull();
            } else {
                jsonWriter.writeRawValue(this.toString());
            }
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryData toReplayableBinaryData() {
        return this;
    }

    private byte[] getBytes() {
        try {
            return this.serializer.serializeToBytes(this.content);
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public void close() {
    }
}

