/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.binarydata;

import io.clientcore.core.implementation.utils.ImplUtils;
import io.clientcore.core.implementation.utils.IterableOfByteBuffersInputStream;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class ListByteBufferBinaryData
extends BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(ListByteBufferBinaryData.class);
    private final List<ByteBuffer> content;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<ListByteBufferBinaryData, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ListByteBufferBinaryData.class, byte[].class, "bytes");
    private Long cachedLength;

    ListByteBufferBinaryData(List<ByteBuffer> content) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
    }

    @Override
    public Long getLength() {
        if (this.cachedLength == null) {
            this.cachedLength = this.content.stream().mapToLong(Buffer::remaining).sum();
        }
        return this.cachedLength;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        if (this.getLength() > 0x7FFFFFF7L) {
            throw LOGGER.logThrowableAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + this.getLength()));
        }
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(Type type, ObjectSerializer serializer) {
        try {
            return serializer.deserializeFromBytes(this.toBytes(), type);
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public InputStream toStream() {
        return new IterableOfByteBuffersInputStream(this.content);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        try {
            for (ByteBuffer bb : this.content) {
                ImplUtils.writeByteBufferToStream(bb, outputStream);
            }
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public void writeTo(WritableByteChannel channel) {
        try {
            for (ByteBuffer bb : this.content) {
                bb = bb.duplicate();
                while (bb.hasRemaining()) {
                    channel.write(bb);
                }
            }
        }
        catch (IOException exception) {
            throw LOGGER.logThrowableAsError(CoreException.from(exception));
        }
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        try {
            jsonWriter.writeBinary(this.toBytes());
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryData toReplayableBinaryData() {
        return this;
    }

    private byte[] getBytes() {
        long length = this.getLength();
        if (length > 0x7FFFFFF7L) {
            throw LOGGER.logThrowableAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + length));
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        for (ByteBuffer bb : this.content) {
            bb = bb.duplicate();
            int count = bb.remaining();
            bb.get(bytes, offset, count);
            offset += count;
        }
        return bytes;
    }

    @Override
    public void close() {
    }
}

