/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.binarydata;

import io.clientcore.core.implementation.utils.ImplUtils;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class ByteBufferBinaryData
extends BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(ByteBufferBinaryData.class);
    private final ByteBuffer content;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<ByteBufferBinaryData, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ByteBufferBinaryData.class, byte[].class, "bytes");

    ByteBufferBinaryData(ByteBuffer content) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
    }

    @Override
    public Long getLength() {
        return this.content.remaining();
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(Type type, ObjectSerializer serializer) {
        try {
            return serializer.deserializeFromBytes(this.toBytes(), type);
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public InputStream toStream() {
        return new ByteArrayInputStream(this.toBytes());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.content.asReadOnlyBuffer();
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        ByteBuffer buffer = this.toByteBuffer();
        try {
            ImplUtils.writeByteBufferToStream(buffer, outputStream);
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        try {
            jsonWriter.writeBinary(this.toBytes());
        }
        catch (IOException e) {
            throw LOGGER.logThrowableAsError(CoreException.from(e));
        }
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryData toReplayableBinaryData() {
        return this;
    }

    private byte[] getBytes() {
        byte[] bytes = new byte[this.content.remaining()];
        this.content.mark();
        this.content.get(bytes);
        this.content.flip();
        return bytes;
    }

    @Override
    public void close() {
    }
}

