/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models;

import io.clientcore.core.implementation.http.RetryUtils;
import java.io.UncheckedIOException;

public abstract class CoreException
extends RuntimeException {
    public static CoreException from(Throwable cause) {
        return CoreException.from(null, cause);
    }

    public static CoreException from(String message, Throwable cause) {
        return CoreException.from(message, cause, RetryUtils.isRetryable(cause));
    }

    public static CoreException from(Throwable cause, boolean isRetryable) {
        return CoreException.from(null, cause, isRetryable);
    }

    static CoreException from(String message, Throwable cause, boolean isRetryable) {
        String updatedMessage = message;
        Throwable updatedCause = cause;
        if (cause instanceof CoreException) {
            CoreException e = (CoreException)cause;
            if (e.isRetryable() == isRetryable && message == null) {
                return e;
            }
            updatedMessage = CoreException.getMessage(message, cause);
            updatedCause = cause.getCause();
        } else if (cause instanceof UncheckedIOException) {
            updatedMessage = CoreException.getMessage(message, cause);
            updatedCause = cause.getCause();
        }
        return new CoreExceptionImpl(updatedMessage, updatedCause, isRetryable);
    }

    protected CoreException(String message, Throwable cause) {
        super(CoreException.getMessage(message, cause), cause);
    }

    public abstract boolean isRetryable();

    private static String getMessage(String message, Throwable cause) {
        if (message == null) {
            return cause == null ? null : cause.getMessage();
        }
        return message;
    }

    private static class CoreExceptionImpl
    extends CoreException {
        private final boolean isRetryable;

        CoreExceptionImpl(String message, Throwable cause, boolean isRetryable) {
            super(message, cause);
            this.isRetryable = isRetryable;
        }

        @Override
        public boolean isRetryable() {
            return this.isRetryable;
        }
    }
}

