/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.instrumentation.logging;

import io.clientcore.core.implementation.AccessibleByteArrayOutputStream;
import io.clientcore.core.implementation.instrumentation.DefaultLogger;
import io.clientcore.core.implementation.instrumentation.Slf4jLoggerShim;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.LogLevel;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class LoggingEvent {
    private static final LoggingEvent NOOP = new LoggingEvent(null, null, null, false);
    private final Slf4jLoggerShim logger;
    private final LogLevel level;
    private final Map<String, Object> globalPairs;
    private final boolean isEnabled;
    private Map<String, Object> keyValuePairs;
    private String eventName;
    private InstrumentationContext context = null;
    private Throwable throwable = null;

    static LoggingEvent create(Slf4jLoggerShim logger, LogLevel level, Map<String, Object> globalContext) {
        if (logger.canLogAtLevel(level)) {
            return new LoggingEvent(logger, level, globalContext, true);
        }
        return NOOP;
    }

    private LoggingEvent(Slf4jLoggerShim logger, LogLevel level, Map<String, Object> globalContext, boolean isEnabled) {
        this.logger = logger;
        this.level = level;
        this.isEnabled = isEnabled;
        this.globalPairs = globalContext;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public LoggingEvent addKeyValue(String key, String value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, Object value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, boolean value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, long value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, Supplier<String> valueSupplier) {
        if (this.isEnabled && valueSupplier != null) {
            this.addKeyValue(key, valueSupplier.get());
        }
        return this;
    }

    public LoggingEvent setInstrumentationContext(InstrumentationContext context) {
        this.context = context;
        return this;
    }

    public LoggingEvent setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public LoggingEvent setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public void log() {
        this.log((String)null);
    }

    public void log(String message) {
        this.performLogging(message);
    }

    public void log(Supplier<String> message) {
        if (this.isEnabled) {
            this.performLogging(message.get());
        }
    }

    private void performLogging(String message) {
        if (this.isEnabled) {
            this.logger.performLogging(this.level, this.getMessageWithContext(message), this.logger.canLogAtLevel(LogLevel.VERBOSE) ? this.throwable : null);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getMessageWithContext(String message) {
        if (this.context != null && this.context.isValid()) {
            this.addKeyValue("trace.id", this.context.getTraceId());
            this.addKeyValue("span.id", this.context.getSpanId());
        }
        if (this.throwable != null) {
            this.addKeyValueInternal("exception.type", this.throwable.getClass().getCanonicalName());
            this.addKeyValueInternal("exception.message", this.throwable.getMessage());
            if (this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
                StringBuilder stackTrace = new StringBuilder();
                DefaultLogger.appendThrowable(stackTrace, this.throwable);
                this.addKeyValue("exception.stacktrace", stackTrace.toString());
            }
        }
        int pairsCount = (this.keyValuePairs == null ? 0 : this.keyValuePairs.size()) + (this.globalPairs == null ? 0 : this.globalPairs.size());
        int messageLength = message == null ? 0 : message.length();
        int speculatedSize = 20 + pairsCount * 20 + messageLength;
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream(speculatedSize);){
            String string;
            block22: {
                JsonWriter jsonWriter = JsonWriter.toStream(outputStream);
                try {
                    jsonWriter.writeStartObject();
                    if (message != null) {
                        jsonWriter.writeStringField("message", message);
                    }
                    if (this.globalPairs != null) {
                        for (Map.Entry<String, Object> kvp : this.globalPairs.entrySet()) {
                            jsonWriter.writeUntypedField(kvp.getKey(), kvp.getValue());
                        }
                    }
                    if (this.keyValuePairs != null) {
                        for (Map.Entry<String, Object> kvp : this.keyValuePairs.entrySet()) {
                            jsonWriter.writeUntypedField(kvp.getKey(), kvp.getValue());
                        }
                    }
                    if (this.eventName != null) {
                        jsonWriter.writeStringField("event.name", this.eventName);
                    }
                    jsonWriter.writeEndObject().flush();
                    string = outputStream.toString(StandardCharsets.UTF_8);
                    if (jsonWriter == null) break block22;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void addKeyValueInternal(String key, Object value) {
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new HashMap<String, Object>();
        }
        this.keyValuePairs.put(key, value);
    }
}

