/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.instrumentation.logging;

import io.clientcore.core.implementation.instrumentation.DefaultLogger;
import io.clientcore.core.implementation.instrumentation.Slf4jLoggerShim;
import io.clientcore.core.instrumentation.logging.LogLevel;
import io.clientcore.core.instrumentation.logging.LoggingEvent;
import java.nio.file.InvalidPathException;
import java.util.Collections;
import java.util.Map;

public class ClientLogger {
    private final Slf4jLoggerShim logger;
    private final Map<String, Object> globalContext;

    public ClientLogger(Class<?> clazz) {
        this(clazz, null);
    }

    public ClientLogger(String className) {
        this(className, null);
    }

    public ClientLogger(String className, Map<String, Object> context) {
        this.logger = new Slf4jLoggerShim(ClientLogger.getClassPathFromClassName(className));
        this.globalContext = context == null ? null : Collections.unmodifiableMap(context);
    }

    public ClientLogger(Class<?> clazz, Map<String, Object> context) {
        this.logger = new Slf4jLoggerShim(clazz);
        this.globalContext = context == null ? null : Collections.unmodifiableMap(context);
    }

    ClientLogger(DefaultLogger defaultLogger, Map<String, Object> context) {
        this.logger = new Slf4jLoggerShim(defaultLogger);
        this.globalContext = context == null ? null : Collections.unmodifiableMap(context);
    }

    public <T extends Throwable> T logThrowableAsWarning(T throwable) {
        LoggingEvent.create(this.logger, LogLevel.WARNING, this.globalContext).setThrowable(throwable).log();
        return throwable;
    }

    public <T extends Throwable> T logThrowableAsError(T throwable) {
        LoggingEvent.create(this.logger, LogLevel.ERROR, this.globalContext).setThrowable(throwable).log();
        return throwable;
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        return this.logger.canLogAtLevel(logLevel);
    }

    public LoggingEvent atError() {
        return LoggingEvent.create(this.logger, LogLevel.ERROR, this.globalContext);
    }

    public LoggingEvent atWarning() {
        return LoggingEvent.create(this.logger, LogLevel.WARNING, this.globalContext);
    }

    public LoggingEvent atInfo() {
        return LoggingEvent.create(this.logger, LogLevel.INFORMATIONAL, this.globalContext);
    }

    public LoggingEvent atVerbose() {
        return LoggingEvent.create(this.logger, LogLevel.VERBOSE, this.globalContext);
    }

    public LoggingEvent atLevel(LogLevel level) {
        return LoggingEvent.create(this.logger, level, this.globalContext);
    }

    private static String getClassPathFromClassName(String className) {
        try {
            return Class.forName(className).getCanonicalName();
        }
        catch (ClassNotFoundException | InvalidPathException e) {
            return className;
        }
    }
}

