/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.implementation.utils.InternalContext0;
import io.clientcore.core.implementation.utils.InternalContext1;
import io.clientcore.core.implementation.utils.InternalContext2;
import io.clientcore.core.implementation.utils.InternalContext3;
import io.clientcore.core.implementation.utils.InternalContext4;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Map;
import java.util.Objects;

public abstract class InternalContext {
    static final Object SENTINEL = new Object();

    public abstract Object getKey();

    public abstract Object getValue();

    public abstract int size();

    public abstract InternalContext put(Object var1, Object var2);

    public final Object get(Object key) {
        Object value = this.getInternal(key);
        return Objects.equals(SENTINEL, value) ? null : value;
    }

    abstract Object getInternal(Object var1);

    public static InternalContext empty() {
        return InternalContext0.INSTANCE;
    }

    public static InternalContext of(Object key, Object value) {
        return new InternalContext1(key, value);
    }

    public static InternalContext of(Object key1, Object value1, Object key2, Object value2) {
        return new InternalContext2(key1, value1, key2, value2);
    }

    public static InternalContext of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3) {
        return new InternalContext3(key1, value1, key2, value2, key3, value3);
    }

    public static InternalContext of(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3, Object key4, Object value4) {
        return new InternalContext4(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static InternalContext of(Map<Object, Object> map, ClientLogger logger) {
        if (map == null) {
            throw logger.logThrowableAsError(new NullPointerException("map cannot be null"));
        }
        InternalContext context = InternalContext.empty();
        int entryCount = 0;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            context = context.put(InternalContext.validateKey(entry.getKey(), "key" + entryCount, logger), entry.getValue());
            ++entryCount;
        }
        return context;
    }

    private static Object validateKey(Object key, String keyName, ClientLogger logger) {
        if (key == null) {
            throw logger.logThrowableAsError(new NullPointerException(keyName + " cannot be null"));
        }
        return key;
    }
}

