/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel.tracing;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelAttributeKey;
import io.clientcore.core.implementation.instrumentation.otel.OTelContext;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpanContext;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import io.clientcore.core.instrumentation.tracing.TracingScope;

public class OTelSpan
implements Span {
    private static final ClientLogger LOGGER = new ClientLogger(OTelSpan.class);
    static final OTelSpan NOOP_SPAN;
    private static final Object ERROR_TYPE_ATTRIBUTE_KEY;
    private static final TracingScope NOOP_SCOPE;
    private static final FallbackInvoker SET_ATTRIBUTE_INVOKER;
    private static final FallbackInvoker SET_STATUS_INVOKER;
    private static final FallbackInvoker END_INVOKER;
    private static final FallbackInvoker GET_SPAN_CONTEXT_INVOKER;
    private static final FallbackInvoker IS_RECORDING_INVOKER;
    private static final FallbackInvoker STORE_IN_CONTEXT_INVOKER;
    private static final FallbackInvoker FROM_CONTEXT_INVOKER;
    private static final FallbackInvoker WRAP_INVOKER;
    private static final Object ERROR_STATUS_CODE;
    private final Object otelSpan;
    private final Object otelContext;
    private final boolean isRecording;
    private final SpanKind spanKind;
    private String errorType;
    private OTelSpanContext spanContext;

    OTelSpan(Object otelSpan, Object otelParentContext, SpanKind spanKind) {
        this.otelSpan = otelSpan;
        this.isRecording = otelSpan != null && (Boolean)IS_RECORDING_INVOKER.invoke(otelSpan) != false;
        this.spanKind = spanKind;
        Object contextWithSpan = otelSpan != null ? OTelSpan.storeInContext(otelSpan, otelParentContext) : otelParentContext;
        this.otelContext = OTelContext.markCoreSpan(contextWithSpan, this);
    }

    private OTelSpan(Object otelSpan, Object otelContext) {
        this.otelSpan = otelSpan;
        this.isRecording = false;
        this.spanKind = null;
        this.otelContext = otelContext;
    }

    @Override
    public OTelSpan setAttribute(String key, Object value) {
        Object otelKey;
        if (this.isInitialized() && this.isRecording && (otelKey = OTelAttributeKey.getKey(key, value)) != null) {
            SET_ATTRIBUTE_INVOKER.invoke(this.otelSpan, otelKey, OTelAttributeKey.castAttributeValue(value));
        }
        return this;
    }

    @Override
    public Span setError(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @Override
    public void end(Throwable throwable) {
        this.endSpan(throwable);
    }

    @Override
    public void end() {
        this.endSpan(null);
    }

    @Override
    public boolean isRecording() {
        return this.isRecording;
    }

    @Override
    public TracingScope makeCurrent() {
        return this.isInitialized() ? OTelSpan.wrapOTelScope(OTelContext.makeCurrent(this.otelContext)) : NOOP_SCOPE;
    }

    @Override
    public InstrumentationContext getInstrumentationContext() {
        if (this.spanContext != null) {
            return this.spanContext;
        }
        this.spanContext = this.isInitialized() ? new OTelSpanContext(GET_SPAN_CONTEXT_INVOKER.invoke(this.otelSpan), this.otelContext) : OTelSpanContext.getInvalid();
        return this.spanContext;
    }

    public SpanKind getSpanKind() {
        return this.spanKind;
    }

    Object getOtelSpan() {
        return this.otelSpan;
    }

    static OTelSpan createPropagatingSpan(OTelSpanContext spanContext) {
        Object span = OTelSpan.wrapSpanContext(spanContext.getOtelSpanContext());
        return new OTelSpan(span, spanContext.getOtelContext());
    }

    static Object createPropagatingSpan(Object otelContext) {
        assert (OTelInitializer.CONTEXT_CLASS.isInstance(otelContext));
        Object span = OTelSpan.fromOTelContext(otelContext);
        Object spanContext = GET_SPAN_CONTEXT_INVOKER.invoke(span);
        assert (OTelInitializer.SPAN_CONTEXT_CLASS.isInstance(spanContext));
        return OTelSpan.wrapSpanContext(spanContext);
    }

    static Object fromOTelContext(Object otelContext) {
        assert (OTelInitializer.CONTEXT_CLASS.isInstance(otelContext));
        Object span = FROM_CONTEXT_INVOKER.invoke(otelContext);
        assert (OTelInitializer.SPAN_CLASS.isInstance(span));
        return span;
    }

    public static Object wrapSpanContext(Object otelSpanContext) {
        return WRAP_INVOKER.invoke(otelSpanContext);
    }

    static Object getSpanContext(Object otelSpan) {
        assert (OTelInitializer.SPAN_CLASS.isInstance(otelSpan));
        Object spanContext = GET_SPAN_CONTEXT_INVOKER.invoke(otelSpan);
        assert (OTelInitializer.SPAN_CONTEXT_CLASS.isInstance(spanContext));
        return spanContext;
    }

    public static Object storeInContext(Object otelSpan, Object otelContext) {
        Object updatedContext = STORE_IN_CONTEXT_INVOKER.invoke(otelSpan, otelContext);
        return updatedContext != null ? updatedContext : otelContext;
    }

    private void endSpan(Throwable throwable) {
        if (this.isInitialized()) {
            if (this.errorType != null || throwable != null) {
                String errorTypeStr = this.errorType != null ? this.errorType : throwable.getClass().getCanonicalName();
                SET_ATTRIBUTE_INVOKER.invoke(this.otelSpan, ERROR_TYPE_ATTRIBUTE_KEY, errorTypeStr);
                SET_STATUS_INVOKER.invoke(this.otelSpan, ERROR_STATUS_CODE, throwable == null ? null : throwable.getMessage());
            }
            END_INVOKER.invoke(this.otelSpan);
        }
    }

    private static TracingScope wrapOTelScope(AutoCloseable otelScope) {
        return () -> {
            try {
                otelScope.close();
            }
            catch (Exception e) {
                OTelInitializer.runtimeError(LOGGER, e);
            }
        };
    }

    private boolean isInitialized() {
        return this.otelSpan != null && OTelInitializer.isInitialized();
    }

    static {
        NOOP_SCOPE = () -> {};
        ReflectiveInvoker setAttributeInvoker = null;
        ReflectiveInvoker setStatusInvoker = null;
        ReflectiveInvoker endInvoker = null;
        ReflectiveInvoker getSpanContextInvoker = null;
        ReflectiveInvoker isRecordingInvoker = null;
        ReflectiveInvoker storeInContextInvoker = null;
        ReflectiveInvoker fromContextInvoker = null;
        ReflectiveInvoker wrapInvoker = null;
        Object errorStatusCode = null;
        OTelSpan noopSpan = null;
        Object errorTypeAttributeKey = null;
        if (OTelInitializer.isInitialized()) {
            try {
                setAttributeInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("setAttribute", OTelInitializer.ATTRIBUTE_KEY_CLASS, Object.class));
                setStatusInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("setStatus", OTelInitializer.STATUS_CODE_CLASS, String.class));
                endInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("end", new Class[0]));
                isRecordingInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("isRecording", new Class[0]));
                getSpanContextInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("getSpanContext", new Class[0]));
                storeInContextInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("storeInContext", OTelInitializer.CONTEXT_CLASS));
                fromContextInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("fromContext", OTelInitializer.CONTEXT_CLASS));
                wrapInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("wrap", OTelInitializer.SPAN_CONTEXT_CLASS));
                errorStatusCode = OTelInitializer.STATUS_CODE_CLASS.getField("ERROR").get(null);
                ReflectiveInvoker getInvalidInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CLASS, OTelInitializer.SPAN_CLASS.getMethod("getInvalid", new Class[0]));
                Object invalidSpan = getInvalidInvoker.invoke();
                Object rootContext = OTelContext.getCurrent();
                noopSpan = new OTelSpan(invalidSpan, rootContext);
                errorTypeAttributeKey = OTelAttributeKey.getKey("error.type", "");
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        SET_ATTRIBUTE_INVOKER = new FallbackInvoker(setAttributeInvoker, LOGGER);
        SET_STATUS_INVOKER = new FallbackInvoker(setStatusInvoker, LOGGER);
        END_INVOKER = new FallbackInvoker(endInvoker, LOGGER);
        GET_SPAN_CONTEXT_INVOKER = new FallbackInvoker(getSpanContextInvoker, OTelSpanContext.INVALID_OTEL_SPAN_CONTEXT, LOGGER);
        IS_RECORDING_INVOKER = new FallbackInvoker(isRecordingInvoker, false, LOGGER);
        STORE_IN_CONTEXT_INVOKER = new FallbackInvoker(storeInContextInvoker, LOGGER);
        FROM_CONTEXT_INVOKER = new FallbackInvoker(fromContextInvoker, LOGGER);
        WRAP_INVOKER = new FallbackInvoker(wrapInvoker, LOGGER);
        NOOP_SPAN = noopSpan;
        ERROR_STATUS_CODE = errorStatusCode;
        ERROR_TYPE_ATTRIBUTE_KEY = errorTypeAttributeKey;
    }
}

