/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.instrumentation.logging.ClientLogger;

public class OTelAttributeKey {
    private static final ClientLogger LOGGER = new ClientLogger(OTelAttributeKey.class);
    private static final FallbackInvoker CREATE_STRING_KEY_INVOKER;
    private static final FallbackInvoker CREATE_BOOLEAN_KEY_INVOKER;
    private static final FallbackInvoker CREATE_LONG_KEY_INVOKER;
    private static final FallbackInvoker CREATE_DOUBLE_KEY_INVOKER;

    public static Object getKey(String key, Object value) {
        if (OTelInitializer.isInitialized()) {
            if (value instanceof Boolean) {
                return CREATE_BOOLEAN_KEY_INVOKER.invoke(key);
            }
            if (value instanceof String) {
                return CREATE_STRING_KEY_INVOKER.invoke(key);
            }
            if (value instanceof Long) {
                return CREATE_LONG_KEY_INVOKER.invoke(key);
            }
            if (value instanceof Integer) {
                return CREATE_LONG_KEY_INVOKER.invoke(key);
            }
            if (value instanceof Double) {
                return CREATE_DOUBLE_KEY_INVOKER.invoke(key);
            }
            if (value instanceof Float) {
                return CREATE_DOUBLE_KEY_INVOKER.invoke(key);
            }
            if (value == null) {
                return CREATE_STRING_KEY_INVOKER.invoke(key);
            }
            LOGGER.atVerbose().addKeyValue("key", key).addKeyValue("type", value.getClass().getName()).log("Could not populate attribute. Type is not supported.");
            return null;
        }
        return null;
    }

    public static Object castAttributeValue(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        return value;
    }

    static {
        ReflectiveInvoker createStringKeyInvoker = null;
        ReflectiveInvoker createBooleanKeyInvoker = null;
        ReflectiveInvoker createLongKeyInvoker = null;
        ReflectiveInvoker createDoubleKeyInvoker = null;
        try {
            createStringKeyInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTE_KEY_CLASS, OTelInitializer.ATTRIBUTE_KEY_CLASS.getMethod("stringKey", String.class));
            createBooleanKeyInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTE_KEY_CLASS, OTelInitializer.ATTRIBUTE_KEY_CLASS.getMethod("booleanKey", String.class));
            createLongKeyInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTE_KEY_CLASS, OTelInitializer.ATTRIBUTE_KEY_CLASS.getMethod("longKey", String.class));
            createDoubleKeyInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.ATTRIBUTE_KEY_CLASS, OTelInitializer.ATTRIBUTE_KEY_CLASS.getMethod("doubleKey", String.class));
        }
        catch (Throwable t) {
            OTelInitializer.initError(LOGGER, t);
        }
        CREATE_STRING_KEY_INVOKER = new FallbackInvoker(createStringKeyInvoker, LOGGER);
        CREATE_BOOLEAN_KEY_INVOKER = new FallbackInvoker(createBooleanKeyInvoker, LOGGER);
        CREATE_LONG_KEY_INVOKER = new FallbackInvoker(createLongKeyInvoker, LOGGER);
        CREATE_DOUBLE_KEY_INVOKER = new FallbackInvoker(createDoubleKeyInvoker, LOGGER);
    }
}

