/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.rest;

import io.clientcore.core.http.annotations.BodyParam;
import io.clientcore.core.http.annotations.FormParam;
import io.clientcore.core.http.annotations.HeaderParam;
import io.clientcore.core.http.annotations.HostParam;
import io.clientcore.core.http.annotations.HttpRequestInformation;
import io.clientcore.core.http.annotations.PathParam;
import io.clientcore.core.http.annotations.QueryParam;
import io.clientcore.core.http.annotations.UnexpectedResponseExceptionDetail;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.RequestContext;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.models.ServerSentEventListener;
import io.clientcore.core.implementation.AccessibleByteArrayOutputStream;
import io.clientcore.core.implementation.TypeUtil;
import io.clientcore.core.implementation.http.UnexpectedExceptionInformation;
import io.clientcore.core.implementation.http.rest.HeaderSubstitution;
import io.clientcore.core.implementation.http.rest.MissingRequiredAnnotationException;
import io.clientcore.core.implementation.http.rest.QuerySubstitution;
import io.clientcore.core.implementation.http.rest.RangeReplaceSubstitution;
import io.clientcore.core.implementation.http.rest.Substitution;
import io.clientcore.core.implementation.http.rest.SwaggerInterfaceParser;
import io.clientcore.core.implementation.http.serializer.CompositeSerializer;
import io.clientcore.core.implementation.http.serializer.HttpResponseDecodeData;
import io.clientcore.core.implementation.utils.UriEscapers;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.utils.Base64Uri;
import io.clientcore.core.utils.CoreUtils;
import io.clientcore.core.utils.DateTimeRfc1123;
import io.clientcore.core.utils.ExpandableEnum;
import io.clientcore.core.utils.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SwaggerMethodParser
implements HttpResponseDecodeData {
    private final String rawHost;
    private final String fullyQualifiedMethodName;
    private final ClientLogger logger;
    private final HttpMethod httpMethod;
    private final String relativePath;
    private final Map<String, List<String>> queryParams = new LinkedHashMap<String, List<String>>();
    final List<RangeReplaceSubstitution> hostSubstitutions = new ArrayList<RangeReplaceSubstitution>();
    private final List<RangeReplaceSubstitution> pathSubstitutions = new ArrayList<RangeReplaceSubstitution>();
    private final List<QuerySubstitution> querySubstitutions = new ArrayList<QuerySubstitution>();
    private final List<Substitution> formSubstitutions = new ArrayList<Substitution>();
    private final List<HeaderSubstitution> headerSubstitutions = new ArrayList<HeaderSubstitution>();
    private final HttpHeaders requestHeaders = new HttpHeaders();
    private final Integer bodyContentMethodParameterIndex;
    private final String bodyContentType;
    private final Type bodyJavaType;
    private final BitSet expectedStatusCodes;
    private final Type returnType;
    private final Type returnValueWireType;
    private final UnexpectedResponseExceptionDetail[] unexpectedResponseExceptionDetails;
    private final int requestOptionsPosition;
    private final boolean returnTypeDecodable;
    private final boolean headersEagerlyConverted;
    private final int serverSentEventListenerPosition;
    private Map<Integer, UnexpectedExceptionInformation> exceptionMapping;
    private UnexpectedExceptionInformation defaultException;

    public SwaggerMethodParser(Method swaggerMethod) {
        this(SwaggerInterfaceParser.getInstance(swaggerMethod.getDeclaringClass()), swaggerMethod);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SwaggerMethodParser(SwaggerInterfaceParser interfaceParser, Method swaggerMethod) {
        Class<?> returnValueWireType;
        String[] requestQueryParams;
        this.rawHost = interfaceParser.getHost();
        Class<?> swaggerInterface = swaggerMethod.getDeclaringClass();
        this.fullyQualifiedMethodName = swaggerInterface.getName() + "." + swaggerMethod.getName();
        this.logger = new ClientLogger(this.fullyQualifiedMethodName);
        if (!swaggerMethod.isAnnotationPresent(HttpRequestInformation.class)) {
            throw new MissingRequiredAnnotationException(Collections.singletonList(HttpRequestInformation.class), swaggerMethod);
        }
        HttpRequestInformation httpRequestInformation = swaggerMethod.getAnnotation(HttpRequestInformation.class);
        this.httpMethod = httpRequestInformation.method();
        this.relativePath = httpRequestInformation.path();
        this.returnType = swaggerMethod.getGenericReturnType();
        String[] requestHeaders = httpRequestInformation.headers();
        if (requestHeaders != null) {
            for (String requestHeader : requestHeaders) {
                String headerValue;
                String headerName;
                int colonIndex = requestHeader.indexOf(":");
                if (colonIndex < 0 || (headerName = requestHeader.substring(0, colonIndex).trim()).isEmpty() || (headerValue = requestHeader.substring(colonIndex + 1).trim()).isEmpty()) continue;
                if (headerValue.contains(",")) {
                    this.requestHeaders.set(HttpHeaderName.fromString(headerName), Arrays.asList(headerValue.split(",")));
                    continue;
                }
                this.requestHeaders.set(HttpHeaderName.fromString(headerName), headerValue);
            }
        }
        if ((requestQueryParams = httpRequestInformation.queryParams()) != null) {
            for (String queryParam : requestQueryParams) {
                String paramValue;
                String paramName;
                if (CoreUtils.isNullOrEmpty(queryParam)) {
                    throw new IllegalStateException("Query parameters cannot be null or empty.");
                }
                int equalsIndex = queryParam.indexOf("=");
                if (equalsIndex >= 0) {
                    paramName = UriEscapers.QUERY_ESCAPER.escape(queryParam.substring(0, equalsIndex));
                    if (paramName.isEmpty()) throw new IllegalStateException("Names for query parameters cannot be empty.");
                    paramValue = UriEscapers.QUERY_ESCAPER.escape(queryParam.substring(equalsIndex + 1));
                } else {
                    paramName = UriEscapers.QUERY_ESCAPER.escape(queryParam);
                    paramValue = null;
                }
                List<String> currentValues = this.queryParams.get(paramName);
                if (!CoreUtils.isNullOrEmpty(paramValue)) {
                    if (currentValues == null) {
                        currentValues = new ArrayList<String>();
                    }
                    currentValues.add(paramValue);
                    this.queryParams.put(paramName, currentValues);
                    continue;
                }
                this.queryParams.put(paramName, null);
            }
        }
        this.returnValueWireType = (returnValueWireType = httpRequestInformation.returnValueWireType()) == Base64Uri.class || returnValueWireType == DateTimeRfc1123.class ? returnValueWireType : (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, List.class) ? returnValueWireType.getGenericInterfaces()[0] : null);
        int[] expectedResponses = httpRequestInformation.expectedStatusCodes();
        if (expectedResponses.length > 0) {
            this.expectedStatusCodes = new BitSet();
            for (int code : expectedResponses) {
                this.expectedStatusCodes.set(code);
            }
        } else {
            this.expectedStatusCodes = null;
        }
        this.unexpectedResponseExceptionDetails = (UnexpectedResponseExceptionDetail[])swaggerMethod.getAnnotationsByType(UnexpectedResponseExceptionDetail.class);
        Integer bodyContentMethodParameterIndex = null;
        String bodyContentType = null;
        Object bodyJavaType = null;
        Annotation[][] allParametersAnnotations = swaggerMethod.getParameterAnnotations();
        for (int parameterIndex = 0; parameterIndex < allParametersAnnotations.length; ++parameterIndex) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = swaggerMethod.getParameterAnnotations()[parameterIndex]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(HostParam.class)) {
                    HostParam hostParamAnnotation = (HostParam)annotation;
                    this.hostSubstitutions.add(new RangeReplaceSubstitution(hostParamAnnotation.value(), parameterIndex, !hostParamAnnotation.encoded(), this.rawHost));
                    continue;
                }
                if (annotationType.equals(PathParam.class)) {
                    PathParam pathParamAnnotation = (PathParam)annotation;
                    this.pathSubstitutions.add(new RangeReplaceSubstitution(pathParamAnnotation.value(), parameterIndex, !pathParamAnnotation.encoded(), this.relativePath));
                    continue;
                }
                if (annotationType.equals(QueryParam.class)) {
                    QueryParam queryParamAnnotation = (QueryParam)annotation;
                    this.querySubstitutions.add(new QuerySubstitution(queryParamAnnotation.value(), parameterIndex, !queryParamAnnotation.encoded(), queryParamAnnotation.multipleQueryParams()));
                    continue;
                }
                if (annotationType.equals(HeaderParam.class)) {
                    HeaderParam headerParamAnnotation = (HeaderParam)annotation;
                    this.headerSubstitutions.add(new HeaderSubstitution(headerParamAnnotation.value(), parameterIndex, false));
                    continue;
                }
                if (annotationType.equals(BodyParam.class)) {
                    BodyParam bodyParamAnnotation = (BodyParam)annotation;
                    bodyContentMethodParameterIndex = parameterIndex;
                    bodyContentType = bodyParamAnnotation.value();
                    bodyJavaType = swaggerMethod.getGenericParameterTypes()[parameterIndex];
                    continue;
                }
                if (!annotationType.equals(FormParam.class)) continue;
                FormParam formParamAnnotation = (FormParam)annotation;
                this.formSubstitutions.add(new Substitution(formParamAnnotation.value(), parameterIndex, !formParamAnnotation.encoded()));
                bodyContentType = "application/x-www-form-urlencoded";
                bodyJavaType = String.class;
            }
        }
        this.bodyContentMethodParameterIndex = bodyContentMethodParameterIndex;
        this.bodyContentType = bodyContentType;
        this.bodyJavaType = bodyJavaType;
        Class<?>[] parameterTypes = swaggerMethod.getParameterTypes();
        int requestOptionsPosition = -1;
        int serverSentEventListenerPosition = -1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType == RequestContext.class && requestOptionsPosition == -1) {
                requestOptionsPosition = i;
                continue;
            }
            if (parameterType != ServerSentEventListener.class) continue;
            serverSentEventListenerPosition = i;
        }
        this.requestOptionsPosition = requestOptionsPosition;
        this.serverSentEventListenerPosition = serverSentEventListenerPosition;
        this.headersEagerlyConverted = TypeUtil.isTypeOrSubTypeOf(Response.class, this.returnType);
        Type unwrappedReturnType = SwaggerMethodParser.unwrapReturnType(this.returnType);
        this.returnTypeDecodable = SwaggerMethodParser.isReturnTypeDecodable(unwrappedReturnType);
    }

    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public ClientLogger getMethodLogger() {
        return this.logger;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setSchemeAndHost(Object[] swaggerMethodArguments, UriBuilder uriBuilder, CompositeSerializer serializer) {
        SwaggerMethodParser.setSchemeAndHost(this.rawHost, this.hostSubstitutions, swaggerMethodArguments, uriBuilder, serializer);
    }

    static void setSchemeAndHost(String rawHost, List<RangeReplaceSubstitution> hostSubstitutions, Object[] swaggerMethodArguments, UriBuilder uriBuilder, CompositeSerializer serializer) {
        String substitutedHost = SwaggerMethodParser.applySubstitutions(rawHost, hostSubstitutions, swaggerMethodArguments, serializer);
        int index = substitutedHost.indexOf("://");
        if (index == -1) {
            uriBuilder.setHost(substitutedHost);
        } else {
            uriBuilder.setScheme(substitutedHost.substring(0, index));
            String host = substitutedHost.substring(index + 3);
            if (!CoreUtils.isNullOrEmpty(host)) {
                uriBuilder.setHost(host);
            } else {
                uriBuilder.setHost(substitutedHost);
            }
        }
    }

    public String setPath(Object[] methodArguments, CompositeSerializer serializer) {
        return SwaggerMethodParser.applySubstitutions(this.relativePath, this.pathSubstitutions, methodArguments, serializer);
    }

    public void setEncodedQueryParameters(Object[] swaggerMethodArguments, UriBuilder uriBuilder, CompositeSerializer serializer) {
        for (Map.Entry<String, List<String>> entry : this.queryParams.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) {
                uriBuilder.addQueryParameter(entry.getKey(), null);
                continue;
            }
            for (String paramValue : entry.getValue()) {
                uriBuilder.addQueryParameter(entry.getKey(), paramValue);
            }
        }
        if (swaggerMethodArguments == null) {
            return;
        }
        for (QuerySubstitution substitution : this.querySubstitutions) {
            int parameterIndex = substitution.getMethodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
            Object methodArgument = swaggerMethodArguments[substitution.getMethodParameterIndex()];
            if (substitution.mergeParameters() && methodArgument instanceof List) {
                List methodArguments = (List)methodArgument;
                for (Object argument : methodArguments) {
                    SwaggerMethodParser.addSerializedQueryParameter(serializer, argument, substitution.shouldEncode(), uriBuilder, substitution.getUriParameterName());
                }
                continue;
            }
            SwaggerMethodParser.addSerializedQueryParameter(serializer, methodArgument, substitution.shouldEncode(), uriBuilder, substitution.getUriParameterName());
        }
    }

    public void setHeaders(Object[] swaggerMethodArguments, HttpHeaders headers, CompositeSerializer serializer) {
        headers.setAll(this.requestHeaders);
        if (swaggerMethodArguments == null) {
            return;
        }
        for (HeaderSubstitution headerSubstitution : this.headerSubstitutions) {
            int parameterIndex = headerSubstitution.getMethodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
            Object methodArgument = swaggerMethodArguments[headerSubstitution.getMethodParameterIndex()];
            if (methodArgument instanceof Map) {
                Map headerCollection = (Map)methodArgument;
                String headerCollectionPrefix = headerSubstitution.getUriParameterName();
                for (Map.Entry headerCollectionEntry : headerCollection.entrySet()) {
                    String headerName = headerCollectionPrefix + headerCollectionEntry.getKey();
                    String headerValue = SwaggerMethodParser.serialize(serializer, headerCollectionEntry.getValue());
                    if (headerValue == null) continue;
                    headers.set(HttpHeaderName.fromString(headerName), headerValue);
                }
                continue;
            }
            String headerValue = SwaggerMethodParser.serialize(serializer, methodArgument);
            if (headerValue == null) continue;
            headers.set(headerSubstitution.getHeaderName(), headerValue);
        }
    }

    public RequestContext setRequestContext(Object[] swaggerMethodArguments) {
        return this.requestOptionsPosition < 0 ? null : (RequestContext)swaggerMethodArguments[this.requestOptionsPosition];
    }

    public ServerSentEventListener setServerSentEventListener(Object[] swaggerMethodArguments) {
        return this.serverSentEventListenerPosition < 0 ? null : (ServerSentEventListener)swaggerMethodArguments[this.serverSentEventListenerPosition];
    }

    @Override
    public boolean isExpectedResponseStatusCode(int statusCode) {
        return this.expectedStatusCodes == null ? statusCode < 400 : this.expectedStatusCodes.get(statusCode);
    }

    @Override
    public UnexpectedExceptionInformation getUnexpectedException(int code) {
        if (this.exceptionMapping == null) {
            this.exceptionMapping = this.processUnexpectedResponseExceptionTypes();
        }
        return this.exceptionMapping.getOrDefault(code, this.defaultException);
    }

    public Object setBody(Object[] swaggerMethodArguments, CompositeSerializer serializer) {
        Object result = null;
        if (this.bodyContentMethodParameterIndex != null && swaggerMethodArguments != null && 0 <= this.bodyContentMethodParameterIndex && this.bodyContentMethodParameterIndex < swaggerMethodArguments.length) {
            result = swaggerMethodArguments[this.bodyContentMethodParameterIndex];
        }
        if (!CoreUtils.isNullOrEmpty(this.formSubstitutions) && swaggerMethodArguments != null) {
            result = this.formSubstitutions.stream().map(substitution -> SwaggerMethodParser.serializeFormData(serializer, substitution.getUriParameterName(), swaggerMethodArguments[substitution.getMethodParameterIndex()], substitution.shouldEncode())).filter(Objects::nonNull).collect(Collectors.joining("&"));
        }
        return result;
    }

    public String getBodyContentType() {
        return this.bodyContentType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    public Type getBodyJavaType() {
        return this.bodyJavaType;
    }

    @Override
    public Type getReturnValueWireType() {
        return this.returnValueWireType;
    }

    private static void addSerializedQueryParameter(CompositeSerializer adapter, Object value, boolean shouldEncode, UriBuilder uriBuilder, String parameterName) {
        String parameterValue = SwaggerMethodParser.serialize(adapter, value);
        if (parameterValue != null) {
            if (shouldEncode) {
                parameterValue = UriEscapers.QUERY_ESCAPER.escape(parameterValue);
            }
            uriBuilder.addQueryParameter(parameterName, parameterValue);
        }
    }

    private static String serialize(CompositeSerializer serializer, Object value) {
        String string;
        if (value == null) {
            return null;
        }
        if (value instanceof ExpandableEnum) {
            value = SwaggerMethodParser.serialize(serializer, ((ExpandableEnum)value).getValue());
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value.getClass().isPrimitive() || value.getClass().isEnum() || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof DateTimeRfc1123) {
            return String.valueOf(value);
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).format(DateTimeFormatter.ISO_INSTANT);
        }
        AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();
        try {
            serializer.serializeToStream(outputStream, value, SerializationFormat.JSON);
            string = outputStream.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        outputStream.close();
        return string;
    }

    private static String serializeFormData(CompositeSerializer serializer, String key, Object value, boolean shouldEncode) {
        if (value == null) {
            return null;
        }
        String encodedKey = UriEscapers.FORM_ESCAPER.escape(key);
        if (value instanceof List) {
            return ((List)value).stream().map(element -> SwaggerMethodParser.serializeAndEncodeFormValue(serializer, element, shouldEncode)).filter(Objects::nonNull).map(formValue -> encodedKey + "=" + formValue).collect(Collectors.joining("&"));
        }
        return encodedKey + "=" + SwaggerMethodParser.serializeAndEncodeFormValue(serializer, value, shouldEncode);
    }

    private static String serializeAndEncodeFormValue(CompositeSerializer serializer, Object value, boolean shouldEncode) {
        if (value == null) {
            return null;
        }
        String serializedValue = SwaggerMethodParser.serialize(serializer, value);
        return shouldEncode ? UriEscapers.FORM_ESCAPER.escape(serializedValue) : serializedValue;
    }

    private static String applySubstitutions(String originalValue, List<RangeReplaceSubstitution> substitutions, Object[] methodArguments, CompositeSerializer serializer) {
        int originalSize;
        if (methodArguments == null || CoreUtils.isNullOrEmpty(substitutions)) {
            return originalValue;
        }
        int substitutionSize = originalSize = originalValue.length();
        TreeMap<RangeReplaceSubstitution.Range, String> replacements = new TreeMap<RangeReplaceSubstitution.Range, String>();
        for (RangeReplaceSubstitution substitution : substitutions) {
            int substitutionParameterIndex = substitution.getMethodParameterIndex();
            if (substitutionParameterIndex < 0 || substitutionParameterIndex >= methodArguments.length) continue;
            Object methodArgument = methodArguments[substitutionParameterIndex];
            String substitutionValue = SwaggerMethodParser.serialize(serializer, methodArgument);
            if (substitutionValue != null && !substitutionValue.isEmpty() && substitution.shouldEncode()) {
                substitutionValue = UriEscapers.PATH_ESCAPER.escape(substitutionValue);
            }
            if (substitutionValue == null) {
                substitutionValue = "";
            }
            for (RangeReplaceSubstitution.Range range : substitution.getRanges()) {
                substitutionSize += substitutionValue.length() - range.getSize();
                replacements.put(range, substitutionValue);
            }
        }
        int last = 0;
        StringBuilder builder = new StringBuilder(substitutionSize);
        for (Map.Entry replacement : replacements.entrySet()) {
            if (last < ((RangeReplaceSubstitution.Range)replacement.getKey()).getStart()) {
                builder.append(originalValue, last, ((RangeReplaceSubstitution.Range)replacement.getKey()).getStart());
            }
            builder.append((String)replacement.getValue());
            last = ((RangeReplaceSubstitution.Range)replacement.getKey()).getEnd();
        }
        if (last < originalSize) {
            builder.append(originalValue, last, originalSize);
        }
        return builder.toString();
    }

    private Map<Integer, UnexpectedExceptionInformation> processUnexpectedResponseExceptionTypes() {
        HashMap<Integer, UnexpectedExceptionInformation> exceptionHashMap = new HashMap<Integer, UnexpectedExceptionInformation>();
        for (UnexpectedResponseExceptionDetail exceptionAnnotation : this.unexpectedResponseExceptionDetails) {
            UnexpectedExceptionInformation exception = new UnexpectedExceptionInformation(exceptionAnnotation.exceptionBodyClass());
            if (exceptionAnnotation.statusCode().length == 0) {
                this.defaultException = exception;
                continue;
            }
            for (int statusCode : exceptionAnnotation.statusCode()) {
                exceptionHashMap.put(statusCode, exception);
            }
        }
        if (this.defaultException == null) {
            this.defaultException = new UnexpectedExceptionInformation(null);
        }
        return exceptionHashMap;
    }

    @Override
    public boolean isReturnTypeDecodable() {
        return this.returnTypeDecodable;
    }

    @Override
    public boolean isHeadersEagerlyConverted() {
        return this.headersEagerlyConverted;
    }

    public static boolean isReturnTypeDecodable(Type unwrappedReturnType) {
        if (unwrappedReturnType == null) {
            return false;
        }
        return !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, BinaryData.class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, ByteBuffer.class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, InputStream.class) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(unwrappedReturnType, Void.class);
    }

    public static Type unwrapReturnType(Type returnType) {
        if (returnType == null) {
            return null;
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Response.class)) {
            returnType = SwaggerMethodParser.walkSuperTypesUntil(returnType, type -> TypeUtil.typeImplementsInterface(type, Response.class));
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArgument(returnType));
        }
        return returnType;
    }

    private static Type walkSuperTypesUntil(Type type, Predicate<Type> untilChecker) {
        while (!untilChecker.test(type)) {
            type = TypeUtil.getSuperType(type);
        }
        return type;
    }
}

