/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation;

import io.clientcore.core.implementation.MethodHandleReflectiveInvoker;
import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectionUtilsApi;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

final class ReflectionUtilsMethodHandle
implements ReflectionUtilsApi {
    private static final ClientLogger LOGGER = new ClientLogger(ReflectionUtilsMethodHandle.class);
    private static final boolean MODULE_BASED;
    private static final MethodHandle CLASS_GET_MODULE_METHOD_HANDLE;
    private static final MethodHandle MODULE_IS_NAMED_METHOD_HANDLE;
    private static final MethodHandle MODULE_ADD_READS_METHOD_HANDLE;
    private static final MethodHandle METHOD_HANDLES_PRIVATE_LOOKUP_IN_METHOD_HANDLE;
    private static final MethodHandle MODULE_IS_OPEN_UNCONDITIONALLY_METHOD_HANDLE;
    private static final MethodHandle MODULE_IS_OPEN_TO_OTHER_MODULE_METHOD_HANDLE;
    private static final MethodHandles.Lookup LOOKUP;
    private static final Object CORE_MODULE;
    private static final MethodHandle JDK_INTERNAL_PRIVATE_LOOKUP_IN_CONSTRUCTOR;

    ReflectionUtilsMethodHandle() {
    }

    @Override
    public ReflectiveInvoker getMethodInvoker(Class<?> targetClass, Method method, boolean scopeToClientCore) throws Exception {
        MethodHandles.Lookup lookup = ReflectionUtilsMethodHandle.getLookupToUse(targetClass, scopeToClientCore);
        return new MethodHandleReflectiveInvoker(lookup.unreflect(method));
    }

    @Override
    public ReflectiveInvoker getConstructorInvoker(Class<?> targetClass, Constructor<?> constructor, boolean scopeToClientCore) throws Exception {
        MethodHandles.Lookup lookup = ReflectionUtilsMethodHandle.getLookupToUse(targetClass, scopeToClientCore);
        return new MethodHandleReflectiveInvoker(lookup.unreflectConstructor(constructor));
    }

    @Override
    public boolean isModuleBased() {
        return MODULE_BASED;
    }

    private static MethodHandles.Lookup getLookupToUse(Class<?> targetClass, boolean scopeToClientCore) throws Exception {
        try {
            if (MODULE_BASED) {
                if (!scopeToClientCore) {
                    return MethodHandles.publicLookup();
                }
                Object responseModule = CLASS_GET_MODULE_METHOD_HANDLE.invoke(targetClass);
                if (!MODULE_IS_NAMED_METHOD_HANDLE.invoke(responseModule)) {
                    MODULE_ADD_READS_METHOD_HANDLE.invokeWithArguments(CORE_MODULE, responseModule);
                    return ReflectionUtilsMethodHandle.performSafePrivateLookupIn(targetClass);
                }
                if (responseModule == CORE_MODULE) {
                    return LOOKUP;
                }
                String packageName = targetClass.getPackage().getName();
                if (((Boolean)MODULE_IS_OPEN_UNCONDITIONALLY_METHOD_HANDLE.invokeWithArguments(responseModule, packageName)).booleanValue() || ((Boolean)MODULE_IS_OPEN_TO_OTHER_MODULE_METHOD_HANDLE.invokeWithArguments(responseModule, packageName, CORE_MODULE)).booleanValue()) {
                    MODULE_ADD_READS_METHOD_HANDLE.invokeWithArguments(CORE_MODULE, responseModule);
                    return ReflectionUtilsMethodHandle.performSafePrivateLookupIn(targetClass);
                }
                return MethodHandles.publicLookup();
            }
            return JDK_INTERNAL_PRIVATE_LOOKUP_IN_CONSTRUCTOR.invoke(targetClass);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
    }

    private static MethodHandles.Lookup performSafePrivateLookupIn(Class<?> targetClass) throws Throwable {
        return METHOD_HANDLES_PRIVATE_LOOKUP_IN_METHOD_HANDLE.invokeExact(targetClass, LOOKUP);
    }

    static {
        boolean moduleBased = false;
        MethodHandle classGetModule = null;
        MethodHandle moduleIsNamed = null;
        MethodHandle moduleAddReads = null;
        MethodHandle methodHandlesPrivateLookupIn = null;
        MethodHandle moduleIsOpenUnconditionally = null;
        MethodHandle moduleIsOpenToOtherModule = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object coreModule = null;
        MethodHandle jdkInternalPrivateLookupInConstructor = null;
        try {
            Class<?> moduleClass = Class.forName("java.lang.Module");
            classGetModule = lookup.unreflect(Class.class.getDeclaredMethod("getModule", new Class[0]));
            moduleIsNamed = lookup.unreflect(moduleClass.getDeclaredMethod("isNamed", new Class[0]));
            moduleAddReads = lookup.unreflect(moduleClass.getDeclaredMethod("addReads", moduleClass));
            methodHandlesPrivateLookupIn = lookup.findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
            moduleIsOpenUnconditionally = lookup.unreflect(moduleClass.getDeclaredMethod("isOpen", String.class));
            moduleIsOpenToOtherModule = lookup.unreflect(moduleClass.getDeclaredMethod("isOpen", String.class, moduleClass));
            coreModule = classGetModule.invokeWithArguments(ReflectionUtils.class);
            moduleBased = true;
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            LOGGER.atInfo().setThrowable(throwable).log("Unable to create MethodHandles to use Java 9+ MethodHandles.privateLookupIn. Will attempt to fallback to using the package-private constructor.");
        }
        if (!moduleBased) {
            try {
                Constructor privateLookupInConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                if (!privateLookupInConstructor.isAccessible()) {
                    privateLookupInConstructor.setAccessible(true);
                }
                jdkInternalPrivateLookupInConstructor = lookup.unreflectConstructor(privateLookupInConstructor);
            }
            catch (ReflectiveOperationException ex) {
                throw LOGGER.logThrowableAsError(new RuntimeException("Unable to use package-private MethodHandles.Lookup constructor.", ex));
            }
        }
        MODULE_BASED = moduleBased;
        CLASS_GET_MODULE_METHOD_HANDLE = classGetModule;
        MODULE_IS_NAMED_METHOD_HANDLE = moduleIsNamed;
        MODULE_ADD_READS_METHOD_HANDLE = moduleAddReads;
        METHOD_HANDLES_PRIVATE_LOOKUP_IN_METHOD_HANDLE = methodHandlesPrivateLookupIn;
        MODULE_IS_OPEN_UNCONDITIONALLY_METHOD_HANDLE = moduleIsOpenUnconditionally;
        MODULE_IS_OPEN_TO_OTHER_MODULE_METHOD_HANDLE = moduleIsOpenToOtherModule;
        LOOKUP = lookup;
        CORE_MODULE = coreModule;
        JDK_INTERNAL_PRIVATE_LOOKUP_IN_CONSTRUCTOR = jdkInternalPrivateLookupInConstructor;
    }
}

