/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.instrumentation.InstrumentationOptions;
import io.clientcore.core.utils.configuration.Configuration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class HttpInstrumentationOptions
extends InstrumentationOptions {
    private HttpLogLevel logLevel = ENVIRONMENT_HTTP_LOG_LEVEL;
    private boolean isRedactedHeaderNamesLoggingEnabled = true;
    private Set<HttpHeaderName> allowedHeaderNames = new HashSet<HttpHeaderName>(DEFAULT_HEADERS_ALLOWLIST);
    private Set<String> allowedQueryParamNames = new HashSet<String>(DEFAULT_QUERY_PARAMS_ALLOWLIST);
    private static final List<HttpHeaderName> DEFAULT_HEADERS_ALLOWLIST = Arrays.asList(HttpHeaderName.TRACEPARENT, HttpHeaderName.ACCEPT, HttpHeaderName.CACHE_CONTROL, HttpHeaderName.CONNECTION, HttpHeaderName.CONTENT_LENGTH, HttpHeaderName.CONTENT_TYPE, HttpHeaderName.DATE, HttpHeaderName.ETAG, HttpHeaderName.EXPIRES, HttpHeaderName.IF_MATCH, HttpHeaderName.IF_MODIFIED_SINCE, HttpHeaderName.IF_NONE_MATCH, HttpHeaderName.IF_UNMODIFIED_SINCE, HttpHeaderName.LAST_MODIFIED, HttpHeaderName.PRAGMA, HttpHeaderName.RETRY_AFTER, HttpHeaderName.SERVER, HttpHeaderName.TRANSFER_ENCODING, HttpHeaderName.USER_AGENT, HttpHeaderName.WWW_AUTHENTICATE);
    static final HttpLogLevel ENVIRONMENT_HTTP_LOG_LEVEL = HttpLogLevel.fromConfiguration(Configuration.getGlobalConfiguration());
    private static final List<String> DEFAULT_QUERY_PARAMS_ALLOWLIST = Collections.singletonList("api-version");

    public HttpLogLevel getHttpLogLevel() {
        return this.logLevel;
    }

    public boolean isRedactedHeaderNamesLoggingEnabled() {
        return this.isRedactedHeaderNamesLoggingEnabled;
    }

    public HttpInstrumentationOptions setRedactedHeaderNamesLoggingEnabled(boolean redactedHeaderNamesLoggingEnabled) {
        this.isRedactedHeaderNamesLoggingEnabled = redactedHeaderNamesLoggingEnabled;
        return this;
    }

    public HttpInstrumentationOptions setHttpLogLevel(HttpLogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public Set<HttpHeaderName> getAllowedHeaderNames() {
        return Collections.unmodifiableSet(this.allowedHeaderNames);
    }

    public HttpInstrumentationOptions setAllowedHeaderNames(Set<HttpHeaderName> allowedHeaderNames) {
        this.allowedHeaderNames = allowedHeaderNames == null ? new HashSet<HttpHeaderName>() : new HashSet<HttpHeaderName>(allowedHeaderNames);
        return this;
    }

    public HttpInstrumentationOptions addAllowedHeaderName(HttpHeaderName allowedHeaderName) {
        Objects.requireNonNull(allowedHeaderName);
        this.allowedHeaderNames.add(allowedHeaderName);
        return this;
    }

    public Set<String> getAllowedQueryParamNames() {
        return Collections.unmodifiableSet(this.allowedQueryParamNames);
    }

    public HttpInstrumentationOptions setAllowedQueryParamNames(Set<String> allowedQueryParamNames) {
        this.allowedQueryParamNames = allowedQueryParamNames == null ? new HashSet<String>() : new HashSet<String>(allowedQueryParamNames);
        return this;
    }

    public HttpInstrumentationOptions addAllowedQueryParamName(String allowedQueryParamName) {
        this.allowedQueryParamNames.add(allowedQueryParamName);
        return this;
    }

    @Override
    public HttpInstrumentationOptions setTracingEnabled(boolean isTracingEnabled) {
        super.setTracingEnabled(isTracingEnabled);
        return this;
    }

    @Override
    public HttpInstrumentationOptions setMetricsEnabled(boolean isMetricsEnabled) {
        super.setMetricsEnabled(isMetricsEnabled);
        return this;
    }

    @Override
    public HttpInstrumentationOptions setTelemetryProvider(Object telemetryProvider) {
        super.setTelemetryProvider(telemetryProvider);
        return this;
    }

    public static enum HttpLogLevel {
        NONE,
        HEADERS,
        BODY,
        BODY_AND_HEADERS;

        private static final String HEADERS_VALUE = "headers";
        private static final String BODY_VALUE = "body";
        private static final String BODY_AND_HEADERS_VALUE = "body_and_headers";

        static HttpLogLevel fromConfiguration(Configuration configuration) {
            String logLevel = configuration.get("HTTP_LOG_LEVEL");
            if (logLevel == null) {
                logLevel = configuration.get("http.log.level");
            }
            if (HEADERS_VALUE.equalsIgnoreCase(logLevel)) {
                return HEADERS;
            }
            if (BODY_VALUE.equalsIgnoreCase(logLevel)) {
                return BODY;
            }
            if (BODY_AND_HEADERS_VALUE.equalsIgnoreCase(logLevel)) {
                return BODY_AND_HEADERS;
            }
            return NONE;
        }
    }
}

