/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.ChallengeHandler;
import io.clientcore.core.utils.DigestChallengeHandler;
import java.util.List;

final class CompositeChallengeHandler
implements ChallengeHandler {
    private static final ClientLogger LOGGER = new ClientLogger(CompositeChallengeHandler.class);
    private final List<ChallengeHandler> challengeHandlers;

    CompositeChallengeHandler(List<ChallengeHandler> challengeHandlers) {
        this.challengeHandlers = challengeHandlers;
    }

    @Override
    public boolean canHandle(Response<BinaryData> response, boolean isProxy) {
        for (ChallengeHandler handler : this.challengeHandlers) {
            if (!handler.canHandle(response, isProxy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleChallenge(HttpRequest request, Response<BinaryData> response, boolean isProxy) {
        for (ChallengeHandler handler : this.challengeHandlers) {
            if (!handler.canHandle(response, isProxy) || !(handler instanceof DigestChallengeHandler)) continue;
            handler.handleChallenge(request, response, isProxy);
            return;
        }
        for (ChallengeHandler handler : this.challengeHandlers) {
            if (!handler.canHandle(response, isProxy)) continue;
            handler.handleChallenge(request, response, isProxy);
            return;
        }
        LOGGER.logThrowableAsError(new UnsupportedOperationException("None of the challenge handlers could handle the challenge."));
    }
}

