/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.AuthUtils;
import io.clientcore.core.utils.AuthenticateChallenge;
import io.clientcore.core.utils.ChallengeHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;

public class BasicChallengeHandler
implements ChallengeHandler {
    private final String authHeader;

    public BasicChallengeHandler(String username, String password) {
        String token = username + ":" + password;
        this.authHeader = "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChallenge(HttpRequest request, Response<BinaryData> response, boolean isProxy) {
        if (this.canHandle(response, isProxy)) {
            HttpHeaders httpHeaders = request.getHeaders();
            synchronized (httpHeaders) {
                HttpHeaderName headerName;
                HttpHeaderName httpHeaderName = headerName = isProxy ? HttpHeaderName.PROXY_AUTHORIZATION : HttpHeaderName.AUTHORIZATION;
                if (request.getHeaders().getValue(headerName) == null) {
                    request.getHeaders().add(headerName, this.authHeader);
                }
            }
        }
    }

    @Override
    public boolean canHandle(Response<BinaryData> response, boolean isProxy) {
        if (response.getHeaders() != null) {
            HttpHeaderName authHeaderName = isProxy ? HttpHeaderName.PROXY_AUTHENTICATE : HttpHeaderName.WWW_AUTHENTICATE;
            String authHeader = response.getHeaders().getValue(authHeaderName);
            if (authHeader != null) {
                List<AuthenticateChallenge> challenges = AuthUtils.parseAuthenticateHeader(authHeader);
                for (AuthenticateChallenge challenge : challenges) {
                    if (!"Basic".equalsIgnoreCase(challenge.getScheme())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

