/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.utils.CoreUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

public final class Base64Uri {
    private final byte[] bytes;

    public Base64Uri(String string) {
        if (string == null) {
            this.bytes = null;
        } else {
            string = Base64Uri.unquote(string);
            this.bytes = string.getBytes(StandardCharsets.UTF_8);
        }
    }

    public Base64Uri(byte[] bytes) {
        this.bytes = Base64Uri.unquote(bytes);
    }

    private static byte[] unquote(byte[] bytes) {
        byte lastByte;
        byte firstByte;
        if (bytes != null && bytes.length > 1 && ((firstByte = bytes[0]) == 34 || firstByte == 39) && (lastByte = bytes[bytes.length - 1]) == firstByte) {
            return Arrays.copyOfRange(bytes, 1, bytes.length - 1);
        }
        return bytes;
    }

    private static String unquote(String string) {
        int base64UriStringLength;
        char lastCharacter;
        char firstCharacter;
        if (!(CoreUtils.isNullOrEmpty(string) || (firstCharacter = string.charAt(0)) != '\"' && firstCharacter != '\'' || (lastCharacter = string.charAt((base64UriStringLength = string.length()) - 1)) != firstCharacter)) {
            return string.substring(1, base64UriStringLength - 1);
        }
        return string;
    }

    public static Base64Uri encode(byte[] bytes) {
        if (bytes == null) {
            return new Base64Uri((String)null);
        }
        return new Base64Uri(Base64Uri.encodeURIWithoutPadding(bytes));
    }

    private static byte[] encodeURIWithoutPadding(byte[] src) {
        return src == null ? null : Base64.getUrlEncoder().withoutPadding().encode(src);
    }

    public byte[] encodedBytes() {
        if (this.bytes == null) {
            return null;
        }
        return CoreUtils.arrayCopy(this.bytes);
    }

    public byte[] decodedBytes() {
        if (this.bytes == null) {
            return null;
        }
        return Base64.getUrlDecoder().decode(this.bytes);
    }

    public String toString() {
        return this.bytes == null ? "" : new String(this.bytes, StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Base64Uri)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Base64Uri)obj).encodedBytes());
    }
}

