/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.in;

import io.clientcore.core.serialization.xml.implementation.aalto.impl.ErrorConsts;
import io.clientcore.core.serialization.xml.implementation.aalto.impl.LocationImpl;
import io.clientcore.core.serialization.xml.implementation.aalto.impl.StreamExceptionBase;
import io.clientcore.core.serialization.xml.implementation.aalto.in.AttributeCollector;
import io.clientcore.core.serialization.xml.implementation.aalto.in.CharBasedPNameTable;
import io.clientcore.core.serialization.xml.implementation.aalto.in.ElementScope;
import io.clientcore.core.serialization.xml.implementation.aalto.in.InputCharTypes;
import io.clientcore.core.serialization.xml.implementation.aalto.in.NsBinding;
import io.clientcore.core.serialization.xml.implementation.aalto.in.NsDeclaration;
import io.clientcore.core.serialization.xml.implementation.aalto.in.PNameC;
import io.clientcore.core.serialization.xml.implementation.aalto.in.ReaderConfig;
import io.clientcore.core.serialization.xml.implementation.aalto.util.DataUtil;
import io.clientcore.core.serialization.xml.implementation.aalto.util.TextBuilder;
import io.clientcore.core.serialization.xml.implementation.aalto.util.XmlCharTypes;
import io.clientcore.core.serialization.xml.implementation.aalto.util.XmlChars;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;

public final class ReaderScanner
implements XMLStreamConstants,
NamespaceContext {
    private final String CDATA_STR = "CDATA[";
    public static final int TOKEN_EOI = -1;
    private static final int MAX_UNICODE_CHAR = 0x10FFFF;
    private static final int INT_NULL = 0;
    private static final int INT_CR = 13;
    private static final int INT_LF = 10;
    private static final int INT_TAB = 9;
    private static final int INT_SPACE = 32;
    private static final int INT_QMARK = 63;
    private static final int INT_AMP = 38;
    private static final int INT_LT = 60;
    private static final int INT_GT = 62;
    private static final int INT_QUOTE = 34;
    private static final int INT_APOS = 39;
    private static final int INT_COLON = 58;
    private static final int INT_SLASH = 47;
    private static final int INT_A = 65;
    private static final int BIND_MISSES_TO_ACTIVATE_CACHE = 10;
    private static final int BIND_CACHE_SIZE = 64;
    private static final int BIND_CACHE_MASK = 63;
    private static final XmlCharTypes sCharTypes = InputCharTypes.getLatin1CharTypes();
    private final Reader _in;
    private final ReaderConfig _config;
    private final boolean _cfgCoalescing;
    private int _currToken = 7;
    private boolean _tokenIncomplete = false;
    private int _depth = 0;
    private final TextBuilder _textBuilder;
    private boolean _entityPending = false;
    private char[] _nameBuffer;
    private PNameC _tokenName = null;
    private boolean _isEmptyTag = false;
    private ElementScope _currElem;
    private NsDeclaration _lastNsDecl = null;
    private int _currNsCount = 0;
    private final NsBinding _defaultNs = NsBinding.createDefaultNs();
    private NsBinding[] _nsBindings;
    private int _nsBindingCount = 0;
    private PNameC[] _nsBindingCache = null;
    private int _nsBindMisses = 0;
    private final AttributeCollector _attrCollector;
    private int _attrCount = 0;
    private long _pastBytesOrChars;
    private int _currRow;
    private int _rowStartOffset;
    private long _startRawOffset;
    private long _startRow = -1L;
    private long _startColumn = -1L;
    private final char[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private int mTmpChar = 0;
    private final CharBasedPNameTable _symbols;

    public ReaderScanner(ReaderConfig cfg, Reader r, char[] buffer, int ptr, int last) {
        this._config = cfg;
        this._cfgCoalescing = cfg.willCoalesceText();
        this._textBuilder = TextBuilder.createRecyclableBuffer(this._config);
        this._attrCollector = new AttributeCollector();
        this._nameBuffer = new char[60];
        this._currRow = 0;
        this._in = r;
        this._inputBuffer = buffer;
        this._inputPtr = ptr;
        this._inputEnd = last;
        this._pastBytesOrChars = 0L;
        this._rowStartOffset = 0;
        this._symbols = cfg.getCBSymbols();
    }

    public void close() throws XMLStreamException {
        this._releaseBuffers();
    }

    private void _releaseBuffers() {
        this._textBuilder.recycle(true);
        if (this._symbols.maybeDirty()) {
            this._config.updateCBSymbols(this._symbols);
        }
    }

    public ReaderConfig getConfig() {
        return this._config;
    }

    public int nextFromProlog(boolean isProlog) throws XMLStreamException {
        char c;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        this.setStartLocation();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.setStartLocation();
                return -1;
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) == '<') break;
            if (c == ' ') continue;
            if (c == '\n') {
                this.markLF();
                continue;
            }
            if (c == '\r') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    this.setStartLocation();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (c == '\t') continue;
            this.reportPrologUnexpChar(isProlog, c, null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '!') {
            return this.handlePrologDeclStart(isProlog);
        }
        if (c == '?') {
            return this.handlePIStart();
        }
        if (c == '/' || !isProlog) {
            this.reportPrologUnexpElement(isProlog, c);
        }
        return this.handleStartElement(c);
    }

    public int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                return this._nextEntity();
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            return this._nextEntity();
        }
        this.setStartLocation();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.setStartLocation();
            return -1;
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c == '<') {
            ++this._inputPtr;
            c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (c == '!') {
                return this.handleCommentOrCdataStart();
            }
            if (c == '?') {
                return this.handlePIStart();
            }
            if (c == '/') {
                return this.handleEndElement();
            }
            return this.handleStartElement(c);
        }
        if (c == '&') {
            ++this._inputPtr;
            int i = this.handleEntityInText();
            if (i == 0) {
                this._currToken = 9;
                return 9;
            }
            this.mTmpChar = -i;
        } else {
            this.mTmpChar = c;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        return 4;
    }

    private void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                throw new RuntimeException("Internal error");
            }
        }
    }

    private int _nextEntity() {
        this._textBuilder.resetWithEmpty();
        this._currToken = 9;
        return 9;
    }

    private boolean skipToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.skipPI();
                break;
            }
            case 4: {
                if (this.skipCharacters()) {
                    this._currToken = 9;
                    return true;
                }
                if (!this._cfgCoalescing || !this.skipCoalescedText()) break;
                this._currToken = 9;
                return true;
            }
            case 5: {
                this.skipComment();
                break;
            }
            case 6: {
                this.skipSpace();
                break;
            }
            case 12: {
                this.skipCData();
                if (!this._cfgCoalescing) break;
                this.skipCoalescedText();
                if (!this._entityPending) break;
                this._currToken = 9;
                return true;
            }
            case 11: {
                this.finishDTD(false);
                break;
            }
            default: {
                throw new Error("Internal error, unexpected incomplete token type " + ErrorConsts.tokenTypeDesc(this._currToken));
            }
        }
        return false;
    }

    public Location getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._pastBytesOrChars + (long)this._inputPtr, this._currRow, this._inputPtr - this._rowStartOffset);
    }

    private void markLF(int offset) {
        this._rowStartOffset = offset;
        ++this._currRow;
    }

    private void markLF() {
        this._rowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    private void setStartLocation() {
        this._startRawOffset = this._pastBytesOrChars + (long)this._inputPtr;
        this._startRow = this._currRow;
        this._startColumn = this._inputPtr - this._rowStartOffset;
    }

    public Location getStartLocation() {
        int row = (int)this._startRow;
        int col = (int)this._startColumn;
        return LocationImpl.fromZeroBased(this._startRawOffset, row, col);
    }

    public boolean hasEmptyStack() {
        return this._depth == 0;
    }

    public PNameC getName() {
        return this._tokenName;
    }

    public QName getQName() {
        return this._tokenName.constructQName(this._defaultNs);
    }

    public String getText() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsAsString();
    }

    public int getTextLength() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.size();
    }

    public char[] getTextCharacters() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.getTextBuffer();
    }

    public int getTextCharacters(int srcStart, char[] target, int targetStart, int len) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsToArray(srcStart, target, targetStart, len);
    }

    public boolean isTextWhitespace() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.isAllWhitespace();
    }

    public int getAttrCount() {
        return this._attrCount;
    }

    public String getAttrLocalName(int index) {
        return this._attrCollector.getName(index).getLocalName();
    }

    public QName getAttrQName(int index) {
        return this._attrCollector.getQName(index);
    }

    public String getAttrNsURI(int index) {
        return this._attrCollector.getName(index).getNsUri();
    }

    public String getAttrPrefix(int index) {
        return this._attrCollector.getName(index).getPrefix();
    }

    public String getAttrValue(int index) {
        return this._attrCollector.getValue(index);
    }

    public String getAttrValue(String nsURI, String localName) {
        if (this._attrCount < 1) {
            return null;
        }
        return this._attrCollector.getValue(nsURI, localName);
    }

    public int getNsCount() {
        if (this._currToken == 1) {
            return this._currNsCount;
        }
        return this._lastNsDecl == null ? 0 : this._lastNsDecl.countDeclsOnLevel(this._depth);
    }

    public String getNamespacePrefix(int index) {
        return this.findCurrNsDecl((int)index).getBinding().mPrefix;
    }

    public String getNamespaceURI(int index) {
        return this.findCurrNsDecl((int)index).getBinding().mURI;
    }

    private NsDeclaration findCurrNsDecl(int index) {
        int count;
        NsDeclaration nsDecl = this._lastNsDecl;
        int level = this._depth;
        if (this._currToken == 1) {
            count = this._currNsCount - 1 - index;
            --level;
        } else {
            count = index;
        }
        while (nsDecl != null && nsDecl.getLevel() == level) {
            if (count == 0) {
                return nsDecl;
            }
            --count;
            nsDecl = nsDecl.getPrev();
        }
        this.reportInvalidNsIndex(index);
        return null;
    }

    public String getNamespaceURI() {
        String uri = this._tokenName.getNsUri();
        return uri == null ? this._defaultNs.mURI : uri;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (prefix.isEmpty()) {
            String uri = this._defaultNs.mURI;
            return uri == null ? "" : uri;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            if (!nsDecl.hasPrefix(prefix)) continue;
            return nsDecl.getCurrNsURI();
        }
        return null;
    }

    @Override
    public String getPrefix(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (nsURI.equals(this._defaultNs.mURI)) {
            return "";
        }
        block0: for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            String prefix;
            if (!nsDecl.hasNsURI(nsURI) || (prefix = nsDecl.getPrefix()) == null) continue;
            for (NsDeclaration decl2 = this._lastNsDecl; decl2 != nsDecl; decl2 = decl2.getPrev()) {
                if (decl2.hasPrefix(prefix)) continue block0;
            }
            return prefix;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return Collections.singletonList("xml").iterator();
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return Collections.singletonList("xmlns").iterator();
        }
        ArrayList<String> l = null;
        if (nsURI.equals(this._defaultNs.mURI)) {
            l = new ArrayList<String>();
            l.add("");
        }
        block0: for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            String prefix;
            if (!nsDecl.hasNsURI(nsURI) || (prefix = nsDecl.getPrefix()) == null) continue;
            for (NsDeclaration decl2 = this._lastNsDecl; decl2 != nsDecl; decl2 = decl2.getPrev()) {
                if (decl2.hasPrefix(prefix)) continue block0;
            }
            if (l == null) {
                l = new ArrayList();
            }
            l.add(prefix);
        }
        if (l == null) {
            return Collections.emptyIterator();
        }
        if (l.size() == 1) {
            return Collections.singletonList((String)l.get(0)).iterator();
        }
        return l.iterator();
    }

    private int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
                this._tokenIncomplete = true;
                this._currToken = 5;
                return 5;
            }
        } else if (c == 'D' && isProlog) {
            this.handleDtdStart();
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(isProlog, c, " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private void handleDtdStart() throws XMLStreamException {
        String _systemId;
        this.matchAsciiKeyword("DOCTYPE");
        char c = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(c);
        c = this.skipInternalWs(false, null);
        if (c == 'P') {
            this.matchAsciiKeyword("PUBLIC");
            c = this.skipInternalWs(true, null);
            this.parsePublicId(c);
            c = this.skipInternalWs(true, null);
            _systemId = this.parseSystemId(c);
            c = this.skipInternalWs(false, null);
        } else if (c == 'S') {
            this.matchAsciiKeyword("SYSTEM");
            c = this.skipInternalWs(true, null);
            _systemId = this.parseSystemId(c);
            c = this.skipInternalWs(false, null);
        } else {
            _systemId = null;
        }
        if (c == '>') {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return;
        }
        if (c != '[') {
            String msg = _systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(c, msg);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
    }

    private int handleCommentOrCdataStart() throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) != '-') {
                this.reportTreeUnexpChar(c, " (expected '-' for COMMENT)");
            }
            this._tokenIncomplete = true;
            this._currToken = 5;
            return 5;
        }
        if (c == '[') {
            this._currToken = 12;
            for (int i = 0; i < 6; ++i) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
            }
            this._tokenIncomplete = true;
            return 12;
        }
        this.reportTreeUnexpChar(c, " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    private int handlePIStart() throws XMLStreamException {
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(c);
        String ln = this._tokenName.getLocalName();
        if (ln.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
            while (true) {
                if (c == '\n') {
                    this.markLF();
                } else if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (c != ' ' && c != '\t') {
                    this.throwInvalidSpace(c);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr]) > ' ') break;
                ++this._inputPtr;
            }
            this._tokenIncomplete = true;
        } else {
            if (c != '?') {
                this.reportMissingPISpace(c);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) != '>') {
                this.reportMissingPISpace(c);
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    private int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c = this._inputBuffer[this._inputPtr++];
        int value = 0;
        if (c == 'x') {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) != ';') {
                    value <<= 4;
                    if (c <= '9' && c >= '0') {
                        value += c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        value += 10 + (c - 97);
                    } else if (c >= 'A' && c <= 'F') {
                        value += 10 + (c - 65);
                    } else {
                        this.throwUnexpectedChar(c, "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (value <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (c != ';') {
                if (c <= '9' && c >= '0') {
                    if ((value = value * 10 + (c - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(c, "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                c = this._inputBuffer[this._inputPtr++];
            }
        }
        if (value >= 55296) {
            if (value < 57344) {
                this.reportInvalidXmlChar(value);
            }
            if (value == 65534 || value == 65535) {
                this.reportInvalidXmlChar(value);
            }
        } else if (value < 32 && value != 10 && value != 13 && value != 9) {
            this.reportInvalidXmlChar(value);
        }
        return value;
    }

    private int handleStartElement(char c) throws XMLStreamException {
        boolean allBound;
        this._currToken = 1;
        this._currNsCount = 0;
        PNameC elemName = this.parsePName(c);
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            allBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            allBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        int attrPtr = 0;
        while (true) {
            boolean isNsDecl;
            PNameC attrName;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
                do {
                    if (c == '\n') {
                        this.markLF();
                    } else if (c == '\r') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c != ' ' && c != '\t') {
                        this.throwInvalidSpace(c);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((c = this._inputBuffer[this._inputPtr++]) <= ' ');
            } else if (c != '/' && c != '>') {
                this.throwUnexpectedChar(c, " expected space, or '>' or \"/>\"");
            }
            if (c == '/') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) != '>') {
                    this.throwUnexpectedChar(c, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (c == '>') {
                this._isEmptyTag = false;
                break;
            }
            if (c == '<') {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((prefix = (attrName = this.parsePName(c)).getPrefix()) == null) {
                isNsDecl = attrName.getLocalName().equals("xmlns");
            } else if (prefix.equals("xmlns")) {
                isNsDecl = true;
            } else {
                attrName = this.bindName(attrName, prefix);
                if (allBound) {
                    allBound = attrName.isBound();
                }
                isNsDecl = false;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c == '\n') {
                    this.markLF();
                    continue;
                }
                if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                this.throwInvalidSpace(c);
            }
            if (c != '=') {
                this.throwUnexpectedChar(c, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c == '\n') {
                    this.markLF();
                    continue;
                }
                if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                this.throwInvalidSpace(c);
            }
            if (c != '\"' && c != '\'') {
                this.throwUnexpectedChar(c, " Expected a quote");
            }
            if (isNsDecl) {
                this.handleNsDeclaration(attrName, c);
                ++this._currNsCount;
                continue;
            }
            attrPtr = this.collectValue(attrPtr, c, attrName);
        }
        int act = this._attrCollector.finishLastValue(attrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!allBound) {
            if (!elemName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i = 0; i < len; ++i) {
                PNameC attrName = this._attrCollector.getName(i);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        return 1;
    }

    private int collectValue(int attrPtr, char quoteChar, PNameC attrName) throws XMLStreamException {
        char[] attrBuffer = this._attrCollector.startNewValue(attrName, attrPtr);
        int[] TYPES = ReaderScanner.sCharTypes.ATTR_CHARS;
        block9: while (true) {
            int d;
            int c;
            block29: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (attrPtr >= attrBuffer.length) {
                    attrBuffer = this._attrCollector.valueBufferFull();
                }
                if ((max2 = ptr + (attrBuffer.length - attrPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = this._inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block29;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block29;
                    }
                    attrBuffer[attrPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                    }
                    case 3: {
                        this.markLF();
                    }
                    case 8: {
                        c = 32;
                        break;
                    }
                    case 9: {
                        this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                    }
                    case 10: {
                        d = this.handleEntityInText();
                        if (d == 0) {
                            this.reportUnexpandedEntityInAttr(false);
                        }
                        if (d >> 16 != 0) {
                            attrBuffer[attrPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                            d = 0xDC00 | d & 0x3FF;
                            if (attrPtr >= attrBuffer.length) {
                                attrBuffer = this._attrCollector.valueBufferFull();
                            }
                        }
                        c = (char)d;
                        break;
                    }
                    case 14: {
                        if (c == quoteChar) break block9;
                    }
                }
            } else if (c < 57344) {
                d = this.checkSurrogate((char)c);
                attrBuffer[attrPtr++] = c;
                if (attrPtr >= attrBuffer.length) {
                    attrBuffer = this._attrCollector.valueBufferFull();
                }
                c = d;
            } else if (c >= 65534) {
                c = this.handleInvalidXmlChar(c);
            }
            attrBuffer[attrPtr++] = c;
        }
        return attrPtr;
    }

    private void handleNsDeclaration(PNameC name, char quoteChar) throws XMLStreamException {
        int attrPtr = 0;
        char[] attrBuffer = this._nameBuffer;
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            if (c == '&') {
                int d = this.handleEntityInText();
                if (d == 0) {
                    this.reportUnexpandedEntityInAttr(true);
                }
                if (d >> 16 != 0) {
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                    d = 0xDC00 | d & 0x3FF;
                }
                c = (char)d;
            } else if (c == '<') {
                this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
            } else if (c < ' ') {
                if (c == '\n') {
                    this.markLF();
                } else if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = '\n';
                } else if (c != '\t') {
                    this.throwInvalidSpace(c);
                }
            }
            if (attrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[attrPtr++] = c;
        }
        if (attrPtr == 0) {
            this.bindNs(name, "");
        } else {
            String uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(name, uri);
        }
    }

    private int handleEndElement() throws XMLStreamException {
        char c;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        String pname = this._tokenName.getPrefixedName();
        int i = 0;
        int len = pname.length();
        do {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == pname.charAt(i)) continue;
            this.reportUnexpectedEndTag(pname);
        } while (++i < len);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
            c = this.skipInternalWs(false, null);
        } else if (c != '>' && (c == ':' || XmlChars.is10NameChar(c))) {
            this.reportUnexpectedEndTag(pname);
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, " expected space or closing '>'");
        }
        return 2;
    }

    private int handleEntityInText() throws XMLStreamException {
        int cix;
        String start;
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '#') {
            return this.handleCharEntity();
        }
        if (c == 'a') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 'm') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'p') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                        return 38;
                    }
                    start = "amp";
                } else {
                    start = "am";
                }
            } else if (c == 'p') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == 's') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 39;
                        }
                        start = "apos";
                    } else {
                        start = "apo";
                    }
                } else {
                    start = "ap";
                }
            } else {
                start = "a";
            }
        } else if (c == 'l') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 60;
                }
                start = "lt";
            } else {
                start = "l";
            }
        } else if (c == 'g') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 62;
                }
                start = "gt";
            } else {
                start = "g";
            }
        } else if (c == 'q') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 'u') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 34;
                        }
                        start = "quot";
                    } else {
                        start = "quo";
                    }
                } else {
                    start = "qu";
                }
            } else {
                start = "q";
            }
        } else {
            start = "";
        }
        int[] TYPES = ReaderScanner.sCharTypes.NAME_CHARS;
        char[] cbuf = this._nameBuffer;
        int len = start.length();
        for (cix = 0; cix < len; ++cix) {
            cbuf[cix] = start.charAt(cix);
        }
        while (c != ';') {
            boolean ok;
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ok = cix > 0;
                        break;
                    }
                    case 3: {
                        ok = true;
                        break;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
            } else if (c < '\ue000') {
                int value = this.decodeSurrogate(c);
                if (cix >= cbuf.length) {
                    this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                }
                cbuf[cix++] = c;
                c = this._inputBuffer[this._inputPtr - 1];
                ok = XmlChars.is10NameChar(value);
            } else if (c >= '\ufffe') {
                c = this.handleInvalidXmlChar(c);
                ok = false;
            } else {
                ok = true;
            }
            if (!ok) {
                this.reportInvalidNameChar(c, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            c = this._inputBuffer[this._inputPtr++];
        }
        String pname = new String(cbuf, 0, cix);
        this._tokenName = new PNameC(pname, null, pname, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        return 0;
    }

    private void finishComment() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block6: while (true) {
            int c;
            block26: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block26;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block26;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 13: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '-') {
                            ++this._inputPtr;
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr++] == '>') break block6;
                            this.reportDoubleHyphenInComments();
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c < 57344) {
                int d = this.checkSurrogate((char)c);
                outputBuffer[outPtr++] = c;
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                c = d;
            } else if (c >= 65534) {
                c = this.handleInvalidXmlChar(c);
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    private void finishPI() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block5: while (true) {
            int c;
            block24: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block24;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block24;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '>') {
                            ++this._inputPtr;
                            break block5;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c < 57344) {
                int d = this.checkSurrogate((char)c);
                outputBuffer[outPtr++] = c;
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                c = d;
            } else if (c >= 65534) {
                c = this.handleInvalidXmlChar(c);
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    private void finishDTD(boolean copyContents) throws XMLStreamException {
        int c;
        char[] outputBuffer = copyContents ? this._textBuilder.resetWithEmpty() : null;
        int outPtr = 0;
        int[] TYPES = ReaderScanner.sCharTypes.DTD_CHARS;
        boolean inDecl = false;
        int quoteChar = 0;
        block9: while (true) {
            block34: {
                block33: {
                    block32: {
                        int ptr;
                        if ((ptr = this._inputPtr) >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        int max = this._inputEnd;
                        if (outputBuffer != null) {
                            int max2;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            if ((max2 = ptr + (outputBuffer.length - outPtr)) < max) {
                                max = max2;
                            }
                        }
                        while (ptr < max) {
                            if ((c = this._inputBuffer[ptr++]) <= 255) {
                                if (TYPES[c] != 0) {
                                    this._inputPtr = ptr;
                                    break block32;
                                }
                            } else if (c >= 55296) {
                                this._inputPtr = ptr;
                                break block32;
                            }
                            if (outputBuffer == null) continue;
                            outputBuffer[outPtr++] = c;
                        }
                        this._inputPtr = ptr;
                        continue;
                    }
                    if (c > 255) break block33;
                    switch (TYPES[c]) {
                        case 1: {
                            this.handleInvalidXmlChar(c);
                        }
                        case 2: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr] == '\n') {
                                ++this._inputPtr;
                            }
                            this.markLF();
                            c = 10;
                            break;
                        }
                        case 3: {
                            this.markLF();
                            break;
                        }
                        case 8: {
                            if (quoteChar == 0) {
                                quoteChar = c;
                                break;
                            }
                            if (quoteChar == c) {
                                quoteChar = 0;
                                break;
                            }
                            break block34;
                        }
                        case 9: {
                            if (!inDecl) {
                                inDecl = true;
                                break;
                            }
                            break block34;
                        }
                        case 10: {
                            if (quoteChar == 0) {
                                inDecl = false;
                                break;
                            }
                            break block34;
                        }
                        case 11: {
                            if (!inDecl && quoteChar == 0) break block9;
                        }
                    }
                    break block34;
                }
                if (c < 57344) {
                    int d = this.checkSurrogate((char)c);
                    if (outputBuffer != null) {
                        outputBuffer[outPtr++] = c;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                    }
                    c = d;
                } else if (c >= 65534) {
                    c = this.handleInvalidXmlChar(c);
                }
            }
            if (outputBuffer == null) continue;
            outputBuffer[outPtr++] = c;
        }
        if (outputBuffer != null) {
            this._textBuilder.setCurrentLength(outPtr);
        }
        if ((c = this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(c, " expected '>' after the internal subset");
        }
    }

    private void finishCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block6: while (true) {
            int c;
            block30: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block30;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block30;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        boolean ok;
                        char d;
                        int count = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((d = this._inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count;
                        }
                        boolean bl = ok = d == '>' && count >= 1;
                        if (ok) {
                            --count;
                        }
                        while (count > 0) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        if (ok) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c < 57344) {
                int d = this.checkSurrogate((char)c);
                outputBuffer[outPtr++] = c;
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                c = d;
            } else if (c >= 65534) {
                c = this.handleInvalidXmlChar(c);
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    private void finishCharacters() throws XMLStreamException {
        int outPtr;
        char[] outputBuffer;
        int c = this.mTmpChar;
        if (c < 0) {
            c = -c;
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
            if (c >> 16 != 0) {
                outputBuffer[outPtr++] = (char)(0xD800 | (c -= 65536) >> 10);
                c = 0xDC00 | c & 0x3FF;
            }
            outputBuffer[outPtr++] = (char)c;
        } else if (c == 13 || c == 10) {
            ++this._inputPtr;
            outPtr = this.checkInTreeIndentation((char)c);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
        }
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        block8: while (true) {
            int d;
            int c2;
            int ptr;
            block40: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c2] != 0) {
                            this._inputPtr = ptr;
                            break block40;
                        }
                    } else if (c2 >= 55296) {
                        this._inputPtr = ptr;
                        break block40;
                    }
                    outputBuffer[outPtr++] = c2;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= 255) {
                switch (TYPES[c2]) {
                    case 1: {
                        this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        d = this.handleEntityInText();
                        if (d == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (d >> 16 != 0) {
                            outputBuffer[outPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            d = 0xDC00 | d & 0x3FF;
                        }
                        c2 = (char)d;
                        break;
                    }
                    case 11: {
                        int count = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c2 = inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++count;
                        }
                        if (c2 == 62 && count > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (count > 1) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        c2 = 93;
                    }
                }
            } else if (c2 < 57344) {
                d = this.checkSurrogate((char)c2);
                outputBuffer[outPtr++] = c2;
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                c2 = d;
            } else if (c2 >= 65534) {
                c2 = this.handleInvalidXmlChar(c2);
            }
            outputBuffer[outPtr++] = c2;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    private void finishSpace() throws XMLStreamException {
        char[] outputBuffer;
        int outPtr;
        char tmp = (char)this.mTmpChar;
        if (tmp == '\r' || tmp == '\n') {
            outPtr = this.checkPrologIndentation(tmp);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = tmp;
            outPtr = 1;
        }
        int ptr = this._inputPtr;
        while (true) {
            int c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr]) > 32) break;
            ++ptr;
            if (c == 10) {
                this.markLF(ptr);
            } else if (c == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = 10;
                        break;
                    }
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == '\n') {
                    ++ptr;
                }
                this.markLF(ptr);
                c = 10;
            } else if (c != 32 && c != 9) {
                this._inputPtr = ptr;
                this.throwInvalidSpace(c);
            }
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c;
        }
        this._inputPtr = ptr;
        this._textBuilder.setCurrentLength(outPtr);
    }

    private void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain()) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    char c;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                    this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    private void finishCoalescedCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.getBufferWithoutReset();
        int outPtr = this._textBuilder.getCurrentLength();
        block6: while (true) {
            int c;
            block29: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block29;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block29;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        boolean ok;
                        char d;
                        int count = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((d = this._inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count;
                        }
                        boolean bl = ok = d == '>' && count >= 1;
                        if (ok) {
                            --count;
                        }
                        while (count > 0) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        if (ok) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c < 57344) {
                int d = this.checkSurrogate((char)c);
                outputBuffer[outPtr++] = c;
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                c = d;
            } else if (c >= 65534) {
                c = this.handleInvalidXmlChar(c);
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    private void finishCoalescedCharacters() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.getBufferWithoutReset();
        int outPtr = this._textBuilder.getCurrentLength();
        block8: while (true) {
            int d;
            int c;
            int ptr;
            block33: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c] != 0) {
                            this._inputPtr = ptr;
                            break block33;
                        }
                    } else if (c >= 55296) {
                        this._inputPtr = ptr;
                        break block33;
                    }
                    outputBuffer[outPtr++] = c;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= 255) {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        d = this.handleEntityInText();
                        if (d == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (d >> 16 != 0) {
                            outputBuffer[outPtr++] = (char)(0xD800 | (d -= 65536) >> 10);
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            d = 0xDC00 | d & 0x3FF;
                        }
                        c = (char)d;
                        break;
                    }
                    case 11: {
                        int count = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c = inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++count;
                        }
                        if (c == 62 && count > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (count > 1) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count;
                        }
                        c = 93;
                    }
                }
            } else if (c < 57344) {
                d = this.checkSurrogate((char)c);
                outputBuffer[outPtr++] = c;
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                c = d;
            } else if (c >= 65534) {
                c = this.handleInvalidXmlChar(c);
            }
            outputBuffer[outPtr++] = c;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    private boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain()) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return false;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    char c;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                    this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    private void skipComment() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c;
            block16: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block16;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c > '\u00ff') continue;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != '-') break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != '>') {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    private void skipPI() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c;
            block15: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block15;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] != '>') break;
                        ++this._inputPtr;
                        return;
                    }
                }
                continue;
            }
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            this.handleInvalidXmlChar(c);
        }
    }

    private boolean skipCharacters() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        block8: while (true) {
            char c;
            block19: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block19;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        return false;
                    }
                    case 10: {
                        int d = this.handleEntityInText();
                        if (d != 0) continue block8;
                        return true;
                    }
                    case 11: {
                        int count = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c = inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count;
                        }
                        if (c != '>' || count <= true) break;
                        this.reportIllegalCDataEnd();
                    }
                }
                continue;
            }
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            this.handleInvalidXmlChar(c);
        }
    }

    private void skipCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c <= '\u00ff') {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++ptr;
                            ++this._inputPtr;
                        }
                        this.markLF(ptr);
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        int count = 0;
                        do {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            ++count;
                        } while ((c = this._inputBuffer[this._inputPtr++]) == ']');
                        if (c == '>') {
                            if (count <= 1) break;
                            return;
                        }
                        --this._inputPtr;
                    }
                }
                continue;
            }
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            this.handleInvalidXmlChar(c);
        }
    }

    private void skipSpace() throws XMLStreamException {
        int ptr = this._inputPtr;
        while (true) {
            char c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr]) > ' ') break;
            ++ptr;
            if (c == '\n') {
                this.markLF(ptr);
                continue;
            }
            if (c == '\r') {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == '\n') {
                    ++ptr;
                }
                this.markLF(ptr);
                continue;
            }
            if (c == ' ' || c == '\t') continue;
            this._inputPtr = ptr;
            this.throwInvalidSpace(c);
        }
        this._inputPtr = ptr;
    }

    private char skipInternalWs(boolean reqd, String msg) throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (!reqd) {
                return c;
            }
            this.reportTreeUnexpChar(c, " (expected white space " + msg + ")");
        }
        do {
            if (c == '\n') {
                this.markLF();
            } else if (c == '\r') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (c != ' ' && c != '\t') {
                this.throwInvalidSpace(c);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while ((c = this._inputBuffer[this._inputPtr++]) <= ' ');
        return c;
    }

    private void matchAsciiKeyword(String keyw) throws XMLStreamException {
        int len = keyw.length();
        for (int i = 1; i < len; ++i) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == keyw.charAt(i)) continue;
            this.reportTreeUnexpChar(c, " (expected '" + keyw.charAt(i) + "' for " + keyw + " keyword)");
        }
    }

    private int checkInTreeIndentation(char c) throws XMLStreamException {
        int count;
        int max;
        if (c == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr]) != ' ' && c != '\t') {
            if (c == '<' && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != '!') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n = max = c == ' ' ? 32 : 8;
        for (count = 1; count <= max; ++count) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr]) != c) {
                if (c2 != '<' || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == '!') break;
                this._textBuilder.resetWithIndentation(count, c);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        outputBuffer[0] = 10;
        for (int i = 1; i <= count; ++i) {
            outputBuffer[i] = c;
        }
        this._textBuilder.setCurrentLength(++count);
        return count;
    }

    private int checkPrologIndentation(char c) throws XMLStreamException {
        int max;
        if (c == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        c = this._inputBuffer[this._inputPtr];
        if (c != ' ' && c != '\t') {
            if (c == '<') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int count = 1;
        int n = max = c == ' ' ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == c) {
            ++this._inputPtr;
            if (++count < max) continue;
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            for (int i = 1; i <= count; ++i) {
                outputBuffer[i] = c;
            }
            this._textBuilder.setCurrentLength(++count);
            return count;
        }
        this._textBuilder.resetWithIndentation(count, c);
        return -1;
    }

    private PNameC parsePName(char c) throws XMLStreamException {
        char[] nameBuffer = this._nameBuffer;
        if (c < 65) {
            this.throwUnexpectedChar(c, "; expected a name start character");
        }
        nameBuffer[0] = c;
        int hash = c;
        int ptr = 1;
        while (true) {
            int d;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((d = (c = this._inputBuffer[this._inputPtr])) < 65 && (d < 45 || d > 58 || d == 47)) {
                PNameC n = this._symbols.findSymbol(nameBuffer, 0, ptr, hash);
                if (n == null) {
                    n = this.addPName(nameBuffer, ptr, hash);
                }
                return n;
            }
            ++this._inputPtr;
            if (ptr >= nameBuffer.length) {
                this._nameBuffer = nameBuffer = DataUtil.growArrayBy(nameBuffer, nameBuffer.length);
            }
            nameBuffer[ptr++] = c;
            hash = hash * 31 + d;
        }
    }

    private PNameC addPName(char[] nameBuffer, int nameLen, int hash) throws XMLStreamException {
        char c = nameBuffer[0];
        int namePtr = 1;
        int last_colon = -1;
        if (c < '\ud800' || c >= '\ue000') {
            if (!XmlChars.is10NameStartChar(c)) {
                this.reportInvalidNameChar(c, 0);
            }
        } else {
            if (nameLen == 1) {
                this.reportInvalidFirstSurrogate(c);
            }
            this.checkSurrogateNameChar(c, nameBuffer[1], 0);
            ++namePtr;
        }
        while (namePtr < nameLen) {
            c = nameBuffer[namePtr];
            if (c < '\ud800' || c >= '\ue000') {
                if (c == ':') {
                    if (last_colon >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    last_colon = namePtr;
                } else if (!XmlChars.is10NameChar(c)) {
                    this.reportInvalidNameChar(c, namePtr);
                }
            } else {
                if (namePtr + 1 >= nameLen) {
                    this.reportInvalidFirstSurrogate(c);
                }
                this.checkSurrogateNameChar(c, nameBuffer[namePtr + 1], namePtr);
            }
            ++namePtr;
        }
        return this._symbols.addSymbol(nameBuffer, 0, nameLen, hash);
    }

    private void parsePublicId(char quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = XmlCharTypes.PUBID_CHARS;
        boolean addSpace = false;
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            if (c > '\u00ff' || TYPES[c] != 1) {
                this.throwUnexpectedChar(c, " in public identifier");
            }
            if (c <= ' ') {
                addSpace = true;
                continue;
            }
            if (addSpace) {
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = 32;
                addSpace = false;
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseSystemId(char quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = ReaderScanner.sCharTypes.ATTR_CHARS;
        while (true) {
            int c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (TYPES[c = this._inputBuffer[this._inputPtr++]] != 0) {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 14: {
                        if (c != quoteChar) break;
                        return new String(outputBuffer, 0, outPtr);
                    }
                }
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c;
        }
    }

    private char checkSurrogate(char firstChar) throws XMLStreamException {
        char sec;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((sec = this._inputBuffer[this._inputPtr++]) < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        return sec;
    }

    private void checkSurrogateNameChar(char firstChar, char sec, int index) throws XMLStreamException {
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (sec < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        int val = (firstChar - 55296 << 10) + 65536;
        this.reportInvalidNameChar(val, index);
    }

    private int decodeSurrogate(char firstChar) throws XMLStreamException {
        char sec;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((sec = this._inputBuffer[this._inputPtr++]) < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        return (firstChar - 55296 << 10) + 65536;
    }

    private void reportInvalidFirstSurrogate(char ch) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code 0x" + Integer.toHexString(ch) + "): can not start a surrogate pair");
    }

    private void reportInvalidSecondSurrogate(char ch) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code " + Integer.toHexString(ch) + "): is not legal as the second part of a surrogate pair");
    }

    private PNameC bindName(PNameC name, String prefix) {
        PNameC cn;
        if (this._nsBindingCache != null && (cn = this._nsBindingCache[name.unboundHashCode() & 0x3F]) != null && cn.unboundEquals(name)) {
            return cn;
        }
        int len = this._nsBindingCount;
        for (int i = 0; i < len; ++i) {
            NsBinding b = this._nsBindings[i];
            if (!Objects.equals(b.mPrefix, prefix)) continue;
            if (i > 0) {
                this._nsBindings[i] = this._nsBindings[i - 1];
                this._nsBindings[i - 1] = b;
            }
            PNameC bn = name.createBoundName(b);
            if (this._nsBindingCache == null) {
                if (++this._nsBindMisses < 10) {
                    return bn;
                }
                this._nsBindingCache = new PNameC[64];
            }
            this._nsBindingCache[bn.unboundHashCode() & 0x3F] = bn;
            return bn;
        }
        if (Objects.equals(prefix, "xml")) {
            return name.createBoundName(NsBinding.XML_BINDING);
        }
        ++this._nsBindMisses;
        return name.createBoundName(this.createNewBinding(prefix));
    }

    private NsBinding findOrCreateBinding(String prefix) {
        int len = this._nsBindingCount;
        for (int i = 0; i < len; ++i) {
            NsBinding b = this._nsBindings[i];
            if (!Objects.equals(b.mPrefix, prefix)) continue;
            if (i > 0) {
                this._nsBindings[i] = this._nsBindings[i - 1];
                this._nsBindings[i - 1] = b;
            }
            return b;
        }
        if (Objects.equals(prefix, "xml")) {
            return NsBinding.XML_BINDING;
        }
        if (Objects.equals(prefix, "xmlns")) {
            return NsBinding.XMLNS_BINDING;
        }
        return this.createNewBinding(prefix);
    }

    private NsBinding createNewBinding(String prefix) {
        NsBinding b = new NsBinding(prefix);
        if (this._nsBindingCount == 0) {
            this._nsBindings = new NsBinding[16];
        } else if (this._nsBindingCount >= this._nsBindings.length) {
            this._nsBindings = (NsBinding[])DataUtil.growAnyArrayBy(this._nsBindings, this._nsBindings.length);
        }
        this._nsBindings[this._nsBindingCount] = b;
        ++this._nsBindingCount;
        return b;
    }

    private void bindNs(PNameC name, String uri) throws XMLStreamException {
        NsBinding ns;
        String prefix = name.getPrefix();
        if (prefix == null) {
            ns = this._defaultNs;
        } else {
            prefix = name.getLocalName();
            ns = this.findOrCreateBinding(prefix);
            if (ns.isImmutable()) {
                this.checkImmutableBinding(prefix, uri);
            }
        }
        if (!ns.isImmutable()) {
            if (Objects.equals(uri, "http://www.w3.org/XML/1998/namespace")) {
                this.reportIllegalNsDecl("xml", "http://www.w3.org/XML/1998/namespace");
            } else if (Objects.equals(uri, "http://www.w3.org/2000/xmlns/")) {
                this.reportIllegalNsDecl("xmlns", "http://www.w3.org/2000/xmlns/");
            }
        }
        if (this._lastNsDecl != null && this._lastNsDecl.alreadyDeclared(prefix, this._depth)) {
            this.reportDuplicateNsDecl(prefix);
        }
        this._lastNsDecl = new NsDeclaration(ns, uri, this._lastNsDecl, this._depth);
    }

    private void checkImmutableBinding(String prefix, String uri) throws XMLStreamException {
        if (!Objects.equals(prefix, "xml") || !uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.reportIllegalNsDecl(prefix);
        }
    }

    private void loadMoreGuaranteed() throws XMLStreamException {
        this.loadMoreGuaranteed(this._currToken);
    }

    private void loadMoreGuaranteed(int tt) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(tt));
        }
    }

    private void reportInputProblem(String msg) throws XMLStreamException {
        throw new StreamExceptionBase(msg, this.getCurrentLocation());
    }

    private void reportUnexpandedEntityInAttr(boolean isNsDecl) throws XMLStreamException {
        this.reportInputProblem("Unexpanded ENTITY_REFERENCE (" + this._tokenName + ") in " + (isNsDecl ? "namespace declaration" : "attribute value"));
    }

    private void reportPrologUnexpElement(boolean isProlog, int ch) throws XMLStreamException {
        if (ch < 0) {
            ch &= 0x7FFFF;
        }
        if (ch == 47) {
            if (isProlog) {
                this.reportInputProblem("Unexpected end element in prolog: malformed XML document, expected root element");
            }
            this.reportInputProblem("Unexpected end element in epilog: malformed XML document (unbalanced start/end tags?)");
        }
        if (ch < 32) {
            String type = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
            this.throwUnexpectedChar(ch, "Unrecognized directive " + type);
        }
        this.reportInputProblem("Second root element in content: malformed XML document, only one allowed");
    }

    private void reportPrologUnexpChar(boolean isProlog, int ch, String msg) throws XMLStreamException {
        String fullMsg;
        String string = fullMsg = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
        if (msg == null) {
            if (ch == 38) {
                this.throwUnexpectedChar(ch, fullMsg + "; no entities allowed");
            }
        } else {
            fullMsg = fullMsg + msg;
        }
        this.throwUnexpectedChar(ch, fullMsg);
    }

    private void reportTreeUnexpChar(int ch, String msg) throws XMLStreamException {
        String fullMsg = ErrorConsts.SUFFIX_IN_TREE;
        if (msg != null) {
            fullMsg = fullMsg + msg;
        }
        this.throwUnexpectedChar(ch, fullMsg);
    }

    private void reportInvalidNameChar(int ch, int index) throws XMLStreamException {
        if (ch == 58) {
            this.reportInputProblem("Invalid colon in name: at most one colon allowed in element/attribute names, and none in PI target or entity names");
        }
        if (index == 0) {
            this.reportInputProblem("Invalid name start character (0x" + Integer.toHexString(ch) + ")");
        }
        this.reportInputProblem("Invalid name character (0x" + Integer.toHexString(ch) + ")");
    }

    private void reportInvalidXmlChar(int ch) throws XMLStreamException {
        if (ch == 0) {
            this.reportInputProblem("Invalid null character");
        }
        if (ch < 32) {
            this.reportInputProblem("Invalid white space character (0x" + Integer.toHexString(ch) + ")");
        }
        this.reportInputProblem("Invalid xml content character (0x" + Integer.toHexString(ch) + ")");
    }

    private void reportMissingPISpace(int ch) throws XMLStreamException {
        this.throwUnexpectedChar(ch, ": expected either white space, or closing '?>'");
    }

    private void reportDoubleHyphenInComments() throws XMLStreamException {
        this.reportInputProblem("String '--' not allowed in comment (missing '>'?)");
    }

    private void reportMultipleColonsInName() throws XMLStreamException {
        this.reportInputProblem("Multiple colons not allowed in names");
    }

    private void reportEntityOverflow() throws XMLStreamException {
        this.reportInputProblem("Illegal character entity: value higher than max allowed (0x" + Integer.toHexString(0x10FFFF) + ")");
    }

    private void reportInvalidNsIndex(int index) {
        throw new IndexOutOfBoundsException("Illegal namespace declaration index, " + index + ", current START_ELEMENT/END_ELEMENT has " + this.getNsCount() + " declarations");
    }

    private void reportUnboundPrefix(PNameC name, boolean isAttr) throws XMLStreamException {
        this.reportInputProblem("Unbound namespace prefix '" + name.getPrefix() + "' (for " + (isAttr ? "attribute" : "element") + " name '" + name.getPrefixedName() + "')");
    }

    private void reportDuplicateNsDecl(String prefix) throws XMLStreamException {
        if (prefix == null) {
            this.reportInputProblem("Duplicate namespace declaration for the default namespace");
        } else {
            this.reportInputProblem("Duplicate namespace declaration for prefix '" + prefix + "'");
        }
    }

    private void reportIllegalNsDecl(String prefix) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not re-bind prefix '" + prefix + "'");
    }

    private void reportIllegalNsDecl(String prefix, String uri) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not bind URI '" + uri + "' to prefix other than '" + prefix + "'");
    }

    private void reportUnexpectedEndTag(String expName) throws XMLStreamException {
        this.reportInputProblem("Unexpected end tag: expected </" + expName + ">");
    }

    private void reportIllegalCDataEnd() throws XMLStreamException {
        this.reportInputProblem("String ']]>' not allowed in textual content, except as the end marker of CDATA section");
    }

    private void throwUnexpectedChar(int i, String msg) throws XMLStreamException {
        if (i < 32 && i != 13 && i != 10 && i != 9) {
            this.throwInvalidSpace(i);
        }
        char c = (char)i;
        String excMsg = "Unexpected character " + XmlChars.getCharDesc(c) + msg;
        this.reportInputProblem(excMsg);
    }

    private void throwNullChar() throws XMLStreamException {
        this.reportInputProblem("Illegal character (NULL, unicode 0) encountered: not valid in any content");
    }

    private char handleInvalidXmlChar(int i) throws XMLStreamException {
        char c = (char)i;
        if (c == '\u0000') {
            this.throwNullChar();
        }
        this.reportInputProblem("Illegal XML character (" + XmlChars.getCharDesc(c) + ")");
        return (char)i;
    }

    private void throwInvalidSpace(int i) throws XMLStreamException {
        char c = (char)i;
        if (c == '\u0000') {
            this.throwNullChar();
        }
        this.reportInputProblem("Illegal character (" + XmlChars.getCharDesc(c) + ")");
    }

    private boolean loadMore() throws XMLStreamException {
        this._pastBytesOrChars += (long)this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        try {
            int count = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count < 1) {
                this._inputEnd = 0;
                if (count == 0) {
                    this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = count;
            return true;
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    private char loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(5));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    private boolean loadAndRetain() throws XMLStreamException {
        this._pastBytesOrChars += (long)this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int remaining = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, remaining);
        this._inputPtr = 0;
        this._inputEnd = remaining;
        try {
            do {
                int max;
                int count;
                if ((count = this._in.read(this._inputBuffer, this._inputEnd, max = this._inputBuffer.length - this._inputEnd)) < 1) {
                    if (count == 0) {
                        this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + max);
                    }
                    return false;
                }
                this._inputEnd += count;
            } while (this._inputEnd < 3);
            return true;
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }
}

