/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.geo;

import io.clientcore.core.models.geo.GeoArray;
import io.clientcore.core.models.geo.GeoBoundingBox;
import io.clientcore.core.models.geo.GeoLinearRing;
import io.clientcore.core.models.geo.GeoObject;
import io.clientcore.core.models.geo.GeoObjectType;
import io.clientcore.core.models.geo.GeoPolygon;
import io.clientcore.core.models.geo.GeoPosition;
import io.clientcore.core.serialization.json.JsonReader;
import io.clientcore.core.serialization.json.JsonToken;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoPolygonCollection
extends GeoObject {
    private final List<GeoPolygon> polygons;

    public GeoPolygonCollection(List<GeoPolygon> polygons) {
        this(polygons, null, null);
    }

    public GeoPolygonCollection(List<GeoPolygon> polygons, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(polygons, "'polygons' cannot be null.");
        this.polygons = Collections.unmodifiableList(new ArrayList<GeoPolygon>(polygons));
    }

    public List<GeoPolygon> getPolygons() {
        return this.polygons;
    }

    GeoArray<GeoArray<GeoArray<GeoPosition>>> getCoordinates() {
        return new GeoArray<GeoArray<GeoArray<GeoPosition>>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_POLYGON;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.polygons, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPolygonCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPolygonCollection other = (GeoPolygonCollection)obj;
        return super.equals(obj) && Objects.equals(this.polygons, other.polygons);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.MULTI_POLYGON.toString()).writeArrayField("coordinates", this.polygons, (writer, geoPolygon) -> writer.writeArray(geoPolygon.getRings(), JsonWriter::writeJson)).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoPolygonCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ArrayList<GeoPolygon> polygons = null;
            GeoBoundingBox boundingBox = null;
            LinkedHashMap<String, Object> customProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    String type = reader.getString();
                    if (GeoObjectType.MULTI_POLYGON.toString().equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'MultiPolygon'. The found 'type' was '" + type + "'.");
                }
                if ("coordinates".equals(fieldName)) {
                    List<List> polygonRings = reader.readArray(polygon -> polygon.readArray(GeoLinearRing::fromJson));
                    polygons = new ArrayList<GeoPolygon>(polygonRings.size());
                    for (List rings : polygonRings) {
                        polygons.add(new GeoPolygon(rings));
                    }
                    continue;
                }
                if ("bbox".equals(fieldName)) {
                    boundingBox = GeoBoundingBox.fromJson(reader);
                    continue;
                }
                if (customProperties == null) {
                    customProperties = new LinkedHashMap<String, Object>();
                }
                customProperties.put(fieldName, reader.readUntyped());
            }
            return new GeoPolygonCollection(polygons, boundingBox, customProperties);
        });
    }
}

