/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.geo;

import io.clientcore.core.models.geo.GeoBoundingBox;
import io.clientcore.core.models.geo.GeoCollection;
import io.clientcore.core.models.geo.GeoLineString;
import io.clientcore.core.models.geo.GeoLineStringCollection;
import io.clientcore.core.models.geo.GeoObjectType;
import io.clientcore.core.models.geo.GeoPoint;
import io.clientcore.core.models.geo.GeoPointCollection;
import io.clientcore.core.models.geo.GeoPolygon;
import io.clientcore.core.models.geo.GeoPolygonCollection;
import io.clientcore.core.serialization.json.JsonReader;
import io.clientcore.core.serialization.json.JsonSerializable;
import io.clientcore.core.serialization.json.JsonToken;
import io.clientcore.core.serialization.json.JsonWriter;
import io.clientcore.core.utils.CoreUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class GeoObject
implements JsonSerializable<GeoObject> {
    private final GeoBoundingBox boundingBox;
    private final Map<String, Object> customProperties;

    protected GeoObject(GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        this.boundingBox = boundingBox;
        this.customProperties = customProperties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(customProperties));
    }

    public abstract GeoObjectType getType();

    public final GeoBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public final Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public int hashCode() {
        return Objects.hash(this.boundingBox, this.customProperties);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoObject other = (GeoObject)obj;
        return Objects.equals(this.boundingBox, other.boundingBox) && Objects.equals(this.customProperties, other.customProperties);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeJsonField("bbox", this.getBoundingBox());
        Map<String, Object> customProperties = this.getCustomProperties();
        if (!CoreUtils.isNullOrEmpty(customProperties)) {
            jsonWriter.writeMap(customProperties, JsonWriter::writeUntyped);
        }
        return jsonWriter.writeEndObject();
    }

    public static GeoObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("type".equals(fieldName)) {
                    discriminatorValue = readerToUse.getString();
                    break;
                }
                readerToUse.skipChildren();
            }
            if (discriminatorValue != null) {
                readerToUse = readerToUse.reset();
            }
            if ("Point".equals(discriminatorValue)) {
                return GeoPoint.fromJson(readerToUse);
            }
            if ("MultiPoint".equals(discriminatorValue)) {
                return GeoPointCollection.fromJson(readerToUse);
            }
            if ("Polygon".equals(discriminatorValue)) {
                return GeoPolygon.fromJson(readerToUse);
            }
            if ("MultiPolygon".equals(discriminatorValue)) {
                return GeoPolygonCollection.fromJson(readerToUse);
            }
            if ("LineString".equals(discriminatorValue)) {
                return GeoLineString.fromJson(readerToUse);
            }
            if ("MultiLineString".equals(discriminatorValue)) {
                return GeoLineStringCollection.fromJson(readerToUse);
            }
            if ("GeometryCollection".equals(discriminatorValue)) {
                return GeoCollection.fromJson(readerToUse);
            }
            throw new IllegalStateException("Discriminator field 'type' didn't match one of the expected values 'Point', 'MultiPoint', 'Polygon', 'MultiPolygon', 'LineString', 'MultiLineString', or 'GeometryCollection'. It was: '" + discriminatorValue + "'.");
        });
    }

    JsonWriter writeCustomProperties(JsonWriter jsonWriter) throws IOException {
        if (!CoreUtils.isNullOrEmpty(this.customProperties)) {
            for (Map.Entry<String, Object> entry : this.customProperties.entrySet()) {
                jsonWriter.writeUntypedField(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        return jsonWriter;
    }
}

