/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.CoreUtils;
import io.clientcore.core.utils.configuration.Configuration;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ImplUtils {
    private static final ClientLogger LOGGER = new ClientLogger(ImplUtils.class);
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final byte ZERO = 0;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte EF = -17;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(\\S+)\\b", 2);
    private static final Duration DEFAULT_HTTP_CONNECT_TIMEOUT;
    private static final Duration DEFAULT_HTTP_WRITE_TIMEOUT;
    private static final Duration DEFAULT_HTTP_RESPONSE_TIMEOUT;
    private static final Duration DEFAULT_HTTP_READ_TIMEOUT;

    private ImplUtils() {
    }

    public static Duration getDefaultTimeoutFromEnvironment(Configuration configuration, String timeoutPropertyName, Duration defaultTimeout, ClientLogger logger) {
        String environmentTimeout = configuration.get(timeoutPropertyName);
        if (environmentTimeout == null || environmentTimeout.isEmpty()) {
            return defaultTimeout;
        }
        try {
            long timeoutMillis = Long.parseLong(environmentTimeout);
            if (timeoutMillis < 0L) {
                logger.atVerbose().addKeyValue(timeoutPropertyName, timeoutMillis).log("Negative timeout values are not allowed. Using 'Duration.ZERO' to indicate no timeout.");
                return Duration.ZERO;
            }
            return Duration.ofMillis(timeoutMillis);
        }
        catch (NumberFormatException ex) {
            logger.atInfo().addKeyValue(timeoutPropertyName, environmentTimeout).addKeyValue("defaultTimeout", defaultTimeout).log("Timeout is not valid number. Using default value.", ex);
            return defaultTimeout;
        }
    }

    public static void writeByteBufferToStream(ByteBuffer buffer, OutputStream stream) throws IOException {
        if (buffer.hasArray()) {
            stream.write(buffer.array(), buffer.position(), buffer.remaining());
            buffer.position(buffer.position() + buffer.remaining());
            return;
        }
        if (stream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)stream;
            fileOutputStream.getChannel().write(buffer);
            return;
        }
        stream.write(ImplUtils.byteBufferToArray(buffer));
    }

    public static byte[] byteBufferToArray(ByteBuffer byteBuffer) {
        int length = byteBuffer.remaining();
        byte[] byteArray = new byte[length];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    public static String bomAwareToString(byte[] bytes, int offset, int count, String contentType) {
        if (bytes == null) {
            return null;
        }
        if (count >= 3 && bytes[offset] == -17 && bytes[offset + 1] == -69 && bytes[offset + 2] == -65) {
            return new String(bytes, 3, bytes.length - 3, StandardCharsets.UTF_8);
        }
        if (count >= 4 && bytes[offset] == 0 && bytes[offset + 1] == 0 && bytes[offset + 2] == -2 && bytes[offset + 3] == -1) {
            return new String(bytes, 4, bytes.length - 4, UTF_32BE);
        }
        if (count >= 4 && bytes[offset] == -1 && bytes[offset + 1] == -2 && bytes[offset + 2] == 0 && bytes[offset + 3] == 0) {
            return new String(bytes, 4, bytes.length - 4, UTF_32LE);
        }
        if (count >= 2 && bytes[offset] == -2 && bytes[offset + 1] == -1) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16BE);
        }
        if (count >= 2 && bytes[offset] == -1 && bytes[offset + 1] == -2) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16LE);
        }
        if (!CoreUtils.isNullOrEmpty(contentType)) {
            try {
                Matcher charsetMatcher = CHARSET_PATTERN.matcher(contentType);
                if (charsetMatcher.find()) {
                    return new String(bytes, offset, count, Charset.forName(charsetMatcher.group(1)));
                }
                return new String(bytes, offset, count, StandardCharsets.UTF_8);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                return new String(bytes, offset, count, StandardCharsets.UTF_8);
            }
        }
        return new String(bytes, offset, count, StandardCharsets.UTF_8);
    }

    public static Thread createExecutorServiceShutdownThread(ExecutorService executorService, Duration shutdownTimeout) {
        long timeoutNanos = shutdownTimeout.toNanos();
        return new Thread(() -> {
            try {
                executorService.shutdown();
                if (!executorService.awaitTermination(timeoutNanos / 2L, TimeUnit.NANOSECONDS)) {
                    executorService.shutdownNow();
                    executorService.awaitTermination(timeoutNanos / 2L, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                executorService.shutdown();
            }
        });
    }

    public static Thread addShutdownHookSafely(Thread shutdownThread) {
        if (shutdownThread == null) {
            return null;
        }
        if (ShutdownHookAccessHelperHolder.shutdownHookAccessHelper) {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().addShutdownHook(shutdownThread);
                return null;
            });
        } else {
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }
        return shutdownThread;
    }

    public static void removeShutdownHookSafely(Thread shutdownThread) {
        if (shutdownThread == null) {
            return;
        }
        if (ShutdownHookAccessHelperHolder.shutdownHookAccessHelper) {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().removeShutdownHook(shutdownThread);
                return null;
            });
        } else {
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
        }
    }

    static boolean isShutdownHookAccessHelper() {
        return ShutdownHookAccessHelperHolder.shutdownHookAccessHelper;
    }

    static void setShutdownHookAccessHelper(boolean shutdownHookAccessHelper) {
        ShutdownHookAccessHelperHolder.shutdownHookAccessHelper = shutdownHookAccessHelper;
    }

    public static Duration getDefaultHttpConnectTimeout() {
        return DEFAULT_HTTP_CONNECT_TIMEOUT;
    }

    public static Duration getDefaultHttpWriteTimeout() {
        return DEFAULT_HTTP_WRITE_TIMEOUT;
    }

    public static Duration getDefaultHttpResponseTimeout() {
        return DEFAULT_HTTP_RESPONSE_TIMEOUT;
    }

    public static Duration getDefaultHttpReadTimeout() {
        return DEFAULT_HTTP_READ_TIMEOUT;
    }

    static {
        Configuration configuration = Configuration.getGlobalConfiguration();
        DEFAULT_HTTP_CONNECT_TIMEOUT = ImplUtils.getDefaultTimeoutFromEnvironment(configuration, "REQUEST_CONNECT_TIMEOUT_IN_MS", Duration.ofSeconds(10L), LOGGER);
        DEFAULT_HTTP_WRITE_TIMEOUT = ImplUtils.getDefaultTimeoutFromEnvironment(configuration, "REQUEST_WRITE_TIMEOUT_IN_MS", Duration.ofSeconds(60L), LOGGER);
        DEFAULT_HTTP_RESPONSE_TIMEOUT = ImplUtils.getDefaultTimeoutFromEnvironment(configuration, "REQUEST_RESPONSE_TIMEOUT_IN_MS", Duration.ofSeconds(60L), LOGGER);
        DEFAULT_HTTP_READ_TIMEOUT = ImplUtils.getDefaultTimeoutFromEnvironment(configuration, "REQUEST_READ_TIMEOUT_IN_MS", Duration.ofSeconds(60L), LOGGER);
    }

    private static final class ShutdownHookAccessHelperHolder {
        private static boolean shutdownHookAccessHelper = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("CORE_ENABLE_SHUTDOWN_HOOK_WITH_PRIVILEGE"));

        private ShutdownHookAccessHelperHolder() {
        }
    }

    public static final class QueryParameterIterator
    implements Iterator<Map.Entry<String, String>> {
        private final String queryParameters;
        private final int queryParametersLength;
        private boolean done;
        private int position;

        public QueryParameterIterator(String queryParameters) {
            this.queryParameters = queryParameters;
            this.done = CoreUtils.isNullOrEmpty(queryParameters);
            if (this.done) {
                this.position = 0;
                this.queryParametersLength = 0;
            } else {
                this.queryParametersLength = queryParameters.length();
                this.position = queryParameters.startsWith("?") ? 1 : 0;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Map.Entry<String, String> next() {
            char c;
            int nextPosition;
            if (this.done) {
                throw new NoSuchElementException();
            }
            for (nextPosition = this.position; nextPosition < this.queryParametersLength && (c = this.queryParameters.charAt(nextPosition)) != '='; ++nextPosition) {
                if (c != '&') continue;
                String key = this.queryParameters.substring(this.position, nextPosition);
                this.position = nextPosition + 1;
                return new AbstractMap.SimpleImmutableEntry<String, String>(key, "");
            }
            if (nextPosition == this.queryParametersLength) {
                this.done = true;
                return new AbstractMap.SimpleImmutableEntry<String, String>(this.queryParameters.substring(this.position), "");
            }
            String key = this.queryParameters.substring(this.position, nextPosition);
            this.position = nextPosition + 1;
            nextPosition = this.queryParameters.indexOf(38, this.position);
            String value = null;
            if (nextPosition == -1) {
                this.done = true;
                value = this.queryParameters.substring(this.position);
            } else {
                value = this.queryParameters.substring(this.position, nextPosition);
                this.position = nextPosition + 1;
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
        }
    }

    public static final class QueryParameterIterable
    implements Iterable<Map.Entry<String, String>> {
        private final String queryParameters;

        public QueryParameterIterable(String queryParameters) {
            this.queryParameters = queryParameters;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new QueryParameterIterator(this.queryParameters);
        }
    }
}

