/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel.tracing;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelContext;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpan;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.Span;

public class OTelSpanContext
implements InstrumentationContext {
    public static final Object INVALID_OTEL_SPAN_CONTEXT;
    private static final String INVALID_TRACE_ID = "00000000000000000000000000000000";
    private static final String INVALID_SPAN_ID = "0000000000000000";
    private static final String INVALID_TRACE_FLAGS = "00";
    private static final OTelSpanContext INVALID;
    private static final ClientLogger LOGGER;
    private static final FallbackInvoker GET_SPAN_ID_INVOKER;
    private static final FallbackInvoker GET_TRACE_ID_INVOKER;
    private static final FallbackInvoker GET_TRACE_FLAGS_INVOKER;
    private static final FallbackInvoker IS_VALID_INVOKER;
    private static final FallbackInvoker CREATE_INVOKER;
    private final Object otelSpanContext;
    private final Object otelContext;
    private String traceId;
    private String spanId;
    private String traceFlags;
    private Boolean isValid;

    public OTelSpanContext(Object otelSpanContext, Object otelContext) {
        this.otelSpanContext = otelSpanContext;
        this.otelContext = otelContext;
    }

    public static OTelSpanContext fromOTelContext(Object otelContext) {
        if (otelContext == null) {
            return INVALID;
        }
        Object otelSpan = OTelSpan.fromOTelContext(otelContext);
        Object otelSpanContext = OTelSpan.getSpanContext(otelSpan);
        return new OTelSpanContext(otelSpanContext, otelContext);
    }

    public static OTelSpanContext fromOTelSpan(Object otelSpan) {
        Object otelSpanContext = OTelSpan.getSpanContext(otelSpan);
        Object otelContext = OTelSpan.storeInContext(otelSpan, OTelContext.getCurrent());
        return new OTelSpanContext(otelSpanContext, otelContext);
    }

    public static OTelSpanContext getInvalid() {
        return INVALID;
    }

    @Override
    public String getTraceId() {
        if (this.traceId != null) {
            return this.traceId;
        }
        this.traceId = this.isInitialized() ? (String)GET_TRACE_ID_INVOKER.invoke(this.otelSpanContext) : INVALID_TRACE_ID;
        return this.traceId;
    }

    @Override
    public String getSpanId() {
        if (this.spanId != null) {
            return this.spanId;
        }
        this.spanId = this.isInitialized() ? (String)GET_SPAN_ID_INVOKER.invoke(this.otelSpanContext) : INVALID_SPAN_ID;
        return this.spanId;
    }

    @Override
    public String getTraceFlags() {
        if (this.traceFlags != null) {
            return this.traceFlags;
        }
        if (this.isInitialized()) {
            Object traceFlagsObj = GET_TRACE_FLAGS_INVOKER.invoke(this.otelSpanContext);
            if (traceFlagsObj != null) {
                this.traceFlags = traceFlagsObj.toString();
            }
        } else {
            this.traceFlags = INVALID_TRACE_FLAGS;
        }
        return this.traceFlags;
    }

    @Override
    public boolean isValid() {
        if (this.isValid != null) {
            return this.isValid;
        }
        this.isValid = this.isInitialized() && (Boolean)IS_VALID_INVOKER.invoke(this.otelSpanContext) != false;
        return this.isValid;
    }

    @Override
    public Span getSpan() {
        if (this.isInitialized()) {
            OTelSpan coreSpan;
            if (this.otelContext != null && (coreSpan = OTelContext.getClientCoreSpan(this.otelContext)) != null) {
                return coreSpan;
            }
            return OTelSpan.createPropagatingSpan(this);
        }
        return Span.noop();
    }

    public Object getOtelContext() {
        return this.otelContext;
    }

    Object getOtelSpanContext() {
        return this.otelSpanContext;
    }

    public static Object toOTelSpanContext(InstrumentationContext context) {
        if (context instanceof OTelSpanContext) {
            return ((OTelSpanContext)context).otelSpanContext;
        }
        return CREATE_INVOKER.invoke(context.getTraceId(), context.getTraceFlags(), null);
    }

    private boolean isInitialized() {
        return this.otelSpanContext != null && OTelInitializer.isInitialized();
    }

    static {
        LOGGER = new ClientLogger(OTelSpanContext.class);
        ReflectiveInvoker getSpanIdInvoker = null;
        ReflectiveInvoker getTraceIdInvoker = null;
        ReflectiveInvoker getTraceFlagsInvoker = null;
        ReflectiveInvoker isValidInvoker = null;
        ReflectiveInvoker createInvoker = null;
        Object invalidInstance = null;
        if (OTelInitializer.isInitialized()) {
            try {
                getTraceIdInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CONTEXT_CLASS, OTelInitializer.SPAN_CONTEXT_CLASS.getMethod("getTraceId", new Class[0]));
                getSpanIdInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CONTEXT_CLASS, OTelInitializer.SPAN_CONTEXT_CLASS.getMethod("getSpanId", new Class[0]));
                getTraceFlagsInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CONTEXT_CLASS, OTelInitializer.SPAN_CONTEXT_CLASS.getMethod("getTraceFlags", new Class[0]));
                ReflectiveInvoker getInvalidInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CONTEXT_CLASS, OTelInitializer.SPAN_CONTEXT_CLASS.getMethod("getInvalid", new Class[0]));
                invalidInstance = getInvalidInvoker.invoke();
                isValidInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CONTEXT_CLASS, OTelInitializer.SPAN_CONTEXT_CLASS.getMethod("isValid", new Class[0]));
                createInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.SPAN_CONTEXT_CLASS, OTelInitializer.SPAN_CONTEXT_CLASS.getMethod("create", String.class, String.class, OTelInitializer.TRACE_FLAGS_CLASS, OTelInitializer.TRACE_STATE_CLASS));
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        INVALID_OTEL_SPAN_CONTEXT = invalidInstance;
        INVALID = new OTelSpanContext(invalidInstance, null);
        IS_VALID_INVOKER = new FallbackInvoker(isValidInvoker, false, LOGGER);
        GET_SPAN_ID_INVOKER = new FallbackInvoker(getSpanIdInvoker, INVALID_SPAN_ID, LOGGER);
        GET_TRACE_ID_INVOKER = new FallbackInvoker(getTraceIdInvoker, INVALID_TRACE_ID, LOGGER);
        GET_TRACE_FLAGS_INVOKER = new FallbackInvoker(getTraceFlagsInvoker, INVALID_TRACE_FLAGS, LOGGER);
        CREATE_INVOKER = new FallbackInvoker(createInvoker, INVALID_OTEL_SPAN_CONTEXT, LOGGER);
    }
}

