/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.credentials.oauth.AccessToken;
import io.clientcore.core.credentials.oauth.OAuthTokenCredential;
import io.clientcore.core.credentials.oauth.OAuthTokenRequestContext;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpCredentialPolicy;
import io.clientcore.core.http.pipeline.HttpPipelineNextPolicy;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import java.io.IOException;
import java.util.Objects;

public class OAuthBearerTokenAuthenticationPolicy
extends HttpCredentialPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(OAuthBearerTokenAuthenticationPolicy.class);
    private static final String BEARER = "Bearer";
    private final OAuthTokenRequestContext context;
    private final OAuthTokenCredential credential;

    public OAuthBearerTokenAuthenticationPolicy(OAuthTokenCredential credential, OAuthTokenRequestContext context) {
        Objects.requireNonNull(credential);
        Objects.requireNonNull(context);
        this.credential = credential;
        this.context = context;
    }

    public void authorizeRequest(HttpRequest httpRequest, OAuthTokenRequestContext context) {
        AccessToken token = this.credential.getToken(context);
        httpRequest.getHeaders().set(HttpHeaderName.AUTHORIZATION, "Bearer " + token.getToken());
    }

    @Override
    public Response<BinaryData> process(HttpRequest httpRequest, HttpPipelineNextPolicy next) {
        if (!"https".equals(httpRequest.getUri().getScheme())) {
            throw LOGGER.logThrowableAsError(new RuntimeException("Token credentials require a URL using the HTTPS protocol scheme"));
        }
        HttpPipelineNextPolicy nextPolicy = next.copy();
        this.authorizeRequest(httpRequest, this.context);
        Response<BinaryData> httpResponse = next.process();
        String authHeader = httpResponse.getHeaders().getValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (httpResponse.getStatusCode() == 401 && authHeader != null) {
            if (this.authorizeRequestOnChallenge(httpRequest, httpResponse)) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    throw LOGGER.logThrowableAsError(new RuntimeException(e));
                }
                return nextPolicy.process();
            }
            return httpResponse;
        }
        return httpResponse;
    }

    public boolean authorizeRequestOnChallenge(HttpRequest httpRequest, Response<BinaryData> response) {
        return false;
    }
}

