/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpInstrumentationOptions;
import io.clientcore.core.http.pipeline.HttpPipelineNextPolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePosition;
import io.clientcore.core.implementation.UrlRedactionUtil;
import io.clientcore.core.implementation.http.HttpRequestAccessHelper;
import io.clientcore.core.implementation.instrumentation.InstrumentationUtils;
import io.clientcore.core.implementation.instrumentation.SdkInstrumentationOptionsAccessHelper;
import io.clientcore.core.instrumentation.Instrumentation;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.logging.LogLevel;
import io.clientcore.core.instrumentation.logging.LoggingEvent;
import io.clientcore.core.instrumentation.metrics.DoubleHistogram;
import io.clientcore.core.instrumentation.metrics.Meter;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.SpanBuilder;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import io.clientcore.core.instrumentation.tracing.TraceContextPropagator;
import io.clientcore.core.instrumentation.tracing.TraceContextSetter;
import io.clientcore.core.instrumentation.tracing.Tracer;
import io.clientcore.core.instrumentation.tracing.TracingScope;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.CoreUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class HttpInstrumentationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(HttpInstrumentationPolicy.class);
    private static final HttpInstrumentationOptions DEFAULT_OPTIONS = new HttpInstrumentationOptions();
    private static final String SDK_NAME;
    private static final String SDK_VERSION;
    private static final SdkInstrumentationOptions SDK_OPTIONS;
    private static final TraceContextSetter<HttpHeaders> SETTER;
    private static final int MAX_BODY_LOG_SIZE = 16384;
    private static final String REDACTED_PLACEHOLDER = "REDACTED";
    private static final String REQUEST_DURATION_METRIC_NAME = "http.client.request.duration";
    private static final String REQUEST_DURATION_METRIC_DESCRIPTION = "Duration of HTTP client requests";
    private static final String REQUEST_DURATION_METRIC_UNIT = "s";
    private static final List<Double> REQUEST_DURATION_BOUNDARIES_ADVICE;
    private static final LogLevel HTTP_REQUEST_LOG_LEVEL;
    private static final LogLevel HTTP_RESPONSE_LOG_LEVEL;
    private final Tracer tracer;
    private final Meter meter;
    private final boolean isTracingEnabled;
    private final boolean isMetricsEnabled;
    private final Instrumentation instrumentation;
    private final DoubleHistogram httpRequestDuration;
    private final TraceContextPropagator traceContextPropagator;
    private final Set<String> allowedQueryParameterNames;
    private final Set<HttpHeaderName> allowedHeaderNames;
    private final boolean isLoggingEnabled;
    private final boolean isContentLoggingEnabled;
    private final boolean isRedactedHeadersLoggingEnabled;

    public HttpInstrumentationPolicy(HttpInstrumentationOptions instrumentationOptions) {
        this.instrumentation = Instrumentation.create(instrumentationOptions, SDK_OPTIONS);
        this.tracer = this.instrumentation.getTracer();
        this.meter = this.instrumentation.getMeter();
        this.httpRequestDuration = this.meter.createDoubleHistogram(REQUEST_DURATION_METRIC_NAME, REQUEST_DURATION_METRIC_DESCRIPTION, REQUEST_DURATION_METRIC_UNIT, REQUEST_DURATION_BOUNDARIES_ADVICE);
        this.traceContextPropagator = this.instrumentation.getW3CTraceContextPropagator();
        HttpInstrumentationOptions optionsToUse = instrumentationOptions == null ? DEFAULT_OPTIONS : instrumentationOptions;
        this.isLoggingEnabled = optionsToUse.getHttpLogLevel() != HttpInstrumentationOptions.HttpLogLevel.NONE;
        this.isContentLoggingEnabled = optionsToUse.getHttpLogLevel() == HttpInstrumentationOptions.HttpLogLevel.BODY || optionsToUse.getHttpLogLevel() == HttpInstrumentationOptions.HttpLogLevel.BODY_AND_HEADERS;
        this.isRedactedHeadersLoggingEnabled = optionsToUse.isRedactedHeaderNamesLoggingEnabled();
        this.allowedHeaderNames = optionsToUse.getAllowedHeaderNames();
        this.allowedQueryParameterNames = optionsToUse.getAllowedQueryParamNames().stream().map(queryParamName -> queryParamName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        this.isTracingEnabled = this.tracer.isEnabled();
        this.isMetricsEnabled = this.meter.isEnabled();
    }

    @Override
    public Response<BinaryData> process(HttpRequest request, HttpPipelineNextPolicy next) {
        InstrumentationContext currentContext;
        if (!(this.isTracingEnabled || this.isLoggingEnabled || this.isMetricsEnabled)) {
            return next.process();
        }
        ClientLogger logger = this.getLogger(request);
        long startNs = System.nanoTime();
        String redactedUrl = UrlRedactionUtil.getRedactedUri(request.getUri(), this.allowedQueryParameterNames);
        int tryCount = HttpRequestAccessHelper.getTryCount(request);
        long requestContentLength = HttpInstrumentationPolicy.getContentLength(logger, request.getBody(), request.getHeaders(), true);
        HashMap<String, Object> metricAttributes = this.isMetricsEnabled ? new HashMap<String, Object>(8) : null;
        InstrumentationContext parentContext = request.getContext().getInstrumentationContext();
        SpanBuilder spanBuilder = this.tracer.spanBuilder(request.getHttpMethod().toString(), SpanKind.CLIENT, parentContext);
        this.setStartAttributes(request, redactedUrl, spanBuilder, metricAttributes);
        Span span = spanBuilder.startSpan();
        InstrumentationContext instrumentationContext = currentContext = span.getInstrumentationContext().isValid() ? span.getInstrumentationContext() : parentContext;
        if (currentContext != null && currentContext.isValid()) {
            request.setContext(request.getContext().toBuilder().setInstrumentationContext(currentContext).build());
            this.traceContextPropagator.inject(currentContext, request.getHeaders(), SETTER);
        }
        this.logRequest(logger, request, startNs, requestContentLength, redactedUrl, tryCount, currentContext);
        try {
            Response<BinaryData> response3;
            TracingScope scope;
            block19: {
                scope = span.makeCurrent();
                try {
                    response3 = next.process();
                    if (response3 != null) break block19;
                    LOGGER.atError().setInstrumentationContext(span.getInstrumentationContext()).addKeyValue("http.request.method", (Object)request.getHttpMethod()).addKeyValue("url.full", redactedUrl).log("HTTP response is null and no exception is thrown. Please report it to the client library maintainers.");
                    Response<BinaryData> response2 = null;
                    if (scope != null) {
                        scope.close();
                    }
                    return response2;
                }
                catch (Throwable response3) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable) {
                                response3.addSuppressed(throwable);
                            }
                        }
                        throw response3;
                    }
                    catch (RuntimeException t) {
                        Throwable cause = HttpInstrumentationPolicy.unwrap(t);
                        if (metricAttributes != null) {
                            metricAttributes.put("error.type", cause.getClass().getCanonicalName());
                        }
                        span.end(cause);
                        throw this.logException(logger, request, null, t, startNs, null, requestContentLength, redactedUrl, tryCount, currentContext);
                    }
                }
            }
            this.addDetails(request, response3.getStatusCode(), tryCount, span, metricAttributes);
            response3 = this.logResponse(logger, response3, startNs, requestContentLength, redactedUrl, tryCount, currentContext);
            span.end();
            Response<BinaryData> response4 = response3;
            if (scope != null) {
                scope.close();
            }
            return response4;
        }
        finally {
            if (this.isMetricsEnabled) {
                this.httpRequestDuration.record((double)(System.nanoTime() - startNs) / 1.0E9, this.instrumentation.createAttributes(metricAttributes), currentContext);
            }
        }
    }

    private void setStartAttributes(HttpRequest request, String sanitizedUrl, SpanBuilder spanBuilder, Map<String, Object> metricAttributes) {
        if (!this.isTracingEnabled && !this.isMetricsEnabled) {
            return;
        }
        int port = InstrumentationUtils.getServerPort(request.getUri());
        if (this.isTracingEnabled) {
            spanBuilder.setAttribute("http.request.method", request.getHttpMethod().toString()).setAttribute("url.full", sanitizedUrl).setAttribute("server.address", request.getUri().getHost());
            if (port > 0) {
                spanBuilder.setAttribute("server.port", port);
            }
        }
        if (this.isMetricsEnabled) {
            metricAttributes.put("http.request.method", request.getHttpMethod().toString());
            metricAttributes.put("server.address", request.getUri().getHost());
            if (port > 0) {
                metricAttributes.put("server.port", port);
            }
        }
    }

    private void addDetails(HttpRequest request, int statusCode, int tryCount, Span span, Map<String, Object> metricAttributes) {
        if (!span.isRecording() && !this.isMetricsEnabled) {
            return;
        }
        String error = null;
        if (statusCode >= 400) {
            error = String.valueOf(statusCode);
        }
        if (span.isRecording()) {
            String userAgent;
            span.setAttribute("http.response.status_code", statusCode);
            if (tryCount > 0) {
                span.setAttribute("http.request.resend_count", tryCount);
            }
            if ((userAgent = request.getHeaders().getValue(HttpHeaderName.USER_AGENT)) != null) {
                span.setAttribute("user_agent.original", userAgent);
            }
            if (error != null) {
                span.setError(error);
            }
        }
        if (this.isMetricsEnabled) {
            if (statusCode > 0) {
                metricAttributes.put("http.response.status_code", statusCode);
            }
            if (error != null) {
                metricAttributes.put("error.type", error);
            }
        }
    }

    private static Throwable unwrap(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private ClientLogger getLogger(HttpRequest httpRequest) {
        ClientLogger logger = null;
        if (httpRequest.getContext() != null && httpRequest.getContext().getLogger() != null) {
            logger = httpRequest.getContext().getLogger();
        }
        return logger == null ? LOGGER : logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getProperties(String propertiesFileName) {
        try (InputStream inputStream = HttpInstrumentationPolicy.class.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException ex) {
            LOGGER.atWarning().addKeyValue("propertiesFileName", propertiesFileName).log("Failed to read properties.", ex);
        }
        return Collections.emptyMap();
    }

    private void logRequest(ClientLogger logger, HttpRequest request, long startNanoTime, long requestContentLength, String redactedUrl, int tryCount, InstrumentationContext context) {
        LoggingEvent logBuilder = logger.atLevel(HTTP_REQUEST_LOG_LEVEL);
        if (!logBuilder.isEnabled() || !this.isLoggingEnabled) {
            return;
        }
        logBuilder.setEventName("http.request").setInstrumentationContext(context).addKeyValue("http.request.method", (Object)request.getHttpMethod()).addKeyValue("url.full", redactedUrl).addKeyValue("http.request.resend_count", tryCount).addKeyValue("http.request.body.size", requestContentLength);
        this.addHeadersToLogMessage(request.getHeaders(), logBuilder);
        if (this.isContentLoggingEnabled && HttpInstrumentationPolicy.canLogBody(request.getBody())) {
            try {
                BinaryData bufferedBody = request.getBody().toReplayableBinaryData();
                request.setBody(bufferedBody);
                logBuilder.addKeyValue("http.request.body.content", bufferedBody.toString());
            }
            catch (RuntimeException e) {
                throw this.logException(logger, request, null, e, startNanoTime, null, requestContentLength, redactedUrl, tryCount, context);
            }
        }
        logBuilder.log();
    }

    private Response<BinaryData> logResponse(ClientLogger logger, Response<BinaryData> response, long startNanoTime, long requestContentLength, String redactedUrl, int tryCount, InstrumentationContext context) {
        LoggingEvent logBuilder = logger.atLevel(HTTP_RESPONSE_LOG_LEVEL);
        if (!this.isLoggingEnabled) {
            return response;
        }
        long responseStartNanoTime = System.nanoTime();
        if (logBuilder.isEnabled()) {
            logBuilder.setEventName("http.response").setInstrumentationContext(context).addKeyValue("http.request.method", (Object)response.getRequest().getHttpMethod()).addKeyValue("http.request.resend_count", tryCount).addKeyValue("url.full", redactedUrl).addKeyValue("http.request.time_to_response", this.getDurationMs(startNanoTime, responseStartNanoTime)).addKeyValue("http.response.status_code", response.getStatusCode()).addKeyValue("http.request.body.size", requestContentLength).addKeyValue("http.response.body.size", HttpInstrumentationPolicy.getContentLength(logger, response.getValue(), response.getHeaders(), false));
            this.addHeadersToLogMessage(response.getHeaders(), logBuilder);
        }
        if (this.isContentLoggingEnabled && HttpInstrumentationPolicy.canLogBody(response.getValue())) {
            return new LoggingHttpResponse(response, content -> {
                if (logBuilder.isEnabled()) {
                    logBuilder.addKeyValue("http.request.body.content", content.toString()).addKeyValue("http.request.duration", this.getDurationMs(startNanoTime, System.nanoTime())).log();
                }
            }, throwable -> this.logException(logger, response.getRequest(), response, throwable, startNanoTime, responseStartNanoTime, requestContentLength, redactedUrl, tryCount, context));
        }
        if (logBuilder.isEnabled()) {
            logBuilder.addKeyValue("http.request.duration", this.getDurationMs(startNanoTime, System.nanoTime())).log();
        }
        return response;
    }

    private <T extends Throwable> T logException(ClientLogger logger, HttpRequest request, Response<BinaryData> response, T throwable, long startNanoTime, Long responseStartNanoTime, long requestContentLength, String redactedUrl, int tryCount, InstrumentationContext context) {
        LoggingEvent log = logger.atLevel(LogLevel.WARNING);
        if (!log.isEnabled() || !this.isLoggingEnabled) {
            return throwable;
        }
        log.setEventName("http.response").setInstrumentationContext(context).addKeyValue("http.request.method", (Object)request.getHttpMethod()).addKeyValue("http.request.resend_count", tryCount).addKeyValue("url.full", redactedUrl).addKeyValue("http.request.body.size", requestContentLength).addKeyValue("http.request.duration", this.getDurationMs(startNanoTime, System.nanoTime()));
        if (response != null) {
            this.addHeadersToLogMessage(response.getHeaders(), log);
            log.addKeyValue("http.response.body.size", HttpInstrumentationPolicy.getContentLength(logger, response.getValue(), response.getHeaders(), false)).addKeyValue("http.response.status_code", response.getStatusCode());
            if (responseStartNanoTime != null) {
                log.addKeyValue("http.request.time_to_response", this.getDurationMs(startNanoTime, responseStartNanoTime));
            }
        }
        log.log(null, HttpInstrumentationPolicy.unwrap(throwable));
        return throwable;
    }

    private double getDurationMs(long startNs, long endNs) {
        return (double)(endNs - startNs) / 1000000.0;
    }

    private static boolean canLogBody(BinaryData data) {
        return data != null && data.getLength() != null && data.getLength() > 0L && data.getLength() < 16384L;
    }

    private void addHeadersToLogMessage(HttpHeaders headers, LoggingEvent logBuilder) {
        headers.stream().forEach(header -> {
            HttpHeaderName headerName = header.getName();
            if (this.allowedHeaderNames.contains(headerName)) {
                logBuilder.addKeyValue(headerName.toString(), header.getValue());
            } else if (this.isRedactedHeadersLoggingEnabled) {
                logBuilder.addKeyValue(headerName.toString(), REDACTED_PLACEHOLDER);
            }
        });
    }

    private static long getContentLength(ClientLogger logger, BinaryData body, HttpHeaders headers, boolean isRequest) {
        if (body == null) {
            return 0L;
        }
        if (body.getLength() != null) {
            return body.getLength();
        }
        long contentLength = 0L;
        String contentLengthString = headers.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (CoreUtils.isNullOrEmpty(contentLengthString)) {
            return contentLength;
        }
        try {
            contentLength = Long.parseLong(contentLengthString);
        }
        catch (NumberFormatException e) {
            logger.atVerbose().addKeyValue(isRequest ? "http.request.header.content-length" : "http.response.header.content-length", contentLengthString).log("Could not parse the HTTP header content-length", e);
        }
        return contentLength;
    }

    @Override
    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.INSTRUMENTATION;
    }

    static {
        SETTER = (headers, name, value) -> headers.set(HttpHeaderName.fromString(name), value);
        Map<String, String> properties = HttpInstrumentationPolicy.getProperties("core.properties");
        SDK_NAME = properties.getOrDefault("name", "unknown");
        SDK_VERSION = properties.getOrDefault("version", "unknown");
        SdkInstrumentationOptions sdkOptions = new SdkInstrumentationOptions(SDK_NAME).setSdkVersion(SDK_VERSION).setSchemaUrl("https://opentelemetry.io/schemas/1.29.0");
        SdkInstrumentationOptionsAccessHelper.disableSpanSuppression(sdkOptions);
        SDK_OPTIONS = sdkOptions;
        REQUEST_DURATION_BOUNDARIES_ADVICE = Collections.unmodifiableList(Arrays.asList(0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0));
        HTTP_REQUEST_LOG_LEVEL = LogLevel.VERBOSE;
        HTTP_RESPONSE_LOG_LEVEL = LogLevel.INFORMATIONAL;
    }

    private static final class LoggingHttpResponse
    extends Response<BinaryData> {
        private final Consumer<BinaryData> onContent;
        private final Consumer<Throwable> onException;
        private final BinaryData originalBody;
        private BinaryData bufferedBody;

        private LoggingHttpResponse(Response<BinaryData> actualResponse, Consumer<BinaryData> onContent, Consumer<Throwable> onException) {
            super(actualResponse.getRequest(), actualResponse.getStatusCode(), actualResponse.getHeaders(), actualResponse.getValue());
            this.onContent = onContent;
            this.onException = onException;
            this.originalBody = actualResponse.getValue();
        }

        @Override
        public BinaryData getValue() {
            if (this.bufferedBody != null) {
                return this.bufferedBody;
            }
            try {
                this.bufferedBody = this.originalBody.toReplayableBinaryData();
                this.onContent.accept(this.bufferedBody);
                return this.bufferedBody;
            }
            catch (RuntimeException e) {
                this.onException.accept(e);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.bufferedBody == null) {
                this.getValue();
            }
            if (this.bufferedBody != null) {
                this.bufferedBody.close();
            }
            this.originalBody.close();
        }
    }
}

