/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.RequestContext;
import io.clientcore.core.http.models.ServerSentEventListener;
import io.clientcore.core.implementation.http.HttpRequestAccessHelper;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class HttpRequest {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRequest.class);
    private HttpMethod httpMethod;
    private URI uri;
    private HttpHeaders headers = new HttpHeaders();
    private BinaryData body;
    private ServerSentEventListener serverSentEventListener;
    private RequestContext requestContext = RequestContext.none();
    private int tryCount;

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public HttpRequest setMethod(HttpMethod httpMethod) {
        this.httpMethod = Objects.requireNonNull(httpMethod, "'httpMethod' cannot be null");
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpRequest setUri(URI uri) {
        this.uri = Objects.requireNonNull(uri, "'uri' cannot be null");
        return this;
    }

    public HttpRequest setUri(String uri) {
        try {
            this.uri = new URI(Objects.requireNonNull(uri, "'uri' cannot be null"));
        }
        catch (URISyntaxException ex) {
            throw LOGGER.logThrowableAsError(new IllegalArgumentException("'uri' must be a valid URI.", ex));
        }
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public BinaryData getBody() {
        return this.body;
    }

    public HttpRequest setBody(BinaryData content) {
        this.body = content;
        if (content != null && content.getLength() != null) {
            this.headers.set(HttpHeaderName.CONTENT_LENGTH, String.valueOf(content.getLength()));
        }
        return this;
    }

    public RequestContext getContext() {
        return this.requestContext;
    }

    public HttpRequest setContext(RequestContext requestContext) {
        this.requestContext = requestContext == null ? RequestContext.none() : requestContext;
        return this;
    }

    public ServerSentEventListener getServerSentEventListener() {
        return this.serverSentEventListener;
    }

    public HttpRequest setServerSentEventListener(ServerSentEventListener serverSentEventListener) {
        this.serverSentEventListener = serverSentEventListener;
        return this;
    }

    private int getTryCount() {
        return this.tryCount;
    }

    private HttpRequest setTryCount(int tryCount) {
        this.tryCount = tryCount;
        return this;
    }

    static {
        HttpRequestAccessHelper.setAccessor(new HttpRequestAccessHelper.HttpRequestAccessor(){

            @Override
            public int getTryCount(HttpRequest httpRequest) {
                return httpRequest.getTryCount();
            }

            @Override
            public HttpRequest setTryCount(HttpRequest httpRequest, int tryCount) {
                return httpRequest.setTryCount(tryCount);
            }
        });
    }
}

