/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.http.models.HttpHeader;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.utils.CoreUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpHeaders {
    private final Map<HttpHeaderName, HttpHeader> headers;

    public HttpHeaders() {
        this.headers = new HashMap<HttpHeaderName, HttpHeader>();
    }

    public HttpHeaders(HttpHeaders headers) {
        this.headers = new HashMap<HttpHeaderName, HttpHeader>((int)((float)headers.headers.size() / 0.75f));
        headers.headers.forEach((key, value) -> this.headers.put((HttpHeaderName)key, new HttpHeader(value.getName(), value.getValues())));
    }

    public HttpHeaders(int initialCapacity) {
        this.headers = new HashMap<HttpHeaderName, HttpHeader>(initialCapacity);
    }

    public int getSize() {
        return this.headers.size();
    }

    public HttpHeaders add(HttpHeader header) {
        return this.add(header.getName(), header.getValues());
    }

    public HttpHeaders add(HttpHeaderName name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.headers.compute(name, (key, header) -> {
            if (header == null) {
                return new HttpHeader(name, value);
            }
            header.addValue(value);
            return header;
        });
        return this;
    }

    private HttpHeaders add(HttpHeaderName name, List<String> values) {
        if (name == null || CoreUtils.isNullOrEmpty(values)) {
            return this;
        }
        this.headers.compute(name, (key, header) -> {
            if (header == null) {
                return new HttpHeader(name, values);
            }
            for (String value : values) {
                header.addValue(value);
            }
            return header;
        });
        return this;
    }

    public HttpHeaders addAll(HttpHeaders headers) {
        if (headers != null) {
            headers.headers.forEach((headerName, header) -> this.add((HttpHeaderName)headerName, header.getValues()));
        }
        return this;
    }

    public HttpHeaders set(HttpHeaderName name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.headers.put(name, new HttpHeader(name, value));
        }
        return this;
    }

    public HttpHeaders set(HttpHeaderName name, List<String> values) {
        if (name == null) {
            return this;
        }
        if (CoreUtils.isNullOrEmpty(values)) {
            this.remove(name);
        } else {
            this.headers.put(name, new HttpHeader(name, values));
        }
        return this;
    }

    public HttpHeaders setAll(HttpHeaders headers) {
        if (headers != null) {
            headers.headers.forEach((headerName, header) -> this.set((HttpHeaderName)headerName, header.getValues()));
        }
        return this;
    }

    public HttpHeader get(HttpHeaderName name) {
        return this.headers.get(name);
    }

    public HttpHeader remove(HttpHeaderName name) {
        return this.headers.remove(name);
    }

    public String getValue(HttpHeaderName name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValue();
    }

    public List<String> getValues(HttpHeaderName name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValues();
    }

    public Stream<HttpHeader> stream() {
        return this.headers.values().stream();
    }

    public String toString() {
        return this.stream().map(HttpHeader::toString).collect(Collectors.joining(", "));
    }
}

